/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;

public class SAX2DOMHandler
extends HandlerBase {
    private Node _document;
    private Node _parent;
    private StringBuffer _buffer;
    private Stack _parents = new Stack();

    public SAX2DOMHandler(Node node) {
        this._document = node;
        this._buffer = new StringBuffer();
    }

    public void startElement(String name, AttributeList attributes) {
        Node parent = this._parents.size() > 0 ? (Node)this._parents.peek() : this._document;
        Document document = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = document.createElement(name);
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            element.setAttribute(attributes.getName(i), attributes.getValue(i));
            ++i;
        }
        parent.appendChild(element);
        this._parents.push(element);
    }

    public void characters(char[] chars, int offset, int length) {
        this._buffer.append(chars, offset, length);
    }

    public void endElement(String name) {
        Node parent;
        Node node = parent = this._parents.size() > 0 ? (Node)this._parents.peek() : this._document;
        if (this._buffer.length() != 0) {
            Text text = parent.getOwnerDocument().createTextNode(this._buffer.toString());
            parent.appendChild(text);
        }
        this._parents.pop();
        this._buffer.setLength(0);
    }
}

