/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.xml.ClassDescriptorEnumeration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.util.XCDEnumerator;

public class ClassDescriptorResolverImpl
implements ClassDescriptorResolver {
    private static final String DESCRIPTOR_PREFIX = "Descriptor";
    private Hashtable _cache = new Hashtable();
    private boolean _error = false;
    private String _errMessage = null;
    private XMLMappingLoader mappingLoader = null;
    private ClassLoader _loader = null;
    private Introspector _introspector = new Introspector();
    private boolean _useIntrospection = true;

    public ClassDescriptorResolverImpl() {
    }

    public ClassDescriptorResolverImpl(ClassLoader loader) {
        this();
        this._loader = loader;
    }

    public void associate(Class type, XMLClassDescriptor classDesc) {
        this._cache.put(type, classDesc);
    }

    public String getErrorMessage() {
        return this._errMessage;
    }

    public Introspector getIntrospector() {
        return this._introspector;
    }

    public XMLMappingLoader getMappingLoader() {
        return this.mappingLoader;
    }

    public boolean error() {
        return this._error;
    }

    public XMLClassDescriptor resolve(Class type) {
        this.clearError();
        if (type == null) {
            return null;
        }
        XMLClassDescriptor classDesc = (XMLClassDescriptor)this._cache.get(type);
        if (classDesc != null) {
            return classDesc;
        }
        if (this.mappingLoader != null && (classDesc = (XMLClassDescriptor)this.mappingLoader.getDescriptor(type)) != null) {
            this._cache.put(type, classDesc);
            return classDesc;
        }
        String className = type.getName() + DESCRIPTOR_PREFIX;
        try {
            ClassLoader loader = type.getClassLoader();
            Class dClass = this.loadClass(className, loader);
            classDesc = (XMLClassDescriptor)dClass.newInstance();
            this._cache.put(type, classDesc);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception ex) {
            String err = "instantiation error for class: " + className;
            err = err + "; " + ex.toString();
            this.setError(err);
            return null;
        }
        if (classDesc == null && this._useIntrospection) {
            try {
                classDesc = this._introspector.generateClassDescriptor(type);
                if (classDesc != null) {
                    this._cache.put(type, classDesc);
                }
            }
            catch (MarshalException mx) {
                String err = mx.toString();
                this.setError(err);
                return null;
            }
        }
        return classDesc;
    }

    public XMLClassDescriptor resolve(String className) {
        return this.resolve(className, null);
    }

    public XMLClassDescriptor resolve(String className, ClassLoader loader) {
        XMLClassDescriptor classDesc = null;
        if (className == null || className.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length class name.");
            return null;
        }
        Class _class = null;
        try {
            _class = this.loadClass(className, loader);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (_class != null) {
            classDesc = this.resolve(_class);
        } else {
            this.clearError();
        }
        if (classDesc == null && _class == null) {
            String dClassName = className + DESCRIPTOR_PREFIX;
            try {
                Class dClass = this.loadClass(dClassName, loader);
                classDesc = (XMLClassDescriptor)dClass.newInstance();
            }
            catch (InstantiationException ie) {
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        return classDesc;
    }

    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length xml name.");
            return null;
        }
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        if (this.mappingLoader != null) {
            enumeration = this.mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (xmlName.equals(classDesc.getXMLName())) {
                    return classDesc;
                }
                classDesc = null;
            }
        }
        enumeration = this._cache.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (xmlName.equals(classDesc.getXMLName())) {
                return classDesc;
            }
            classDesc = null;
        }
        return classDesc;
    }

    public ClassDescriptorEnumeration resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length xml name.");
            return null;
        }
        XCDEnumerator xcdEnumerator = new XCDEnumerator();
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        if (this.mappingLoader != null) {
            enumeration = this.mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (!xmlName.equals(classDesc.getXMLName())) continue;
                xcdEnumerator.add(classDesc);
            }
        }
        enumeration = this._cache.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (!xmlName.equals(classDesc.getXMLName())) continue;
            xcdEnumerator.add(classDesc);
        }
        return xcdEnumerator;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setIntrospection(boolean enable) {
        this._useIntrospection = enable;
    }

    public void setMappingLoader(XMLMappingLoader mappingLoader) {
        this.mappingLoader = mappingLoader;
    }

    private Class loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            return loader.loadClass(className);
        }
        if (this._loader != null) {
            return this._loader.loadClass(className);
        }
        return Class.forName(className);
    }

    private void clearError() {
        this._error = false;
    }

    private void setError(String message) {
        this._error = true;
        this._errMessage = message;
    }
}

