/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.exolab.castor.util.CmdLineOption;
import org.exolab.castor.util.Messages;

public class CommandLineOptions {
    Vector flags = new Vector();
    Hashtable optionInfo = new Hashtable();
    PrintWriter errorWriter = new PrintWriter(System.out);

    public void addFlag(String flag) {
        this.addFlag(flag, null, null);
    }

    public void addFlag(String flag, String comment) {
        this.addFlag(flag, null, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment) {
        this.addFlag(flag, usageText, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment, boolean optional) {
        if (flag == null) {
            return;
        }
        this.flags.addElement(flag);
        CmdLineOption opt = new CmdLineOption(flag);
        opt.setComment(comment);
        opt.setUsageText(usageText);
        opt.setOptional(optional);
        this.optionInfo.put(flag, opt);
    }

    public Properties getOptions(String[] args) {
        Properties options = new Properties();
        String flag = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (flag != null) {
                    ((Hashtable)options).put(flag, args[i]);
                    ((Hashtable)options).put(new Integer(i), args[i]);
                }
                if (!this.flags.contains(flag = args[i].substring(1))) {
                    int idx = 1;
                    while (idx <= flag.length()) {
                        if (this.flags.contains(flag.substring(0, idx))) {
                            if (idx < flag.length()) {
                                ((Hashtable)options).put(flag.substring(0, idx), flag.substring(idx));
                                break;
                            }
                        } else if (idx == flag.length()) {
                            this.errorWriter.println(Messages.format("misc.invalidCLIOption", "-" + flag));
                            this.printUsage(this.errorWriter);
                        }
                        ++idx;
                    }
                }
            } else {
                if (flag != null) {
                    ((Hashtable)options).put(flag, args[i]);
                }
                ((Hashtable)options).put(new Integer(i), args[i]);
                flag = null;
            }
            ++i;
        }
        if (flag != null) {
            ((Hashtable)options).put(flag, "no value");
        }
        return options;
    }

    public void setComment(String flag, String comment) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setComment(comment);
        }
    }

    public void setOptional(String flag, boolean optional) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setOptional(optional);
        }
    }

    public void setUsageInfo(String flag, String usage) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setUsageText(usage);
        }
    }

    public void printUsage(PrintWriter pw) {
        pw.println();
        pw.print(Messages.message("misc.CLIUsage"));
        int i = 0;
        while (i < this.flags.size()) {
            String flag = (String)this.flags.elementAt(i);
            CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
            if (opt.getOptional()) {
                pw.print(" [-");
            } else {
                pw.print(" -");
            }
            pw.print(flag);
            String usage = opt.getUsageText();
            if (usage != null) {
                pw.print(' ');
                pw.print(usage);
            }
            if (opt.getOptional()) {
                pw.print(']');
            }
            ++i;
        }
        pw.println();
        pw.flush();
    }

    public void printHelp(PrintWriter pw) {
        this.printUsage(pw);
        pw.println();
        if (this.flags.size() > 0) {
            pw.println("Flag               Description");
            pw.println("----------------------------------------------");
        }
        int i = 0;
        while (i < this.flags.size()) {
            String flag = (String)this.flags.elementAt(i);
            CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
            pw.print('-');
            pw.print(flag);
            pw.print(' ');
            int spaces = 17 - flag.length();
            while (spaces > 0) {
                pw.print(' ');
                --spaces;
            }
            pw.print(opt.getComment());
            pw.println();
            ++i;
        }
        pw.println();
        pw.flush();
    }
}

