/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDouble
extends XSPatternBase {
    Double maxInclusive = null;
    Double maxExclusive = null;
    Double minInclusive = null;
    Double minExclusive = null;
    private static JType jType = JType.Double;
    private boolean _asWrapper = false;

    public XSDouble() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSDouble(boolean asWrapper) {
        super((short)15);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Double") : JType.Double;
    }

    public JType getJType() {
        return jType;
    }

    public Double getMaxExclusive() {
        return this.maxExclusive;
    }

    public Double getMaxInclusive() {
        return this.maxInclusive;
    }

    public Double getMinExclusive() {
        return this.minExclusive;
    }

    public Double getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(double max) {
        this.maxExclusive = new Double(max);
    }

    public void setMaxExclusive(Double max) {
        this.maxExclusive = max;
    }

    public void setMaxInclusive(double max) {
        this.maxInclusive = new Double(max);
    }

    public void setMaxInclusive(Double max) {
        this.maxInclusive = max;
    }

    public void setMinExclusive(double min) {
        this.minExclusive = new Double(min);
    }

    public void setMinExclusive(Double min) {
        this.minExclusive = min;
    }

    public void setMinInclusive(double min) {
        this.minInclusive = new Double(min);
    }

    public void setMinInclusive(Double min) {
        this.minInclusive = min;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toDouble());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toDouble());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toDouble());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toDouble());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new Double(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((Double)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".doubleValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("DoubleValidator typeValidator = new DoubleValidator();");
        if (this.hasMinimum()) {
            Double min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append(min.toString());
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Double max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append(max.toString());
            jsc.append(");");
        }
        if (fixedValue != null) {
            Double test = new Double(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSType.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

