/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyMain;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeTestSwing;
import cytoscape.view.CyNetworkView;
import giny.view.NodeView;
import java.awt.Robot;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import junit.framework.TestCase;
import swingunit.extensions.ExtendedRobotEventFactory;
import swingunit.framework.EventPlayer;
import swingunit.framework.ExecuteException;
import swingunit.framework.FinderMethodSet;
import swingunit.framework.RobotEventFactory;
import swingunit.framework.Scenario;
import swingunit.framework.TestUtility;

public class Tutorial1TestSwing
extends TestCase {
    private Scenario scenario;
    private RobotEventFactory robotEventFactory = new ExtendedRobotEventFactory();
    private FinderMethodSet methodSet = new FinderMethodSet();
    private Robot robot;
    private CyMain application;

    protected void setUp() throws Exception {
        System.setProperty("TestSetting", "testData/TestSetting.properties");
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String[] args = new String[]{"-p", "plugins/core"};
                    Tutorial1TestSwing.this.application = new CyMain(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeAndWait(r);
        this.robot = new Robot();
        TestUtility.waitForCalm();
        String filePath = CytoscapeTestSwing.class.getResource("CytoscapeSwingUnitOperations.xml").getFile();
        this.scenario = new Scenario(this.robotEventFactory, this.methodSet);
        this.scenario.read(filePath);
    }

    protected void tearDown() throws Exception {
        this.application = null;
        this.scenario = null;
        this.robot = null;
    }

    public void testTutorialOne() throws ExecuteException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        EventPlayer player = new EventPlayer(this.scenario);
        player.run(this.robot, "SHOW_HIDE_ATTRIBUTE_BROWSER");
        player.run(this.robot, "IMPORT_REMOTE_SIF_FILE");
        Tutorial1TestSwing.assertEquals((int)1, (int)Cytoscape.getNetworkSet().size());
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        Tutorial1TestSwing.assertNotNull((Object)view);
        player.run(this.robot, "APPLY_SPRING_LAYOUT");
        this.scenario.setTestSetting("SELECT_NODE_BY_NAME", "NODE_NAME", "7157");
        player.run(this.robot, "SELECT_NODE_BY_NAME");
        List selNodes = view.getSelectedNodes();
        Tutorial1TestSwing.assertEquals((String)"num selected nodes", (int)1, (int)selNodes.size());
        Tutorial1TestSwing.assertEquals((String)"node id", (String)"7157", (String)((NodeView)selNodes.get(0)).getNode().getIdentifier());
        player.run(this.robot, "SELECT_FIRST_NEIGHBORS");
        selNodes = view.getSelectedNodes();
        Tutorial1TestSwing.assertEquals((String)"num selected neighbor nodes", (int)64, (int)selNodes.size());
        player.run(this.robot, "NEW_NETWORK_FROM_SELECTED_NODES_ALL_EDGES");
        Tutorial1TestSwing.assertEquals((String)"Number of networks in this session", (int)2, (int)Cytoscape.getNetworkSet().size());
        this.scenario.setTestSetting("IMPORT_NODE_ATTRIBUTES", "FILE_TO_IMPORT", "RUAL.na");
        this.scenario.setTestSetting("IMPORT_NODE_ATTRIBUTES", "IMPORT_DIR", "testData");
        player.run(this.robot, "IMPORT_NODE_ATTRIBUTES");
        Tutorial1TestSwing.assertEquals((String)"node attr", (String)"TP53", (String)Cytoscape.getNodeAttributes().getStringAttribute("7157", "Official HUGO Symbol"));
        Tutorial1TestSwing.assertEquals((String)"node attr", (String)"GORASP2", (String)Cytoscape.getNodeAttributes().getStringAttribute("26003", "Official HUGO Symbol"));
        Tutorial1TestSwing.assertEquals((String)"node attr", (String)"RUFY1", (String)Cytoscape.getNodeAttributes().getStringAttribute("80230", "Official HUGO Symbol"));
        player.run(this.robot, "SET_VIZMAPPER");
        player.run(this.robot, "APPLY_SPRING_LAYOUT");
        player.run(this.robot, "ZOOM_IN_AND_OUT");
        player.run(this.robot, "TEST_FILTER_1");
        Tutorial1TestSwing.assertEquals((String)"Number of Selected Edges", (int)660, (int)Cytoscape.getCurrentNetwork().getSelectedEdges().size());
        player.run(this.robot, "DELETE_SELECTED_EDGES");
    }
}

