/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.baderlab.brain.Hit;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.util.CRC64;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.IllegalSymbolException;

public class SequenceSearchResultSet {
    private ProteinDatabaseSearchParams params = null;
    private long numberOfSequencesSearched = 0L;
    private long numberOfHits = 0L;
    private HashMap results = null;
    private HashMap hashResults = null;
    private HashMap annotatedSequenceMap = null;
    private TreeMap sortedResultMap = null;
    private String species;
    private ProteinProfile profile = null;
    private double scoreThreshold = 0.0;
    private String regex = null;

    public SequenceSearchResultSet(double scoreThreshold, ProteinDatabaseSearchParams params) {
        this.scoreThreshold = scoreThreshold;
        this.params = params;
        this.results = new HashMap();
        this.hashResults = new HashMap();
    }

    public SequenceSearchResultSet(ProteinDatabaseSearchParams params) {
        this.params = params;
        this.results = new HashMap();
        this.hashResults = new HashMap();
    }

    private String uniqueSequenceHash(Sequence sequence) {
        CRC64 crc = new CRC64();
        crc.update(sequence.getName());
        crc.update(sequence.seqString());
        long digest = crc.getValue();
        return String.valueOf(digest);
    }

    private Sequence findLookupSequence(Sequence sequenceHit, boolean remember) {
        Sequence lookupSequence = null;
        if (!this.hashResults.containsKey(this.uniqueSequenceHash(sequenceHit))) {
            if (remember) {
                this.hashResults.put(this.uniqueSequenceHash(sequenceHit), sequenceHit);
                lookupSequence = sequenceHit;
            }
        } else {
            lookupSequence = (Sequence)this.hashResults.get(this.uniqueSequenceHash(sequenceHit));
        }
        return lookupSequence;
    }

    public void addSequenceHit(Sequence sequenceHit, int hitStart, int hitEnd, Double score) {
        ArrayList hits = null;
        Sequence lookupSequence = this.findLookupSequence(sequenceHit, true);
        hits = !this.results.containsKey(lookupSequence) ? new ArrayList() : (ArrayList)this.results.get(lookupSequence);
        ArrayList scoreHits = null;
        if (this.sortedResultMap != null) {
            scoreHits = !this.sortedResultMap.containsKey(score) ? new ArrayList() : (ArrayList)this.sortedResultMap.get(score);
        }
        Hit hit = new Hit(hitStart, hitEnd, lookupSequence);
        if (score != null) {
            hit.setScore(score);
        }
        hits.add(hit);
        this.results.put(lookupSequence, hits);
        if (scoreHits != null) {
            scoreHits.add(hit);
            this.sortedResultMap.put(score, scoreHits);
        }
        ++this.numberOfHits;
    }

    public void addSequenceHit(Sequence sequenceHit, int hitStart, int hitEnd) {
        this.addSequenceHit(sequenceHit, hitStart, hitEnd, null);
    }

    public void addSequenceHit(Double score) {
        if (score == null) {
            throw new IllegalArgumentException("Score was null.");
        }
        Hit hit = new Hit();
        hit.setScore(score);
        ArrayList scoreHits = null;
        if (this.sortedResultMap != null) {
            scoreHits = !this.sortedResultMap.containsKey(score) ? new ArrayList() : (ArrayList)this.sortedResultMap.get(score);
            scoreHits.add(hit);
            this.sortedResultMap.put(score, scoreHits);
        }
        ++this.numberOfHits;
    }

    public void addOriginalSequenceToHit(Sequence sequenceHit, Sequence originalSequence) {
        Sequence lookupSequence = this.findLookupSequence(sequenceHit, false);
        if (lookupSequence == null) {
            return;
        }
        if (this.annotatedSequenceMap == null) {
            this.annotatedSequenceMap = new HashMap();
        }
        this.annotatedSequenceMap.put(lookupSequence, originalSequence);
    }

    public void setNumberOfSequencesSearched(long numberOfSequencesSearched) {
        this.numberOfSequencesSearched = numberOfSequencesSearched;
    }

    public void setProfile(ProteinProfile profile) {
        this.profile = profile;
        this.sortedResultMap = new TreeMap();
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public Set getSequences() {
        return this.results.keySet();
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public Sequence getOriginalSequence(Sequence sequenceHit) {
        return (Sequence)this.annotatedSequenceMap.get(sequenceHit);
    }

    public int getNumberSequencesHit() {
        return this.results.size();
    }

    public List getHits(Sequence sequence) {
        return (ArrayList)this.results.get(sequence);
    }

    public long getNumberOfSequencesSearched() {
        return this.numberOfSequencesSearched;
    }

    public long getNumberOfHits() {
        return this.numberOfHits;
    }

    public ProteinProfile getProfile() {
        return this.profile;
    }

    public String getRegex() {
        return this.regex;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public SequenceSearchResultSet getUniqueResultsBySequence() {
        Object[] oldResultObject;
        SequenceSearchResultSet uniqueResults = new SequenceSearchResultSet(this.scoreThreshold, this.params);
        uniqueResults.setProfile(this.profile);
        uniqueResults.setRegex(this.regex);
        uniqueResults.setNumberOfSequencesSearched(this.numberOfSequencesSearched);
        HashMap<String, Object[]> uniqueSequenceStrings = new HashMap<String, Object[]>();
        Set sequences = this.results.keySet();
        for (Sequence sequence : sequences) {
            String seqString = sequence.seqString();
            oldResultObject = new Object[]{sequence, this.results.get(sequence)};
            if (uniqueSequenceStrings.containsKey(seqString)) {
                Sequence oldSequence = (Sequence)((Object[])uniqueSequenceStrings.get(seqString))[0];
                try {
                    oldResultObject[0] = ProteinTools.createProteinSequence((String)seqString, (String)(oldSequence.getName() + " " + sequence.getName()));
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
            }
            uniqueSequenceStrings.put(seqString, oldResultObject);
        }
        Set uniqueSequences = uniqueSequenceStrings.keySet();
        for (String seqString : uniqueSequences) {
            oldResultObject = (Object[])uniqueSequenceStrings.get(seqString);
            uniqueResults.results.put((Sequence)oldResultObject[0], (ArrayList)oldResultObject[1]);
        }
        return uniqueResults;
    }

    private boolean sequenceSeenBefore(HashMap sequenceTracker, Sequence sequence) {
        if (!sequenceTracker.containsKey(sequence)) {
            sequenceTracker.put(sequence, sequence);
            return false;
        }
        return true;
    }

    public SequenceSearchResultSet getTopPercentileResults(double percentage) {
        if (this.profile == null) {
            return null;
        }
        if (percentage <= 0.0) {
            percentage = 0.0;
            return null;
        }
        if (percentage >= 100.0) {
            return this;
        }
        SequenceSearchResultSet newResultSet = new SequenceSearchResultSet(this.scoreThreshold, this.params);
        newResultSet.setProfile(this.profile);
        newResultSet.setSpecies(this.species);
        newResultSet.setNumberOfSequencesSearched(this.numberOfSequencesSearched);
        long numberSequences = (long)Math.ceil((double)this.getNumberSequencesHit() * (percentage / 100.0));
        HashMap sequenceTracker = new HashMap();
        Set scores = this.sortedResultMap.keySet();
        int i = 0;
        for (Double score : scores) {
            ArrayList hits = (ArrayList)this.sortedResultMap.get(score);
            for (int j = 0; j < hits.size(); ++j) {
                Hit hit = (Hit)hits.get(j);
                newResultSet.addSequenceHit(hit.getSequence(), hit.getStart(), hit.getEnd(), hit.getScore());
                newResultSet.addOriginalSequenceToHit(hit.getSequence(), this.getOriginalSequence(hit.getSequence()));
                if (this.sequenceSeenBefore(sequenceTracker, hit.getSequence())) continue;
                ++i;
            }
            if ((long)i < numberSequences) continue;
            break;
        }
        return newResultSet;
    }

    public SequenceSearchResultSet getTopResults(int numberResults) {
        if (this.profile == null) {
            return null;
        }
        if ((double)numberResults <= 0.0) {
            return null;
        }
        if ((long)numberResults >= this.getNumberOfHits()) {
            return this;
        }
        double percentage = (double)numberResults / (double)this.getNumberSequencesHit() * 100.0;
        return this.getTopPercentileResults(percentage);
    }

    public List getBestHits() {
        ArrayList hits;
        block1: {
            if (this.profile == null) {
                return null;
            }
            hits = null;
            Set resultSet = this.sortedResultMap.keySet();
            Iterator iterator = resultSet.iterator();
            if (!iterator.hasNext()) break block1;
            Double score = (Double)iterator.next();
            hits = (ArrayList)this.sortedResultMap.get(score);
        }
        return hits;
    }

    public void mergeResultsFrom(SequenceSearchResultSet resultSetToMerge) {
        Set toMerge = resultSetToMerge.getSequences();
        for (Sequence sequence : toMerge) {
            List hits = resultSetToMerge.getHits(sequence);
            for (int i = 0; i < hits.size(); ++i) {
                Hit hit = (Hit)hits.get(i);
                this.addSequenceHit(sequence, hit.getStart(), hit.getEnd(), hit.getScore());
            }
        }
    }

    public void clear() {
        this.results.clear();
        this.hashResults.clear();
        if (this.annotatedSequenceMap != null) {
            this.annotatedSequenceMap.clear();
        }
        this.sortedResultMap.clear();
    }

    public int[] getScoreHistogram(int highestScoreThreshold) {
        if (this.profile == null) {
            return null;
        }
        int[] histogram = new int[highestScoreThreshold + 1];
        ArrayList hits = null;
        Set resultSet = this.sortedResultMap.keySet();
        for (Double score : resultSet) {
            hits = (ArrayList)this.sortedResultMap.get(score);
            int n = (int)Math.ceil(score);
            histogram[n] = histogram[n] + hits.size();
        }
        return histogram;
    }

    public String toString() {
        if (this.results == null) {
            return null;
        }
        String lineSep = System.getProperty("line.separator");
        if (this.results.size() == 0) {
            if (this.profile != null) {
                return new String("No results for " + this.profile.getName() + lineSep);
            }
            return new String("No results for " + this.regex + lineSep);
        }
        StringBuffer sb = new StringBuffer();
        Set resultSet = null;
        AbstractMap generalResultMap = null;
        if (this.profile != null) {
            sb.append("Profile description: " + this.profile.getName() + lineSep);
            sb.append("Peptides in profile: " + this.profile.getNumSequences() + lineSep);
            sb.append("Sequences searched: " + this.getNumberOfSequencesSearched() + lineSep);
            sb.append("Sequences hit: " + this.getNumberSequencesHit() + lineSep);
            sb.append("Hits: " + this.getNumberOfHits() + lineSep);
            sb.append("MatchPosition\tScore\tName\tMatch\tSequence" + lineSep);
            generalResultMap = this.sortedResultMap;
        } else if (this.regex != null) {
            sb.append("Pattern: " + this.regex + lineSep);
            sb.append("Number sequences searched: " + this.getNumberOfSequencesSearched() + lineSep);
            sb.append("Number sequences hit: " + this.getNumberSequencesHit() + lineSep);
            sb.append("Number hits: " + this.getNumberOfHits() + lineSep);
            sb.append("MatchPosition\tName\tMatch\tSequence" + lineSep);
            generalResultMap = this.results;
        } else {
            throw new RuntimeException("SequenceSearchResultSet does not contain a regex or profile.");
        }
        ArrayList hits = null;
        resultSet = generalResultMap.keySet();
        for (Object keyObject : resultSet) {
            hits = (ArrayList)generalResultMap.get(keyObject);
            for (int i = 0; i < hits.size(); ++i) {
                Hit hit = (Hit)hits.get(i);
                sb.append(hit.getStart() + "-" + hit.getEnd());
                if (this.profile != null) {
                    sb.append("\t" + hit.getScore());
                }
                sb.append("\t" + hit.getSequence().getName() + "\t" + hit.getMatchString() + "\t" + hit.getSequence().seqString() + lineSep);
            }
        }
        return sb.toString();
    }
}

