/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainplugin.analyses;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceLogo;

public class WWAnalysis {
    public static void main(String[] args) {
        WWAnalysis.runMultiSequenceSearch();
    }

    private static void runMultiSequenceSearch() {
        BrainAlgorithm alg = new BrainAlgorithm();
        System.out.println("Testing [mdharsee]...");
        BrainParameterSet params = new BrainParameterSet();
        params.setProfileFileName(new File("/Users/moyez/Code/wwdata/profiles_2007Feb21/D00003.od5.pep.txt"));
        params.setFuzzFactor(1.0);
        params.setDatabaseFileName(new File("/Users/moyez/Code/seqdata/human.protein.gpff"));
        params.setDatabaseFormat("genpept");
        params.setScoreThreshold(0.0);
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(true);
        dbparams.setNormalized(true);
        dbparams.setScoreType(2);
        params.setSearchParams(dbparams);
        alg.setParams(params);
        MultiSequenceSearchResultSet resultSet = alg.runProfileSearch();
    }

    private static void generateLogos() {
        System.out.println("brain.WWAnalysis: Generating sequence logos...");
        String inFile = "/Users/moyez/Code/wwdata/analysis1/wwprojectfile_od1.txt";
        String outPath = "/Users/moyez/Code/wwdata/analysis1/logos/logos_od1";
        String fileSuffix = "_od1";
        System.out.println(inFile);
        WWAnalysis.writeSequenceLogos(inFile, outPath, null, 0.0, fileSuffix);
        inFile = "/Users/moyez/Code/wwdata/analysis1/wwprojectfile_od2.txt";
        outPath = "/Users/moyez/Code/wwdata/analysis1/logos/logos_od2";
        fileSuffix = "_od2";
        System.out.println(inFile);
        WWAnalysis.writeSequenceLogos(inFile, outPath, null, 0.0, fileSuffix);
        inFile = "/Users/moyez/Code/wwdata/analysis1/wwprojectfile_od3.txt";
        outPath = "/Users/moyez/Code/wwdata/analysis1/logos/logos_od3";
        fileSuffix = "_od3";
        System.out.println(inFile);
        WWAnalysis.writeSequenceLogos(inFile, outPath, null, 0.0, fileSuffix);
        inFile = "/Users/moyez/Code/wwdata/analysis1/wwprojectfile_od4.txt";
        outPath = "/Users/moyez/Code/wwdata/analysis1/logos/logos_od4";
        fileSuffix = "_od4";
        System.out.println(inFile);
        WWAnalysis.writeSequenceLogos(inFile, outPath, null, 0.0, fileSuffix);
        inFile = "/Users/moyez/Code/wwdata/analysis1/wwprojectfile_od5.txt";
        outPath = "/Users/moyez/Code/wwdata/analysis1/logos/logos_od5";
        fileSuffix = "_od5";
        System.out.println(inFile);
        WWAnalysis.writeSequenceLogos(inFile, outPath, null, 0.0, fileSuffix);
    }

    public static void writeSequenceLogos(String profileListFileName, String outputDirectory, String codonBiasFileName, double fuzzFactor, String fileSuffix) {
        String suffix = fileSuffix;
        if (suffix == null) {
            suffix = "";
        }
        File codonBiasFile = null;
        if (codonBiasFileName != null) {
            codonBiasFile = new File(codonBiasFileName);
        }
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles((File)new File(profileListFileName), (int)0, null, (double)fuzzFactor, (File)codonBiasFile, (boolean)true);
        String outFileName = null;
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            outFileName = new String(outputDirectory + File.separator + proteinProfile.getName() + suffix + ".png");
            ProteinSequenceLogo logo = new ProteinSequenceLogo(proteinProfile, 180);
            try {
                ImageIO.write((RenderedImage)logo.drawSequenceLogo(), "png", new File(outFileName));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

