/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainplugin;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.data.CyAttributesImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.GenPeptUtil;
import org.baderlab.brain.Hit;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceSearchResultSet;
import org.baderlab.brain.inparanoid.InparanoidDB;
import org.baderlab.csplugins.brainplugin.CytoscapeUtil;
import org.biojava.bio.seq.Sequence;

public class DomainInteractionAnalysis {
    public static void scoreCoExpressionByAPCall(File expressionDataSetFile, File samplesOfInterestFile, File nodeXrefToAffyIDMappingFile, CyNetwork net) throws IOException {
        String IDMappingFileLine;
        String sampleFileLine;
        String samplesOfInterestFileLine;
        int samplesOfInterestCount = 0;
        HashMap<String, String> samplesOfInterest2TissueNameMap = new HashMap<String, String>();
        BufferedReader brInterest = new BufferedReader(new FileReader(samplesOfInterestFile));
        while ((samplesOfInterestFileLine = brInterest.readLine()) != null) {
            if (samplesOfInterestFileLine.equals("") || samplesOfInterestFileLine.charAt(0) == '#') continue;
            String[] gsmString = samplesOfInterestFileLine.split("\t", 2);
            if (gsmString.length == 2) {
                samplesOfInterest2TissueNameMap.put(new String(gsmString[0]), new String(gsmString[1]));
                ++samplesOfInterestCount;
                continue;
            }
            throw new IllegalArgumentException("Sample selection list line was malformed. Expected two tab delimited columns, but got " + samplesOfInterestFileLine + ".");
        }
        GEODataSet[] samples = new GEODataSet[samplesOfInterestCount];
        BufferedReader brSamples = new BufferedReader(new FileReader(expressionDataSetFile));
        String currentSample = null;
        int currentSampleIndex = -1;
        boolean interestingSample = false;
        while ((sampleFileLine = brSamples.readLine()) != null) {
            char firstChar = sampleFileLine.charAt(0);
            if (interestingSample && firstChar != '!' && firstChar != '#' && firstChar != '^') {
                String[] affyIDString = sampleFileLine.split("\\s", 2);
                String affyID = new String(affyIDString[0]);
                if (affyID.equals("ID_REF")) continue;
                char APCall = sampleFileLine.charAt(sampleFileLine.length() - 1);
                samples[currentSampleIndex].addAffyID2APCallMapping(affyID, String.valueOf(APCall));
                continue;
            }
            if (sampleFileLine.charAt(0) != '^' || sampleFileLine.indexOf("^SAMPLE") < 0) continue;
            String[] gsmString = sampleFileLine.split(" = ", 2);
            currentSample = new String(gsmString[1]);
            if (samplesOfInterest2TissueNameMap.containsKey(currentSample)) {
                samples[++currentSampleIndex] = new GEODataSet(currentSample, (String)samplesOfInterest2TissueNameMap.get(currentSample));
                interestingSample = true;
                continue;
            }
            interestingSample = false;
        }
        if (currentSampleIndex + 1 != samplesOfInterestCount) {
            throw new IllegalArgumentException("Error detected in samples of interest file. It specifies " + samplesOfInterestCount + " samples of interest, but only found " + (currentSampleIndex + 1) + ".");
        }
        HashMap<DatabaseReference, ArrayList> nodeIDToAffyIDList = new HashMap<DatabaseReference, ArrayList>();
        BufferedReader brIDMappingFile = new BufferedReader(new FileReader(nodeXrefToAffyIDMappingFile));
        while ((IDMappingFileLine = brIDMappingFile.readLine()) != null) {
            ArrayList affyList;
            String[] mappingString = IDMappingFileLine.split("\\s", 2);
            if (mappingString.length != 2) continue;
            DatabaseReference dbref = new DatabaseReference(mappingString[0]);
            if (nodeIDToAffyIDList.containsKey(dbref)) {
                affyList = (ArrayList)nodeIDToAffyIDList.get(dbref);
                affyList.add(new String(mappingString[1]));
                continue;
            }
            affyList = new ArrayList();
            affyList.add(new String(mappingString[1]));
            nodeIDToAffyIDList.put(dbref, affyList);
        }
        Iterator edges = net.edgesIterator();
        while (edges.hasNext()) {
            CyEdge cyEdge = (CyEdge)edges.next();
            DomainInteractionAnalysis.CountNodeCoExpression(net, cyEdge, nodeIDToAffyIDList, samples);
        }
    }

    private static void CountNodeCoExpression(CyNetwork net, CyEdge cyEdge, HashMap nodeIDToAffyID, GEODataSet[] samples) {
        CyNode source = (CyNode)cyEdge.getSource();
        CyNode target = (CyNode)cyEdge.getTarget();
        DatabaseReference[] dbRefsSource = CytoscapeUtil.getDatabaseXrefsForNode(net, source);
        DatabaseReference[] dbRefsTarget = CytoscapeUtil.getDatabaseXrefsForNode(net, target);
        ArrayList affyIDsSource = new ArrayList();
        for (int i = 0; i < dbRefsSource.length; ++i) {
            DatabaseReference databaseReference = dbRefsSource[i];
            ArrayList affyIDs = (ArrayList)nodeIDToAffyID.get(databaseReference);
            if (affyIDs == null) continue;
            affyIDsSource.addAll(affyIDs);
        }
        ArrayList affyIDsTarget = new ArrayList();
        for (int i = 0; i < dbRefsTarget.length; ++i) {
            DatabaseReference databaseReference = dbRefsTarget[i];
            ArrayList affyIDs = (ArrayList)nodeIDToAffyID.get(databaseReference);
            if (affyIDs == null) continue;
            affyIDsTarget.addAll(affyIDs);
        }
        if (affyIDsSource.size() == 0 || affyIDsTarget.size() == 0) {
            return;
        }
        int numPairPCalls = 0;
        int sourcePresentCount = 0;
        int targetPresentCount = 0;
        StringBuffer sb = null;
        for (int i = 0; i < samples.length; ++i) {
            String affyID2APCallMapping;
            String affyID;
            int j;
            boolean sourcePresent = false;
            boolean targetPresent = false;
            GEODataSet sample = samples[i];
            for (j = 0; j < affyIDsSource.size(); ++j) {
                affyID = (String)affyIDsSource.get(j);
                affyID2APCallMapping = sample.getAffyID2APCallMapping(affyID);
                if (affyID2APCallMapping == null || !affyID2APCallMapping.equals("P")) continue;
                sourcePresent = true;
                ++sourcePresentCount;
                break;
            }
            for (j = 0; j < affyIDsTarget.size(); ++j) {
                affyID = (String)affyIDsTarget.get(j);
                affyID2APCallMapping = sample.getAffyID2APCallMapping(affyID);
                if (affyID2APCallMapping == null || !affyID2APCallMapping.equals("P")) continue;
                targetPresent = true;
                ++targetPresentCount;
                break;
            }
            if (!sourcePresent || !targetPresent) continue;
            ++numPairPCalls;
            if (sb != null) {
                sb.append(sample.getTissueName() + "|");
                continue;
            }
            sb = new StringBuffer();
            sb.append(sample.getTissueName() + "|");
        }
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        cyAttributes.setAttribute(source.getIdentifier(), "ExpressionPresentCount", new Integer(sourcePresentCount));
        cyAttributes.setAttribute(target.getIdentifier(), "ExpressionPresentCount", new Integer(targetPresentCount));
        cyAttributes.setAttribute(cyEdge.getIdentifier(), "CoExpressionScore", new Integer(numPairPCalls));
        if (sb != null) {
            cyAttributes.setAttribute(cyEdge.getIdentifier(), "CoExpressionTissues", sb.toString());
        }
    }

    public static void findCommonOrthologs(SequenceSearchResultSet referenceResults, String referenceDatabaseName, SequenceSearchResultSet comparisonResults, String comparisonDatabaseName, InparanoidDB orthologyDB, HashMap orthologResults) {
        Set referenceSequences = referenceResults.getSequences();
        Set comparisonSequences = comparisonResults.getSequences();
        for (Sequence referenceSequence : referenceSequences) {
            Sequence referenceOriginalDBSequence = referenceResults.getOriginalSequence(referenceSequence);
            DatabaseReference referenceXref = GenPeptUtil.getAccession((Sequence)referenceOriginalDBSequence);
            if (referenceXref == null) {
                referenceXref = new DatabaseReference(referenceDatabaseName, referenceOriginalDBSequence.getName());
            }
            if (referenceXref == null) continue;
            for (Sequence comparisonSequence : comparisonSequences) {
                Sequence comparisonOriginalDBSequence = comparisonResults.getOriginalSequence(comparisonSequence);
                DatabaseReference comparisonXref = GenPeptUtil.getAccession((Sequence)comparisonOriginalDBSequence);
                if (comparisonXref == null) {
                    comparisonXref = new DatabaseReference(comparisonDatabaseName, comparisonOriginalDBSequence.getName());
                }
                if (comparisonXref == null || !orthologyDB.isOrthologByAccession(referenceXref, comparisonXref)) continue;
                System.out.println("Ortholog found: " + referenceXref.getDbid() + "\t" + comparisonXref.getDbid());
                ArrayList orthologResultList = null;
                OrthologResult result = new OrthologResult(comparisonResults.getSpecies(), comparisonXref);
                result.motifHits = (ArrayList)comparisonResults.getHits(comparisonSequence);
                if (orthologResults.containsKey(referenceXref)) {
                    orthologResultList = (ArrayList)orthologResults.get(referenceXref);
                    orthologResultList.add(result);
                    orthologResults.put(referenceXref, orthologResultList);
                    continue;
                }
                orthologResultList = new ArrayList();
                orthologResultList.add(result);
                orthologResults.put(referenceXref, orthologResultList);
            }
        }
    }

    public static void runConservedHitAnalysis(String projectFileName, InparanoidDB orthologDB) throws IOException {
        ConservedHitAnalysisParams analysisParams = new ConservedHitAnalysisParams(new File(projectFileName));
        if (orthologDB == null) {
            orthologDB = new InparanoidDB();
            orthologDB.readInparanoidDataFile(analysisParams.getInparanoidDataFiles(), analysisParams.getInparanoidSpeciesData(), analysisParams.getInparanoidReferenceSpecies());
            orthologDB.readIDMappingFile(analysisParams.getInparanoidIDMappingFile());
        }
        ArrayList referenceParams = analysisParams.getReferenceParams();
        BrainAlgorithm alg = new BrainAlgorithm();
        for (int i = 0; i < referenceParams.size(); ++i) {
            BrainParameterSet params = (BrainParameterSet)referenceParams.get(i);
            alg.setParams(params);
            List profileList = PeptideToProfileReader.readPeptidesAsProfiles((File)params.getProfileFile(), (double)params.getFuzzFactor());
            MultiSequenceSearchResultSet referenceProteomeSearchResults = alg.runProfileSearch(profileList, null, params);
            String refDatabaseName = analysisParams.getDatabaseName(params.getDatabaseFileName());
            DomainInteractionAnalysis.setSpeciesOnResultSet(referenceProteomeSearchResults, analysisParams, params);
            HashMap<ProteinProfile, HashMap> profile2commonOrthologResultMap = new HashMap<ProteinProfile, HashMap>();
            ArrayList comparisonParams = analysisParams.getComparisonDatabaseParams();
            for (int j = 0; j < comparisonParams.size(); ++j) {
                BrainParameterSet comparisonParamSet = (BrainParameterSet)comparisonParams.get(j);
                params.setDatabaseFileName(comparisonParamSet.getDatabaseFileName());
                params.setDatabaseFormat(comparisonParamSet.getDatabaseFormat());
                MultiSequenceSearchResultSet comparisonProteomeSearchResults = alg.runProfileSearch(profileList, null, params);
                DomainInteractionAnalysis.setSpeciesOnResultSet(comparisonProteomeSearchResults, analysisParams, params);
                Collection referenceProteomeResults = referenceProteomeSearchResults.getAllResultSets();
                for (SequenceSearchResultSet referenceProteomeResultSet : referenceProteomeResults) {
                    SequenceSearchResultSet topReferenceProteomeResultSet = referenceProteomeResultSet.getTopResults(params.getNumberTopHits());
                    ProteinProfile refProfile = referenceProteomeResultSet.getProfile();
                    SequenceSearchResultSet comparisonProteomeSearchResultSet = comparisonProteomeSearchResults.getResultSet(refProfile);
                    SequenceSearchResultSet topComparisonProteomeResultSet = comparisonProteomeSearchResultSet.getTopResults(params.getNumberTopHits());
                    HashMap homologCount = profile2commonOrthologResultMap.containsKey(refProfile) ? (HashMap)profile2commonOrthologResultMap.get(refProfile) : new HashMap();
                    String comparisonDatabaseName = analysisParams.getDatabaseName(params.getDatabaseFileName());
                    DomainInteractionAnalysis.findCommonOrthologs(topReferenceProteomeResultSet, refDatabaseName, topComparisonProteomeResultSet, comparisonDatabaseName, orthologDB, homologCount);
                    profile2commonOrthologResultMap.put(refProfile, homologCount);
                }
            }
            Set profiles = profile2commonOrthologResultMap.keySet();
            for (ProteinProfile proteinProfile : profiles) {
                HashMap orthologResultSet = (HashMap)profile2commonOrthologResultMap.get(proteinProfile);
                Set referenceProteinXrefs = orthologResultSet.keySet();
                for (DatabaseReference referenceProteinXref : referenceProteinXrefs) {
                    ArrayList orthologResultList = (ArrayList)orthologResultSet.get(referenceProteinXref);
                    int count = orthologResultList.size();
                    System.out.print(proteinProfile.getName() + "\t" + referenceProteinXref.getDbid() + "\t" + count + "\t");
                    for (int j = 0; j < orthologResultList.size(); ++j) {
                        OrthologResult orthologResult = (OrthologResult)orthologResultList.get(j);
                        String speciesFullName = orthologDB.getSpeciesFullName(orthologResult.species);
                        System.out.print(speciesFullName + "\t" + orthologResult.proteinHitXref.getDbid() + "\t");
                        ArrayList hits = orthologResult.motifHits;
                        for (int k = 0; k < hits.size(); ++k) {
                            Hit hit = (Hit)hits.get(k);
                            System.out.print(hit + "\t");
                        }
                    }
                    System.out.println("");
                }
                System.out.println("\n");
            }
        }
    }

    private static void setSpeciesOnResultSet(MultiSequenceSearchResultSet proteomeSearchResults, ConservedHitAnalysisParams analysisParams, BrainParameterSet params) {
        Collection referenceProteomeResults = proteomeSearchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : referenceProteomeResults) {
            sequenceSearchResultSet.setSpecies(analysisParams.getSpecies(params.getDatabaseFileName()));
        }
    }

    public static void runConservedLinkAnalysis(String projectFileName, String comparisonProfileListFileName, String comparisonProteomeFileName, String comparisonProteomeFileFormat, InparanoidDB orthologDB) throws IOException {
        ConservedHitAnalysisParams analysisParams = new ConservedHitAnalysisParams(new File(projectFileName));
        if (orthologDB == null) {
            orthologDB = new InparanoidDB();
            orthologDB.readInparanoidDataFile(analysisParams.getInparanoidDataFiles(), analysisParams.getInparanoidSpeciesData(), analysisParams.getInparanoidReferenceSpecies());
            orthologDB.readIDMappingFile(analysisParams.getInparanoidIDMappingFile());
        }
        ArrayList referenceParams = analysisParams.getReferenceParams();
        BrainAlgorithm alg = new BrainAlgorithm();
        for (int i = 0; i < referenceParams.size(); ++i) {
            BrainParameterSet params = (BrainParameterSet)referenceParams.get(i);
            alg.setParams(params);
            MultiSequenceSearchResultSet referenceProteomeSearchResults = alg.runProfileSearch();
            String refDatabaseName = analysisParams.getDatabaseName(params.getDatabaseFileName());
            DomainInteractionAnalysis.setSpeciesOnResultSet(referenceProteomeSearchResults, analysisParams, params);
            params.setProfileFileName(new File(comparisonProfileListFileName));
            params.setDatabaseFileName(new File(comparisonProteomeFileName));
            params.setDatabaseFormat(comparisonProteomeFileFormat);
            MultiSequenceSearchResultSet comparisonProteomeSearchResults = alg.runProfileSearch();
            DomainInteractionAnalysis.setSpeciesOnResultSet(comparisonProteomeSearchResults, analysisParams, params);
            HashMap<ProteinProfile, HashMap> profile2commonOrthologResultMap = new HashMap<ProteinProfile, HashMap>();
            Collection referenceProteomeResults = referenceProteomeSearchResults.getAllResultSets();
            MultiSequenceSearchResultSet topReferenceHitResultSet = new MultiSequenceSearchResultSet();
            for (SequenceSearchResultSet referenceProteomeResultSet : referenceProteomeResults) {
                SequenceSearchResultSet topReferenceProteomeResultSet = referenceProteomeResultSet.getTopResults(params.getNumberTopHits());
                topReferenceHitResultSet.add(topReferenceProteomeResultSet);
            }
            Collection comparisonProteomeResults = comparisonProteomeSearchResults.getAllResultSets();
            MultiSequenceSearchResultSet topComparisonHitResultSet = new MultiSequenceSearchResultSet();
            for (SequenceSearchResultSet comparisonProteomeResultSet : comparisonProteomeResults) {
                SequenceSearchResultSet topComparisonProteomeResultSet = comparisonProteomeResultSet.getTopResults(params.getNumberTopHits());
                topComparisonHitResultSet.add(topComparisonProteomeResultSet);
            }
            referenceProteomeResults = topReferenceHitResultSet.getAllResultSets();
            for (SequenceSearchResultSet topReferenceResultSet : referenceProteomeResults) {
                ProteinProfile referenceProfile = topReferenceResultSet.getProfile();
                DatabaseReference referenceProfileProtein = referenceProfile.getProteinReference();
                comparisonProteomeResults = topComparisonHitResultSet.getAllResultSets();
                for (SequenceSearchResultSet topComparisonResultSet : comparisonProteomeResults) {
                    ProteinProfile comparisonProfile = topComparisonResultSet.getProfile();
                    DatabaseReference comparisonProfileProtein = comparisonProfile.getProteinReference();
                    if (!orthologDB.isOrthologByAccession(referenceProfileProtein, comparisonProfileProtein)) continue;
                    System.out.println("Ortholog PDZ found: " + referenceProfile.getName() + " " + referenceProfileProtein.getDbid() + "\t" + comparisonProfile.getName() + " " + comparisonProfileProtein.getDbid());
                    HashMap orthologResults = profile2commonOrthologResultMap.containsKey(referenceProfile) ? (HashMap)profile2commonOrthologResultMap.get(referenceProfile) : new HashMap();
                    String comparisonDatabaseName = analysisParams.getDatabaseName(params.getDatabaseFileName());
                    DomainInteractionAnalysis.findCommonOrthologs(topReferenceResultSet, refDatabaseName, topComparisonResultSet, comparisonDatabaseName, orthologDB, orthologResults);
                    profile2commonOrthologResultMap.put(referenceProfile, orthologResults);
                }
            }
            Set profiles = profile2commonOrthologResultMap.keySet();
            for (ProteinProfile proteinProfile : profiles) {
                HashMap orthologResultSet = (HashMap)profile2commonOrthologResultMap.get(proteinProfile);
                Set referenceProteinXrefs = orthologResultSet.keySet();
                for (DatabaseReference referenceProteinXref : referenceProteinXrefs) {
                    ArrayList orthologResultList = (ArrayList)orthologResultSet.get(referenceProteinXref);
                    int count = orthologResultList.size();
                    System.out.print(proteinProfile.getName() + "\t" + referenceProteinXref.getDbid() + "\t" + count + "\t");
                    for (int j = 0; j < orthologResultList.size(); ++j) {
                        OrthologResult orthologResult = (OrthologResult)orthologResultList.get(j);
                        String speciesFullName = orthologDB.getSpeciesFullName(orthologResult.species);
                        System.out.print(speciesFullName + "\t" + orthologResult.proteinHitXref.getDbid() + "\t");
                        ArrayList hits = orthologResult.motifHits;
                        for (int k = 0; k < hits.size(); ++k) {
                            Hit hit = (Hit)hits.get(k);
                            System.out.print(hit + "\t");
                        }
                    }
                    System.out.println("");
                }
                System.out.println("\n");
            }
        }
    }

    private static class OrthologResult {
        public String species;
        public DatabaseReference proteinHitXref;
        public ArrayList motifHits;

        public OrthologResult(String species, DatabaseReference proteinHitXref) {
            this.species = species;
            this.proteinHitXref = proteinHitXref;
        }
    }

    private static class ConservedHitAnalysisParams {
        private ArrayList referenceParams;
        private ArrayList comparisonDatabaseParams;
        private File inparanoidSpeciesData;
        private File inparanoidIDMappingFile;
        private String inparanoidReferenceSpecies;
        private ArrayList inparanoidDataFiles;
        final int REF_PROTEOME = 1;
        final int REF_PROFILE = 2;
        final int COMPARISON_PROTEOME = 3;
        final int INPARANOID = 4;
        private File refProteomeFile;
        private String refProteomeFormat;
        private HashMap proteomeFileName2DatabaseName = new HashMap();
        private HashMap proteomeFileName2Species = new HashMap();

        public ConservedHitAnalysisParams(File projectFile) throws IOException {
            this.readProjectFile(projectFile);
        }

        public File getInparanoidSpeciesData() {
            return this.inparanoidSpeciesData;
        }

        public File getInparanoidIDMappingFile() {
            return this.inparanoidIDMappingFile;
        }

        public String getInparanoidReferenceSpecies() {
            return this.inparanoidReferenceSpecies;
        }

        public String getDatabaseName(File databaseFileName) {
            return (String)this.proteomeFileName2DatabaseName.get(databaseFileName.toString());
        }

        public String getSpecies(File databaseFileName) {
            return (String)this.proteomeFileName2Species.get(databaseFileName.toString());
        }

        public File[] getInparanoidDataFiles() {
            File[] files = new File[this.inparanoidDataFiles.size()];
            this.inparanoidDataFiles.toArray(files);
            return files;
        }

        public ArrayList getReferenceParams() {
            return this.referenceParams;
        }

        public ArrayList getComparisonDatabaseParams() {
            return this.comparisonDatabaseParams;
        }

        private void readProjectFile(File projectFile) throws IOException {
            BufferedReader br = new BufferedReader(new FileReader(projectFile));
            String line = null;
            int section = 0;
            block6: while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equalsIgnoreCase("#ProjectFile")) continue;
                if (line.equalsIgnoreCase("#ReferenceProteome")) {
                    section = 1;
                    if (this.referenceParams != null) continue;
                    this.referenceParams = new ArrayList();
                    continue;
                }
                if (line.equalsIgnoreCase("#ReferenceProfiles")) {
                    section = 2;
                    continue;
                }
                if (line.equalsIgnoreCase("#ComparisonProteomes")) {
                    section = 3;
                    if (this.comparisonDatabaseParams != null) continue;
                    this.comparisonDatabaseParams = new ArrayList();
                    continue;
                }
                if (line.equalsIgnoreCase("#Inparanoid")) {
                    section = 4;
                    continue;
                }
                if (line.equals("") || line.charAt(0) == '#') continue;
                switch (section) {
                    case 1: {
                        String[] lineSplit = line.split("\t");
                        if (lineSplit.length >= 3) {
                            this.refProteomeFile = new File(lineSplit[0]);
                            String refProteomeSpecies = lineSplit[1];
                            this.proteomeFileName2Species.put(this.refProteomeFile.toString(), refProteomeSpecies);
                            this.refProteomeFormat = lineSplit[2];
                            if (lineSplit.length == 4) {
                                String refProteomeDatabaseName = lineSplit[3];
                                this.proteomeFileName2DatabaseName.put(this.refProteomeFile.toString(), refProteomeDatabaseName);
                                break;
                            }
                            if (!this.refProteomeFormat.equalsIgnoreCase("fasta")) continue block6;
                            throw new IllegalArgumentException("#ReferenceProteome section: database format set to fasta, but no database name provided.");
                        }
                        throw new IllegalArgumentException("#ReferenceProteome section: expected 3 or more fields, but found " + lineSplit.length + ": " + line + ".");
                    }
                    case 2: {
                        String[] lineSplit = line.split("\t");
                        if (lineSplit.length == 6) {
                            File profileFile = new File(lineSplit[0]);
                            float threshold = Float.parseFloat(lineSplit[1]);
                            float fuzz = Float.parseFloat(lineSplit[2]);
                            int top = Integer.parseInt(lineSplit[3]);
                            ProteinTerminus terminus = ProteinTerminus.parseTerminus((String)lineSplit[4]);
                            boolean normalized = lineSplit[5].equalsIgnoreCase("T");
                            ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(terminus);
                            dbparams.setNormalized(normalized);
                            BrainParameterSet params = new BrainParameterSet(this.refProteomeFile, this.refProteomeFormat, dbparams, profileFile, null, (double)threshold, 100.0, top, (double)fuzz, true, false);
                            this.referenceParams.add(params);
                            break;
                        }
                        throw new IllegalArgumentException("#ReferenceProfiles section: expected 6 fields, but found " + lineSplit.length + ": " + line + ".");
                    }
                    case 3: {
                        String[] lineSplit = line.split("\t");
                        if (lineSplit.length >= 3) {
                            File comparisonProteomeFile = new File(lineSplit[0]);
                            String comparisonProteomeSpecies = lineSplit[1];
                            this.proteomeFileName2Species.put(comparisonProteomeFile.toString(), comparisonProteomeSpecies);
                            String comparisonProteomeFormat = lineSplit[2];
                            if (lineSplit.length == 4) {
                                String comparisonProteomeDatabaseName = lineSplit[3];
                                this.proteomeFileName2DatabaseName.put(comparisonProteomeFile.toString(), comparisonProteomeDatabaseName);
                            } else if (comparisonProteomeFormat.equalsIgnoreCase("fasta")) {
                                throw new IllegalArgumentException("#ComparisonProteomes section: database format set to fasta, but no database name provided: " + line + ".");
                            }
                            BrainParameterSet params = new BrainParameterSet();
                            params.setDatabaseFileName(comparisonProteomeFile);
                            params.setDatabaseFormat(comparisonProteomeFormat);
                            this.comparisonDatabaseParams.add(params);
                            break;
                        }
                        throw new IllegalArgumentException("#ComparisonProteomes section: expected 3 or more fields, but found " + lineSplit.length + ": " + line + ".");
                    }
                    case 4: {
                        String[] lineSplit = line.split("\t");
                        if (lineSplit.length == 3) {
                            this.inparanoidSpeciesData = new File(lineSplit[0]);
                            this.inparanoidReferenceSpecies = lineSplit[1];
                            this.inparanoidIDMappingFile = new File(lineSplit[2]);
                            break;
                        }
                        if (lineSplit.length == 1) {
                            File inparanoidDataFile = new File(lineSplit[0]);
                            if (this.inparanoidDataFiles == null) {
                                this.inparanoidDataFiles = new ArrayList();
                            }
                            this.inparanoidDataFiles.add(inparanoidDataFile);
                            break;
                        }
                        throw new IllegalArgumentException("#Inparanoid section: expected 1 or 3 fields, but found " + lineSplit.length + ": " + line + ".");
                    }
                }
            }
        }
    }

    private static class GEODataSet {
        private String sampleID;
        private String tissueName;
        private HashMap affyID2APCall;

        public GEODataSet(String sampleID, String tissueName) {
            this.sampleID = sampleID;
            this.tissueName = tissueName;
            this.affyID2APCall = new HashMap(5000);
        }

        public String getSampleID() {
            return this.sampleID;
        }

        public void setSampleID(String sampleID) {
            this.sampleID = sampleID;
        }

        public String getTissueName() {
            return this.tissueName;
        }

        public void setTissueName(String tissueName) {
            this.tissueName = tissueName;
        }

        public void addAffyID2APCallMapping(String affyID, String APCall) {
            this.affyID2APCall.put(affyID, APCall);
        }

        public String getAffyID2APCallMapping(String affyID) {
            return (String)this.affyID2APCall.get(affyID);
        }
    }
}

