/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainplugin;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.Hit;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceSearchResultSet;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.mskcc.dataservices.bio.vocab.CommonVocab;

public class CytoscapeUtil {
    static int runNumber = 1;
    static HashMap queryNameToAccession;
    static HashMap hitNameToAccession;
    static int nodeCount;

    public static void addSequenceSearchResultSetToCytoscape(CyNetwork net, ProteinProfile profile, SequenceSearchResultSet resultSet, BrainParameterSet params) {
        CyNode nodeA;
        String nodeAName = null;
        String mapKey = null;
        boolean newNode = true;
        if (params.getUniqueQueryProteinNodes() && queryNameToAccession.containsKey(mapKey = profile.getProteinReference().getDbid())) {
            newNode = false;
            nodeAName = (String)queryNameToAccession.get(mapKey);
        }
        if (newNode) {
            nodeAName = String.format("n%1$06d", ++nodeCount);
            if (params.getUniqueQueryProteinNodes()) {
                queryNameToAccession.put(mapKey, nodeAName);
            }
        }
        if ((nodeA = Cytoscape.getCyNode(nodeAName)) == null || net.getIndex((Node)nodeA) == 0) {
            nodeA = Cytoscape.getCyNode(nodeAName, (boolean)true);
            net.addNode((Node)nodeA);
        }
        CytoscapeUtil.addPSIFeaturesToNode(net, nodeA, profile);
        Set results = resultSet.getSequences();
        String nodeBName = null;
        for (Sequence sequence : results) {
            Sequence originalDBSequence = resultSet.getOriginalSequence(sequence);
            mapKey = originalDBSequence.getName();
            if (hitNameToAccession.containsKey(mapKey)) {
                nodeBName = (String)hitNameToAccession.get(mapKey);
            } else {
                nodeBName = String.format("n%1$06d", ++nodeCount);
                hitNameToAccession.put(mapKey, nodeBName);
            }
            CyNode nodeB = Cytoscape.getCyNode((String)nodeBName);
            if (nodeB == null || net.getIndex((Node)nodeB) == 0) {
                nodeB = Cytoscape.getCyNode((String)nodeBName, (boolean)true);
                net.addNode((Node)nodeB);
            }
            CyEdge edge = Cytoscape.getCyEdge((String)nodeA.getIdentifier(), (String)(nodeA.getIdentifier() + "_pp_" + nodeB.getIdentifier()), (String)nodeB.getIdentifier(), (String)("pp" + net.getIdentifier()));
            net.addEdge((Edge)edge);
            double bestScore = Double.MAX_VALUE;
            String bestMotif = null;
            Hit bestHit = null;
            List hits = resultSet.getHits(sequence);
            ArrayList<String> sequenceList = new ArrayList<String>();
            for (int i = 0; i < hits.size(); ++i) {
                Hit hit = (Hit)hits.get(i);
                if (hit.getScore() < bestScore) {
                    bestHit = hit;
                    bestScore = hit.getScore();
                    bestMotif = hit.getMatchString();
                }
                if (bestMotif != null) {
                    Cytoscape.getNodeAttributes().setAttribute(nodeB.getIdentifier(), "Motif Start", Integer.valueOf(bestHit.getStart()));
                    Cytoscape.getNodeAttributes().setAttribute(nodeB.getIdentifier(), "Motif End", Integer.valueOf(bestHit.getEnd()));
                }
                sequenceList.add(hit.getMatchString() + " (" + hit.getStart() + "-" + hit.getEnd() + ") by " + profile.getName() + "; score: " + hit.getScore());
            }
            Cytoscape.getNodeAttributes().setListAttribute(nodeB.getIdentifier(), "Motif Hit", sequenceList);
            bestScore = CytoscapeUtil.truncateDouble(bestScore, 3);
            Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "HighestScore", new Double(bestScore));
            if (params.getDatabaseFormat().equalsIgnoreCase("genpept")) {
                CytoscapeUtil.addPSIFeaturesToEdge(net, edge, bestScore, bestMotif, nodeA.getIdentifier());
            }
            if (params.getDatabaseFormat().equalsIgnoreCase("fasta")) {
                CytoscapeUtil.addFastaFeaturesToNode(net, nodeB, originalDBSequence);
                continue;
            }
            if (!params.getDatabaseFormat().equalsIgnoreCase("genpept")) continue;
            CytoscapeUtil.addGenPeptFeaturesToNode(net, nodeB, originalDBSequence, params, sequence, bestHit);
        }
    }

    public static CyNetwork addProfileSearchResultsToCytoscape(MultiSequenceSearchResultSet searchResults, BrainParameterSet params) {
        CyNetwork net = Cytoscape.createNetwork((String)("Profile Network " + runNumber++));
        if (searchResults == null) {
            System.err.println("Search error. Can't continue.");
            return null;
        }
        queryNameToAccession.clear();
        hitNameToAccession.clear();
        nodeCount = 0;
        Collection results = searchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            if (params.getScorePercentageThreshold() < 100.0) {
                sequenceSearchResultSet = sequenceSearchResultSet.getTopPercentileResults(params.getScorePercentageThreshold());
            }
            if (params.getNumberTopHits() > 0) {
                sequenceSearchResultSet = sequenceSearchResultSet.getTopResults(params.getNumberTopHits());
            }
            System.out.println(sequenceSearchResultSet.getProfile().getName() + "\t" + sequenceSearchResultSet.getNumberSequencesHit() + System.getProperty("line.separator"));
            CytoscapeUtil.addSequenceSearchResultSetToCytoscape(net, sequenceSearchResultSet.getProfile(), sequenceSearchResultSet, params);
            System.out.println(sequenceSearchResultSet.getNumberOfHits());
        }
        return net;
    }

    private static void addPSIFeaturesToNode(CyNetwork net, CyNode node, ProteinProfile profile) {
        String[] dbID;
        DatabaseReference protein = profile.getProteinReference();
        List<String> list = null;
        String[] dbName = new String[]{protein.getDbname()};
        if (dbName[0] != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), CommonVocab.XREF_DB_NAME, dbName[0]);
        }
        if ((dbID = new String[]{protein.getDbid()})[0] != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), CommonVocab.XREF_DB_ID, dbID[0]);
        }
        list = Cytoscape.getNodeAttributes().hasAttribute(node.getIdentifier(), "Domain Name") ? Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), "Domain Name") : new ArrayList<String>();
        list.add(profile.getName());
        Cytoscape.getNodeAttributes().setListAttribute(node.getIdentifier(), "Domain Name", list);
        list.clear();
        list = Cytoscape.getNodeAttributes().hasAttribute(node.getIdentifier(), "Domain Number") ? Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), "Domain Number") : new ArrayList();
        list.add((String)((Object)Integer.valueOf(profile.getDomainNumber())));
        Cytoscape.getNodeAttributes().setListAttribute(node.getIdentifier(), "Domain Number", list);
        list.clear();
        if (profile.getDomainSequence() != null) {
            list = Cytoscape.getNodeAttributes().hasAttribute(node.getIdentifier(), "Domain Sequence") ? Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), "Domain Sequence") : new ArrayList();
            String value = profile.getDomainSequence();
            if (profile.getDomainSequenceStart() > 0 && profile.getDomainSequenceStop() > 0) {
                value = value + " (" + profile.getDomainSequenceStart() + "-" + profile.getDomainSequenceStop() + ")";
            }
            list.add(value);
            Cytoscape.getNodeAttributes().setListAttribute(node.getIdentifier(), "Domain Sequence", list);
            list.clear();
        }
        if (profile.getDomainName() != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "Domain Type", profile.getDomainName());
        }
        if (profile.getName() != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "GENE_NAME", profile.getProteinName());
        }
        if (profile.getExperimentalMethod() != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "Experimental Method", profile.getExperimentalMethod());
        }
        list = Cytoscape.getNodeAttributes().hasAttribute(node.getIdentifier(), "ProfileNumSequences") ? Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), "ProfileNumSequences") : new ArrayList();
        list.add((String)((Object)Integer.valueOf(profile.getNumSequences())));
        Cytoscape.getNodeAttributes().setListAttribute(node.getIdentifier(), "ProfileNumSequences", list);
        list.clear();
        if (profile.getComment() != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "Comment", profile.getComment());
        }
    }

    private static void addFastaFeaturesToNode(CyNetwork net, CyNode node, Sequence sequence) {
        String description = null;
        Annotation seqAnn = sequence.getAnnotation();
        description = seqAnn.containsProperty((Object)"description") ? (String)seqAnn.getProperty((Object)"description") : sequence.getName();
        Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "Description", description);
    }

    private static ArrayList extractGenericAnnotation(String name, Feature f) {
        String xref = null;
        ArrayList xrefList = null;
        if (f.getAnnotation().containsProperty((Object)name)) {
            Object xrefObj = f.getAnnotation().getProperty((Object)name);
            if (xrefObj.getClass().equals(String.class)) {
                xref = (String)xrefObj;
                xrefList = new ArrayList(1);
                xrefList.add(xref);
            } else if (xrefObj.getClass().equals(ArrayList.class)) {
                xrefList = (ArrayList)xrefObj;
            }
        }
        return xrefList;
    }

    private static String extractTaxDbXref(Feature f) {
        String xref = null;
        ArrayList xrefList = CytoscapeUtil.extractGenericAnnotation("db_xref", f);
        if (xrefList.size() == 2) {
            xref = (String)xrefList.get(1);
        } else if (xrefList.size() == 1) {
            xref = (String)xrefList.get(0);
        } else {
            return null;
        }
        return xref;
    }

    private static String extractAnnotationStringByName(String name, Feature f) {
        ArrayList retVal = CytoscapeUtil.extractGenericAnnotation(name, f);
        if (retVal == null) {
            return null;
        }
        return (String)retVal.get(0);
    }

    private static void addGenPeptFeaturesToNode(CyNetwork net, CyNode node, Sequence originalDBSequence, BrainParameterSet params, Sequence searchedSequence, Hit bestHit) {
        int endSource;
        String dbSource;
        String[] dbArray;
        Annotation seqAnn = originalDBSequence.getAnnotation();
        if (seqAnn.containsProperty((Object)"DEFINITION")) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "FULL_NAME", (String)seqAnn.getProperty((Object)"DEFINITION"));
        }
        if (seqAnn.containsProperty((Object)"ACCESSION")) {
            String accession = (String)seqAnn.getProperty((Object)"ACCESSION");
            String[] accessionArray = accession.split("\\s+");
            String[] firstAccession = new String[]{accessionArray[0]};
            if (accessionArray.length > 0) {
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), CommonVocab.XREF_DB_ID, firstAccession[0]);
            }
        }
        if (seqAnn.containsProperty((Object)"DBSOURCE") && (dbArray = new String[]{(dbSource = (String)seqAnn.getProperty((Object)"DBSOURCE")).substring(0, endSource = dbSource.indexOf(":"))})[0] != null) {
            Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), CommonVocab.XREF_DB_NAME, dbArray[0]);
        }
        if (seqAnn.containsProperty((Object)"SOURCE")) {
            String source = (String)seqAnn.getProperty((Object)"SOURCE");
            int startCommonName = source.indexOf("(");
            int endCommonName = source.indexOf(")");
            if (startCommonName >= 0 || endCommonName >= 0) {
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "ORGANISM_COMMON_NAME", source.substring(startCommonName + 1, endCommonName));
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "ORGANISM_SPECIES", source.substring(0, startCommonName - 1));
            } else if (source != null) {
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "ORGANISM_COMMON_NAME", source);
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "ORGANISM_SPECIES", source);
            }
        }
        int protLength = 0;
        TreeMap<Integer, ArrayList> snpMap = null;
        Iterator fi = originalDBSequence.features();
        while (fi.hasNext()) {
            ArrayList snp;
            int startTaxid;
            String xref;
            Feature f = (Feature)fi.next();
            if (f.getAnnotation() != null && f.getType().equals("source") && (xref = CytoscapeUtil.extractTaxDbXref(f)) != null && (startTaxid = xref.indexOf(":")) > 0) {
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "ORGANISM_NCBI_TAXON_ID", xref.substring(startTaxid + 1, xref.length()));
            }
            if (f.getAnnotation() != null && f.getType().equals("CDS")) {
                ArrayList dbRefs;
                String name = CytoscapeUtil.extractAnnotationStringByName("gene", f);
                if (name != null) {
                    Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "GENE_NAME", name);
                }
                if ((dbRefs = CytoscapeUtil.extractGenericAnnotation("db_xref", f)) != null) {
                    for (int i = 0; i < dbRefs.size(); ++i) {
                        String s = (String)dbRefs.get(i);
                        if (s == null || !s.startsWith("MIM") || s.indexOf(":") <= 0) continue;
                        Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "OMIM", s.substring(s.indexOf(":") + 1, s.length()));
                    }
                }
            }
            if (f.getAnnotation() != null && f.getType().equals("variation") && (snp = CytoscapeUtil.extractGenericAnnotation("replace", f)) != null) {
                if (snpMap == null) {
                    snpMap = new TreeMap<Integer, ArrayList>();
                }
                snpMap.put(new Integer(f.getLocation().getMax()), snp);
            }
            if (f.getAnnotation() == null || !f.getType().equals("Protein")) continue;
            protLength = f.getLocation().getMax();
        }
        if (snpMap != null) {
            StringBuffer sbAll = null;
            StringBuffer sbMotif = null;
            Set locations = snpMap.keySet();
            int seqSearchLength = searchedSequence.length();
            for (Integer location : locations) {
                ArrayList snp = (ArrayList)snpMap.get(location);
                boolean addAllSNP = false;
                boolean addMotifSNP = false;
                ProteinTerminus term = params.getSearchParams().getTerminus();
                if (term.equals((Object)ProteinTerminus.C)) {
                    if (location > protLength - seqSearchLength) {
                        addAllSNP = true;
                    }
                } else if (term.equals((Object)ProteinTerminus.N)) {
                    if (location < seqSearchLength) {
                        addAllSNP = true;
                    }
                } else if (term.equals((Object)ProteinTerminus.NONE)) {
                    addAllSNP = true;
                }
                if (bestHit != null && location >= bestHit.getStart() && location <= bestHit.getEnd()) {
                    addMotifSNP = true;
                }
                if (addAllSNP) {
                    if (sbAll == null) {
                        sbAll = new StringBuffer();
                    }
                    sbAll.append(((String)snp.get(0)).toUpperCase() + location.toString() + ((String)snp.get(1)).toUpperCase() + " ");
                }
                if (!addMotifSNP) continue;
                if (sbMotif == null) {
                    sbMotif = new StringBuffer();
                }
                sbMotif.append(((String)snp.get(0)).toUpperCase() + location.toString() + ((String)snp.get(1)).toUpperCase() + " ");
            }
            if (sbAll != null) {
                sbAll.append("of " + protLength);
                Cytoscape.getNodeAttributes().setAttribute(node.getIdentifier(), "SNPs (All)", sbAll.toString());
            }
            if (sbMotif != null) {
                List<String> list = null;
                list = Cytoscape.getNodeAttributes().hasAttribute(node.getIdentifier(), "SNPs (Motif Hit)") ? Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), "SNPs (Motif Hit)") : new ArrayList<String>();
                list.add(sbMotif.toString());
                Cytoscape.getNodeAttributes().setListAttribute(node.getIdentifier(), "SNPs (Motif Hit)", list);
            }
        }
    }

    private static String findNameInGenPeptSequence(Sequence sequence) {
        String name = null;
        Iterator fi = sequence.features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            if (f.getAnnotation() == null || !f.getType().equals("CDS")) continue;
            name = CytoscapeUtil.extractAnnotationStringByName("gene", f);
        }
        return name;
    }

    private static void addPSIFeaturesToEdge(CyNetwork net, CyEdge edge, double score, String motif, String sourceName) {
        Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "EXPERIMENTAL_SYSTEM_NAME", "Sequence-based Prediction (score:" + score + ";motif:" + motif + ";from:" + sourceName + ")");
        Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "EXPERIMENTAL_SYSTEM_XREF_DB", "MI");
        Cytoscape.getEdgeAttributes().setAttribute(edge.getIdentifier(), "EXPERIMENTAL_SYSTEM_XREF_ID", "MI:0101");
    }

    private static double truncateDouble(double inputDouble, int numberSignificantDigits) {
        double returnDouble = inputDouble * Math.pow(10.0, numberSignificantDigits);
        returnDouble = Math.rint(returnDouble);
        return returnDouble / Math.pow(10.0, numberSignificantDigits);
    }

    public static String getIPI_SPIdentifier(Sequence sequence) {
        String description = sequence.getName();
        String[] splitArray = description.split("SWISS-PROT:|TREMBL:", 2);
        String proteinId = null;
        if (splitArray.length == 2) {
            proteinId = splitArray[1];
            proteinId = proteinId.split("\\||;|-", 2)[0];
        } else {
            proteinId = splitArray[0];
        }
        return proteinId;
    }

    public static boolean doesNodeContainXref(CyNode node, DatabaseReference dbref) {
        List dbNames = Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), CommonVocab.XREF_DB_NAME);
        List dbIDs = Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), CommonVocab.XREF_DB_ID);
        for (int i = 0; i < dbNames.size(); ++i) {
            String dbID;
            String dbName = (String)dbNames.get(i);
            DatabaseReference nodeXref = new DatabaseReference(dbName, dbID = (String)dbIDs.get(i));
            if (!nodeXref.equals((Object)dbref)) continue;
            return true;
        }
        return false;
    }

    public static DatabaseReference[] getDatabaseXrefsForNode(CyNetwork net, CyNode node) {
        List dbNames = Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), CommonVocab.XREF_DB_NAME);
        List dbIDs = Cytoscape.getNodeAttributes().getListAttribute(node.getIdentifier(), CommonVocab.XREF_DB_ID);
        if (dbNames.size() != dbIDs.size()) {
            throw new IllegalStateException("Error: " + CommonVocab.XREF_DB_NAME + " and " + CommonVocab.XREF_DB_ID + " were not the same length for node " + node.getIdentifier() + ".");
        }
        DatabaseReference[] dbrefs = new DatabaseReference[dbNames.size()];
        for (int i = 0; i < dbNames.size(); ++i) {
            String dbName = (String)dbNames.get(i);
            String dbID = (String)dbIDs.get(i);
            dbrefs[i] = new DatabaseReference(dbName, dbID);
        }
        return dbrefs;
    }

    static {
        nodeCount = 0;
        queryNameToAccession = new HashMap();
        hitNameToAccession = new HashMap();
    }
}

