/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.Matrix;
import mt.MatrixEntry;

import java.util.Iterator;

/**
 * Test of unit, triangular matrices
 */
public abstract class UnitTriangMatrixTest extends TriangMatrixTest {

	public UnitTriangMatrixTest(String arg0) {
		super(arg0);
	}

	public void testAddDiagonal() {
		// Not applicable to unit triangular matrices
	}

	public void testAddOneDiagonal() {
		// Not applicable to unit triangular matrices
	}

	public void testAddZeroDiagonal() {
		// Not applicable to unit triangular matrices
	}

	public void testIteratorSet() {
		double alpha = Math.random();
		/*for (MatrixEntry e : A)
			if (e.row() != e.column())
				e.set(e.get() * alpha);*/
		MatrixEntry e;
		Iterator iter = A.iterator();
		while(iter.hasNext()) {
			e = (MatrixEntry) iter.next();
			if (e.row() != e.column())
				e.set(e.get() * alpha);
		}
		assertEquals(Utilities.unitSet(scale(alpha)), A);
	}

	public void testIteratorSetGet() {
		// Not applicable to unit triangular matrices
	}

	public void testScale() {
		// Not applicable to unit triangular matrices
	}

	public void testZero() {
		// Not applicable to unit triangular matrices
	}

	public void testZeroScale() {
		// Not applicable to unit triangular matrices
	}

	/**
	 * We can't zero, so we do without
	 */
	public void testCopy() {
		Matrix Ac = A.copy();
		assertEquals(Ad, Ac);
	}

	public void testAdd() {
		double alpha = Math.random();
		/*for (MatrixEntry e : A)
			if (e.row() != e.column()) {
				A.add(e.row(), e.column(), alpha);
				A.add(e.row(), e.column(), -alpha);
			}*/
		MatrixEntry e;
		Iterator iter = A.iterator();
		while(iter.hasNext()) {
			e = (MatrixEntry) iter.next();
			if (e.row() != e.column()) {
				A.add(e.row(), e.column(), alpha);
				A.add(e.row(), e.column(), -alpha);
			}
		}
		assertEquals(Ad, A);
	}

}
