/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.prec;

import mt.Matrix;
import mt.Vector;

/**
 * Composite preconditioner. Applies several preconditioners in sequence
 * serially.
 */
public class CompositePreconditioner implements Preconditioner {

	/**
	 * The preconditioners which are applied sequentially
	 */
	private Preconditioner[] preconditioners;

	/**
	 * Constructor for CompositePreconditioner.
	 * 
	 * @param preconditioners
	 *            The preconditioners to apply
	 */
	public CompositePreconditioner(Preconditioner[] preconditioners) {
		this.preconditioners = preconditioners;
	}

	public Vector apply(Vector b, Vector x) {
		/*for (Preconditioner preconditioner : preconditioners)
			preconditioner.apply(b, x);*/
		for(int i = 0; i < preconditioners.length; ++i) {
			preconditioners[i].apply(b,x);
		}
		return x;
	}

	public Vector transApply(Vector b, Vector x) {
		/*for (Preconditioner preconditioner : preconditioners)
			preconditioner.transApply(b, x);*/
		for(int i = 0; i < preconditioners.length; ++i) {
			preconditioners[i].transApply(b, x);
		}
		return x;
	}

	public void setMatrix(Matrix A) {
		/*for (Preconditioner preconditioner : preconditioners)
			preconditioner.setMatrix(A);*/
		for(int i = 0; i < preconditioners.length; ++i) {
			preconditioners[i].setMatrix(A);
		}
	}

}
