/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter;

import java.util.LinkedList;
import java.util.List;

import mt.Vector;

/**
 * Stores all the residuals in an array, which the user can retrieve
 * afterwards.
 */
public class ArrayIterationReporter implements IterationReporter {

	/**
	 * Contains all the residuals
	 */
	//private List < Double > array;
	private List array;

	/**
	 * Constructor for ArrayIterationReporter.
	 */
	public ArrayIterationReporter() {
		//array = new LinkedList < Double > ();
		array = new LinkedList ();
	}

	/**
	 * Retrives all the residuals in an array. Array index is the iteration
	 * number.
	 * 
	 * @return Array of residuals
	 */
	public double[] getArray() {
		Double[] residuals = (Double[]) array.toArray(new Double[array.size()]);
		double[] r = new double[array.size()];
		for (int i = 0; i < r.length; ++i)
			r[i] = residuals[i].doubleValue();
		return r;
	}

	public void monitor(double r, int i) {
		array.add(i, new Double(r));
	}

	public void monitor(double r, Vector x, int i) {
		monitor(r, i);
	}

}
