/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.LowerSymmBandMatrix;
import mt.UpperSymmBandMatrix;
import mt.fact.NotConvergedException;
import mt.fact.SymmBandEigenvalueComputer;
import mt.fact.SymmEigenvalueDecomposition;
import mt.ll.BLASkernel.UpLo;

/**
 * Test of the symmetric, tridiagonal eigenvalue solver
 */
public class SymmBandEigenvalueTest extends SymmEigenvalueTest {

	private LowerSymmBandMatrix L;

	private UpperSymmBandMatrix U;

	public SymmBandEigenvalueTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		super.setUp();
		int kd = Utilities.getInt(A.numRows());
		L = new LowerSymmBandMatrix(A, kd);
		U = new UpperSymmBandMatrix(A, kd);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		L = null;
		U = null;
	}

	public void testLowerStaticFactorize() throws NotConvergedException {
		assertEquals(
			L,
			SymmBandEigenvalueComputer.factorize(
				L.copy(),
				L.numSubDiagonals()));
	}

	public void testLowerRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(
			L,
			SymmBandEigenvalueComputer.factorize(
				L.copy(),
				L.numSubDiagonals()));
		assertEquals(
			L,
			SymmBandEigenvalueComputer.factorize(
				L.copy(),
				L.numSubDiagonals()));
	}

	public void testUpperStaticFactorize() throws NotConvergedException {
		assertEquals(
			U,
			SymmBandEigenvalueComputer.factorize(
				U.copy(),
				U.numSuperDiagonals()));
	}

	public void testUpperRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(
			U,
			SymmBandEigenvalueComputer.factorize(
				U.copy(),
				U.numSuperDiagonals()));
		assertEquals(
			U,
			SymmBandEigenvalueComputer.factorize(
				U.copy(),
				U.numSuperDiagonals()));
	}

	public void testLowerFactor() throws NotConvergedException {
		SymmBandEigenvalueComputer ec =
			new SymmBandEigenvalueComputer(A.numRows(), UpLo.Lower);
		assertEquals(L, ec.factor((LowerSymmBandMatrix)L.copy()));
	}

	public void testUpperFactor() throws NotConvergedException {
		SymmBandEigenvalueComputer ec =
			new SymmBandEigenvalueComputer(A.numRows(), UpLo.Upper);
		assertEquals(U, ec.factor((UpperSymmBandMatrix)U.copy()));
	}

	public void testLowerRepeatFactor() throws NotConvergedException {
		SymmBandEigenvalueComputer ec =
			new SymmBandEigenvalueComputer(A.numRows(), UpLo.Lower);
		SymmEigenvalueDecomposition evd = ec.factor((LowerSymmBandMatrix)L.copy());
		assertEquals(L, evd);
		evd = ec.factor((LowerSymmBandMatrix)L.copy(), evd);
		assertEquals(L, evd);
	}

	public void testUpperRepeatFactor() throws NotConvergedException {
		SymmBandEigenvalueComputer ec =
			new SymmBandEigenvalueComputer(A.numRows(), UpLo.Upper);
		SymmEigenvalueDecomposition evd = ec.factor((UpperSymmBandMatrix)U.copy());
		assertEquals(U, evd);
		evd = ec.factor((UpperSymmBandMatrix)U.copy(), evd);
		assertEquals(U, evd);
	}

}
