/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.fact;

import java.io.Serializable;

import mt.DenseMatrix;
import mt.ll.LAPACKkernel.JobEig;

/**
 * Symmetric eigenvalue decomposition. Only for storage, use an appropriate
 * eigenvalue computer to create a factorization
 */
public class SymmEigenvalueDecomposition implements Serializable {

	private static final long serialVersionUID = -7778594932031898170L;

	/**
	 * The eigenvalues
	 */
	private double[] w;

	/**
	 * The eigenvectors stored columnwise
	 */
	private DenseMatrix Z;

	/**
	 * Allocates storage for an eigenvalue computation
	 * 
	 * @param n
	 *            Size of the matrix
	 * @param job
	 *            Job to allocate storage for
	 */
	public SymmEigenvalueDecomposition(int n, JobEig job) {
		w = new double[n];

		if (job == JobEig.All)
			Z = new DenseMatrix(n, n);
	}

	/**
	 * Allocates storage for an eigenvalue computation. Includes eigenvectors
	 * 
	 * @param n
	 *            Size of the matrix
	 */
	public SymmEigenvalueDecomposition(int n) {
		this(n, JobEig.All);
	}

	public double[] getEigenvalues() {
		return w;
	}

	public DenseMatrix getEigenvectors() {
		return Z;
	}

	public boolean hasEigenvectors() {
		return Z != null;
	}

}
