/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.ExtendedFieldHandler;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.Messages;

public abstract class MappingLoader
implements MappingResolver {
    private static final String CompiledSuffix = "Descriptor";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private boolean _allowRedefinitions = false;
    private Hashtable _clsDescs = new Hashtable();
    private Vector _javaClasses = new Vector();
    private PrintWriter _logWriter;
    private ClassLoader _loader;
    public static final ClassDescriptor NoDescriptor = new ClassDescriptorImpl(class$java$lang$Class == null ? (class$java$lang$Class = MappingLoader.class$("java.lang.Class")) : class$java$lang$Class);
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$exolab$castor$mapping$FieldHandler;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$io$Serializable;

    protected MappingLoader(ClassLoader loader, PrintWriter logWriter) {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        this._loader = loader;
        this._logWriter = logWriter;
    }

    public ClassDescriptor getDescriptor(Class type) {
        return (ClassDescriptor)this._clsDescs.get(type);
    }

    public Enumeration listDescriptors() {
        return this._clsDescs.elements();
    }

    public Enumeration listJavaClasses() {
        return this._javaClasses.elements();
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    protected PrintWriter getLogWriter() {
        return this._logWriter;
    }

    protected Class resolveType(String typeName) throws ClassNotFoundException {
        return Types.typeFromName(this._loader, typeName);
    }

    public void loadMapping(MappingRoot mapping, Object param) throws MappingException {
        Enumeration enumeration = mapping.enumerateClassMapping();
        while (enumeration.hasMoreElements()) {
            ClassMapping clsMap = (ClassMapping)enumeration.nextElement();
            ClassDescriptor clsDesc = this.createDescriptor(clsMap);
            if (clsDesc != NoDescriptor) {
                this.addDescriptor(clsDesc);
            }
            if (clsDesc != NoDescriptor || this._logWriter == null) continue;
            this._logWriter.println(Messages.format("mapping.ignoringMapping", clsMap.getName()));
        }
        enumeration = this._clsDescs.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor clsDesc = (ClassDescriptor)enumeration.nextElement();
            if (clsDesc == NoDescriptor) continue;
            this.resolveRelations(clsDesc);
        }
    }

    public void setAllowRedefinitions(boolean allow) {
        this._allowRedefinitions = allow;
    }

    protected void addDescriptor(ClassDescriptor clsDesc) throws MappingException {
        Class clazz = clsDesc.getJavaClass();
        if (this._clsDescs.containsKey(clazz)) {
            if (!this._allowRedefinitions) {
                throw new MappingException("mapping.duplicateDescriptors", clazz.getName());
            }
        } else {
            this._javaClasses.addElement(clazz);
        }
        this._clsDescs.put(clazz, clsDesc);
    }

    protected void resolveRelations(ClassDescriptor clsDesc) throws MappingException {
        FieldDescriptor[] fields = clsDesc.getFields();
        int i = 0;
        while (i < fields.length) {
            ClassDescriptor relDesc = this.getDescriptor(fields[i].getFieldType());
            if (relDesc != NoDescriptor && relDesc != null && fields[i] instanceof FieldDescriptorImpl) {
                ((FieldDescriptorImpl)fields[i]).setClassDescriptor(relDesc);
            }
            ++i;
        }
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        String hack;
        ClassDescriptor depend;
        ClassDescriptor extend;
        Class javaClass;
        ClassDescriptor clsDesc;
        block39: {
            block38: {
                clsDesc = this.loadClassDescriptor(clsMap.getName());
                if (clsDesc != null) {
                    return clsDesc;
                }
                try {
                    javaClass = this.resolveType(clsMap.getName());
                }
                catch (ClassNotFoundException except) {
                    throw new MappingException("mapping.classNotFound", clsMap.getName());
                }
                if (clsMap.getExtends() != null) {
                    try {
                        extend = this.getDescriptor(this.resolveType(((ClassMapping)clsMap.getExtends()).getName()));
                        if (extend == null) {
                            throw new MappingException("mapping.extendsMissing", clsMap.getExtends(), javaClass.getName());
                        }
                        if (extend == NoDescriptor) {
                            throw new MappingException("mapping.extendsNoMapping", clsMap.getExtends(), javaClass.getName());
                        }
                        break block38;
                    }
                    catch (ClassNotFoundException except) {
                        throw new MappingException(except);
                    }
                }
                extend = null;
            }
            if (clsMap.getDepends() != null) {
                try {
                    depend = this.getDescriptor(this.resolveType(((ClassMapping)clsMap.getDepends()).getName()));
                    if (depend == null) {
                        throw new MappingException("Depends not found" + clsMap.getDepends() + " " + javaClass.getName());
                    }
                    if (depend == NoDescriptor) {
                        throw new MappingException("Depends not found" + clsMap.getDepends() + " " + javaClass.getName());
                    }
                    break block39;
                }
                catch (ClassNotFoundException except) {
                    throw new MappingException(except);
                }
            }
            depend = null;
        }
        FieldMapping[] fm = clsMap.getFieldMapping();
        Object[] fields = this.createFieldDescs(javaClass, fm);
        int i = 0;
        while (i < fields.length) {
            int j = i + 1;
            while (j < fields.length) {
                if (fields[i].getFieldName().equals(fields[j].getFieldName())) {
                    throw new MappingException("The field " + fields[i].getFieldName() + " appears twice in the descriptor for " + javaClass.getName());
                }
                ++j;
            }
            ++i;
        }
        FieldDescriptor[] identities = null;
        boolean idfield = false;
        ClassMapping origin = clsMap;
        Vector<Object> fieldList = new Vector<Object>();
        while (origin.getExtends() != null) {
            origin = (ClassMapping)origin.getExtends();
        }
        String[] ids = origin.getIdentity();
        if (ids != null && ids.length > 0) {
            int i2;
            if (ids.length > fields.length && origin == clsMap) {
                String badIdentities = "";
                String delimiter = " or ";
                int index = 0;
                while (index < ids.length) {
                    badIdentities = badIdentities + ids[index];
                    if (index != ids.length - 1) {
                        badIdentities = badIdentities + delimiter;
                    }
                    ++index;
                }
                throw new MappingException("mapping.identityMissing", badIdentities, javaClass.getName());
            }
            identities = new FieldDescriptor[ids.length];
            int i3 = 0;
            while (i3 < fields.length) {
                idfield = false;
                int k = 0;
                while (k < ids.length) {
                    if (fields[i3].getFieldName().equals(ids[k])) {
                        identities[k] = fields[i3];
                        idfield = true;
                        break;
                    }
                    ++k;
                }
                if (idfield) {
                    if (fields[i3] instanceof FieldDescriptorImpl) {
                        ((FieldDescriptorImpl)fields[i3]).setRequired(true);
                    }
                    if (fields[i3].getHandler() instanceof FieldHandlerImpl) {
                        ((FieldHandlerImpl)fields[i3].getHandler()).setRequired(true);
                    }
                } else {
                    fieldList.addElement(fields[i3]);
                }
                ++i3;
            }
            if (extend != null) {
                if (extend instanceof ClassDescriptorImpl) {
                    ClassDescriptorImpl extendImpl = (ClassDescriptorImpl)extend;
                    i2 = 0;
                    while (i2 < identities.length) {
                        if (identities[i2] == null) {
                            identities[i2] = extendImpl.getIdentities()[i2];
                        }
                        ++i2;
                    }
                } else if (identities[0] == null) {
                    identities = extend.getIdentity() != null ? new FieldDescriptor[]{extend.getIdentity()} : new FieldDescriptor[]{};
                }
            }
            fields = new FieldDescriptor[fieldList.size()];
            fieldList.copyInto(fields);
            if (ids != null && ids.length > 0 && (identities == null || identities.length <= 0)) {
                StringBuffer sb = new StringBuffer();
                i2 = 0;
                while (i2 < ids.length) {
                    if (i2 != 0) {
                        sb.append("/");
                    }
                    sb.append(ids[i2]);
                    ++i2;
                }
                throw new MappingException("mapping.identityMissing", sb, javaClass.getName());
            }
        }
        if ((clsDesc = new ClassDescriptorImpl(javaClass, (FieldDescriptor[])fields, identities, extend, depend, AccessMode.getAccessMode(hack = clsMap.getAccess() == null ? "shared" : clsMap.getAccess().toString()), clsMap.getVerifyConstructable())) instanceof ClassDescriptorImpl) {
            ((ClassDescriptorImpl)clsDesc).setMapping(clsMap);
        }
        return clsDesc;
    }

    private String[] breakApart(String strings, char delimit) {
        if (strings == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        int start = 0;
        int count = 0;
        while (count < strings.length()) {
            if (strings.charAt(count) == delimit && start < count - 1) {
                v.addElement(strings.substring(start, count));
                start = ++count;
                continue;
            }
            ++count;
        }
        if (start < count - 1) {
            v.addElement(strings.substring(start, count));
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    protected FieldDescriptor[] createFieldDescs(Class javaClass, FieldMapping[] fieldMaps) throws MappingException {
        if (fieldMaps == null || fieldMaps.length == 0) {
            return new FieldDescriptor[0];
        }
        FieldDescriptor[] fields = new FieldDescriptor[fieldMaps.length];
        int i = 0;
        while (i < fieldMaps.length) {
            fields[i] = this.createFieldDesc(javaClass, fieldMaps[i]);
            ++i;
        }
        return fields;
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            try {
                fieldType = this.resolveType(fieldMap.getType());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getType());
            }
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            Class colType = CollectionHandlers.getCollectionType(fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler(colType);
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        ExtendedFieldHandler exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass = null;
            try {
                handlerClass = this.resolveType(fieldMap.getHandler());
            }
            catch (ClassNotFoundException except) {
                throw new MappingException("mapping.classNotFound", fieldMap.getHandler());
            }
            if (!(class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = MappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).isAssignableFrom(handlerClass)) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + (class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = MappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).getName();
                throw new MappingException(err);
            }
            Constructor constructor = null;
            try {
                constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception except) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        boolean generalized = exfHandler instanceof GeneralizedFieldHandler;
        FieldHandler custom = handler;
        if (generalized) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            TypeInfoReference typeInfoRef = new TypeInfoReference();
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                typeInfo = typeInfoRef.typeInfo;
            }
        }
        FieldDescriptorImpl fieldDesc = new FieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient());
        fieldDesc.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            exfHandler.setFieldDescriptor(fieldDesc);
        }
        return fieldDesc;
    }

    protected FieldHandler createFieldHandler(Class javaClass, Class fieldType, FieldMapping fieldMap, TypeInfoReference typeInfoRef) throws MappingException {
        CollectionHandler colHandler = null;
        Class<?> colType = null;
        FieldHandlerImpl handler = null;
        Method getMethod = null;
        Method setMethod = null;
        Object[] getSequence = null;
        boolean getSetCollection = true;
        Object[] setSequence = null;
        String fieldName = fieldMap.getName();
        if (fieldMap.getCollection() != null) {
            colType = CollectionHandlers.getCollectionType(fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler(colType);
            getSetCollection = CollectionHandlers.isGetSetCollection(colType);
            if (colType == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MappingLoader.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                if (fieldType == null) {
                    String error = "'type' is a required attribute for field that are array collections: " + fieldName;
                    throw new MappingException(error);
                }
                Object obj = Array.newInstance(fieldType, 0);
                colType = obj.getClass();
            }
        }
        if (fieldMap.getDirect()) {
            Field field = this.findField(javaClass, fieldName, colType == null ? fieldType : colType);
            if (field == null) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fieldType == null) {
                fieldType = field.getType();
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
            handler = new FieldHandlerImpl(field, typeInfoRef.typeInfo);
        } else {
            if (fieldMap.getGetMethod() == null && fieldMap.getSetMethod() == null) {
                Vector<Method> getSeq = new Vector<Method>();
                Vector<Method> setSeq = new Vector<Method>();
                if (fieldName == null) {
                    throw new MappingException("mapping.missingFieldName", javaClass.getName());
                }
                String getPrefix = GET_METHOD_PREFIX;
                try {
                    Class<?> returnType;
                    String methodName;
                    int point;
                    while ((point = fieldName.indexOf(46)) >= 0) {
                        Class<?> last = javaClass;
                        String parentField = fieldName.substring(0, point);
                        methodName = GET_METHOD_PREFIX + this.capitalize(parentField);
                        Method method = javaClass.getMethod(methodName, null);
                        fieldName = fieldName.substring(point + 1);
                        if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                            throw new MappingException("mapping.accessorNotAccessible", methodName, javaClass.getName());
                        }
                        getSeq.addElement(method);
                        javaClass = method.getReturnType();
                        methodName = "set" + methodName.substring(getPrefix.length());
                        try {
                            method = last.getMethod(methodName, javaClass);
                            if ((method.getModifiers() & 0x400) != 0 || (method.getModifiers() & 8) != 0) {
                                method = null;
                            }
                        }
                        catch (Exception except) {
                            method = null;
                        }
                        setSeq.addElement(method);
                    }
                    if (getSeq.size() > 0) {
                        getSequence = new Method[getSeq.size()];
                        getSeq.copyInto(getSequence);
                        setSequence = new Method[setSeq.size()];
                        setSeq.copyInto(setSequence);
                    }
                    if ((getMethod = MappingLoader.findAccessor(javaClass, methodName = getPrefix + this.capitalize(fieldName), returnType = colType == null ? fieldType : colType, true)) == null && (fieldType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MappingLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || fieldType == Boolean.TYPE)) {
                        getPrefix = IS_METHOD_PREFIX;
                        methodName = getPrefix + this.capitalize(fieldName);
                        getMethod = MappingLoader.findAccessor(javaClass, methodName, returnType, true);
                    }
                }
                catch (MappingException except) {
                    throw except;
                }
                catch (Exception except) {
                    // empty catch block
                }
                if (getMethod == null) {
                    throw new MappingException("mapping.accessorNotFound", getPrefix + this.capitalize(fieldName), colType == null ? fieldType : colType, javaClass.getName());
                }
                if (fieldType == null && colType == null) {
                    fieldType = getMethod.getReturnType();
                }
                if ((setMethod = MappingLoader.findAccessor(javaClass, "set" + this.capitalize(fieldName), colType == null ? fieldType : colType, false)) == null && colType != null && getSetCollection) {
                    throw new MappingException("mapping.accessorNotFound", "set" + this.capitalize(fieldName), colType == null ? fieldType : colType, javaClass.getName());
                }
            } else {
                if (fieldMap.getGetMethod() != null) {
                    getMethod = MappingLoader.findAccessor(javaClass, fieldMap.getGetMethod(), colType == null ? fieldType : colType, true);
                    if (getMethod == null) {
                        throw new MappingException("mapping.accessorNotFound", fieldMap.getGetMethod(), colType == null ? fieldType : colType, javaClass.getName());
                    }
                    if (fieldType == null && colType == null) {
                        fieldType = getMethod.getReturnType();
                    }
                }
                if (fieldMap.getSetMethod() != null) {
                    String methodName = fieldMap.getSetMethod();
                    Class<?> type = fieldType;
                    if (colType != null && !methodName.startsWith(ADD_METHOD_PREFIX)) {
                        type = colType;
                    }
                    if ((setMethod = MappingLoader.findAccessor(javaClass, fieldMap.getSetMethod(), type, false)) == null) {
                        throw new MappingException("mapping.accessorNotFound", fieldMap.getSetMethod(), type, javaClass.getName());
                    }
                    if (fieldType == null) {
                        fieldType = setMethod.getParameterTypes()[0];
                    }
                }
            }
            typeInfoRef.typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
            fieldName = fieldMap.getName();
            if (fieldName == null) {
                fieldName = getMethod == null ? setMethod.getName() : getMethod.getName();
            }
            handler = new FieldHandlerImpl(fieldName, (Method[])getSequence, (Method[])setSequence, getMethod, setMethod, typeInfoRef.typeInfo);
            if (setMethod != null && setMethod.getName().startsWith(ADD_METHOD_PREFIX)) {
                handler.setAddMethod(setMethod);
            }
        }
        if (fieldMap.getCreateMethod() != null) {
            try {
                Method method = javaClass.getMethod(fieldMap.getCreateMethod(), null);
                handler.setCreateMethod(method);
            }
            catch (Exception except) {
                throw new MappingException("mapping.createMethodNotFound", fieldMap.getCreateMethod(), javaClass.getName());
            }
        }
        if (fieldName != null && !Types.isSimpleType(fieldType)) {
            try {
                Method method = javaClass.getMethod("create" + this.capitalize(fieldName), null);
                handler.setCreateMethod(method);
            }
            catch (Exception except) {
                // empty catch block
            }
        }
        if (fieldName != null) {
            Method hasMethod = null;
            Method deleteMethod = null;
            try {
                hasMethod = fieldMap.getHasMethod() != null ? javaClass.getMethod(fieldMap.getHasMethod(), null) : javaClass.getMethod("has" + this.capitalize(fieldName), null);
                if ((hasMethod.getModifiers() & 8) != 0) {
                    hasMethod = null;
                }
                try {
                    deleteMethod = javaClass.getMethod("delete" + this.capitalize(fieldName), null);
                    if ((deleteMethod.getModifiers() & 8) != 0) {
                        deleteMethod = null;
                    }
                }
                catch (Exception except) {
                    // empty catch block
                }
                handler.setHasDeleteMethod(hasMethod, deleteMethod);
            }
            catch (Exception except) {
                // empty catch block
            }
        }
        return handler;
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        return new TypeInfo(Types.typeFromPrimitive(fieldType), null, null, null, fieldMap.getRequired(), null, colHandler, false);
    }

    private Field findField(Class javaClass, String fieldName, Class fieldType) throws MappingException {
        try {
            Field field = javaClass.getField(fieldName);
            if (field.getModifiers() != 1 && field.getModifiers() != 65) {
                throw new MappingException("mapping.fieldNotAccessible", fieldName, javaClass.getName());
            }
            if (fieldType == null) {
                fieldType = Types.typeFromPrimitive(field.getType());
            } else if (fieldType != (class$java$io$Serializable == null ? (class$java$io$Serializable = MappingLoader.class$("java.io.Serializable")) : class$java$io$Serializable) && Types.typeFromPrimitive(fieldType) != Types.typeFromPrimitive(field.getType())) {
                throw new MappingException("mapping.fieldTypeMismatch", field, fieldType.getName());
            }
            return field;
        }
        catch (NoSuchFieldException except) {
        }
        catch (SecurityException except) {
            // empty catch block
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected static final Method findAccessor(Class javaClass, String methodName, Class fieldType, boolean getMethod) throws MappingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Inconsistent graph @DISABLED, blocks:[0] lbl17 : ThrowStatement: throw new org.exolab.castor.mapping.MappingException((java.lang.String)"mapping.accessorReturnTypeMismatch", (java.lang.Object)method, (java.lang.Object)fieldType.getName());\u000a does not have a source @NONE, blocks:[0] lbl16 : Nop: NOP
         * 
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:49)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner$1.call(Cleaner.java:22)
         *     at org.benf.cfr.reader.util.graph.GraphVisitorDFS.process(GraphVisitorDFS.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Cleaner.removeUnreachableCode(Cleaner.java:54)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:648)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ClassDescriptor loadClassDescriptor(String clsName) {
        return null;
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        if (Character.isUpperCase(first)) {
            return name;
        }
        return Character.toUpperCase(first) + name.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TypeInfoReference {
        TypeInfo typeInfo = null;

        TypeInfoReference() {
        }
    }
}

