/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class OverlayAnnotation
extends AbstractChangeable
implements Annotation,
Serializable {
    private transient ChangeListener propertyForwarder = null;
    private Annotation parent;
    private Map overlay = null;

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport changeSupport = super.getChangeSupport(changeType);
        if ((Annotation.PROPERTY.isMatchingType(changeType) || changeType.isMatchingType(Annotation.PROPERTY)) && this.propertyForwarder == null) {
            this.propertyForwarder = new PropertyForwarder(this, changeSupport);
            this.parent.addChangeListener(this.propertyForwarder, Annotation.PROPERTY);
        }
        return changeSupport;
    }

    protected Map getOverlay() {
        if (this.overlay == null) {
            this.overlay = new HashMap();
        }
        return this.overlay;
    }

    public OverlayAnnotation(Annotation par) {
        this.parent = par;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object key, Object value) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport = this.getChangeSupport(Annotation.PROPERTY);
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, value}, new Object[]{key, this.getProperty(key)});
            ChangeSupport changeSupport2 = changeSupport;
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.getOverlay().put(key, value);
                changeSupport.firePostChangeEvent(ce);
            }
        } else {
            this.getOverlay().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(Object key) throws ChangeVetoException {
        if (this.overlay == null || !this.overlay.containsKey(key)) {
            if (this.parent.containsProperty(key)) {
                throw new ChangeVetoException("Can't remove properties from the parent annotation");
            }
            throw new NoSuchElementException("Property doesn't exist: " + key);
        }
        if (this.hasListeners()) {
            ChangeSupport changeSupport = this.getChangeSupport(Annotation.PROPERTY);
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, null}, new Object[]{key, this.getProperty(key)});
            ChangeSupport changeSupport2 = changeSupport;
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.getOverlay().remove(key);
                changeSupport.firePostChangeEvent(ce);
            }
        } else {
            this.getOverlay().remove(key);
        }
    }

    public Object getProperty(Object key) {
        Object val = null;
        if (this.overlay != null) {
            val = this.overlay.get(key);
        }
        if (val != null) {
            return val;
        }
        return this.parent.getProperty(key);
    }

    public boolean containsProperty(Object key) {
        if (this.overlay != null && this.overlay.containsKey(key)) {
            return true;
        }
        return this.parent.containsProperty(key);
    }

    private Object getPropertySilent(Object key) {
        try {
            return this.getProperty(key);
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public Set keys() {
        return new OAKeySet();
    }

    public Map asMap() {
        return new OAMap();
    }

    protected class PropertyForwarder
    extends ChangeForwarder {
        public PropertyForwarder(Object source, ChangeSupport cs) {
            super(source, cs);
        }

        public ChangeEvent generateEvent(ChangeEvent ce) {
            Object[] cur;
            Object curVal;
            ChangeType ct = ce.getType();
            if (ct == Annotation.PROPERTY && (curVal = ce.getChange()) instanceof Object[] && (cur = (Object[])curVal).length == 2) {
                Object key = cur[0];
                Object value = cur[0];
                if (OverlayAnnotation.this.getProperty(key) != value) {
                    return new ChangeEvent(this.getSource(), Annotation.PROPERTY, curVal, ce.getPrevious(), ce);
                }
            }
            return null;
        }
    }

    private class OAMap
    extends AbstractMap {
        OAEntrySet es;
        OAKeySet ks;

        private OAMap() {
            this.ks = new OAKeySet();
            this.es = new OAEntrySet();
        }

        public Set entrySet() {
            return this.es;
        }

        public Set keySet() {
            return this.ks;
        }

        public Object get(Object key) {
            try {
                return OverlayAnnotation.this.getProperty(key);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
    }

    private class OAMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private OAMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            return (this.key == null ? mo.getKey() == null : this.key.equals(mo.getKey())) && (this.value == null ? mo.getValue() == null : this.value.equals(mo.getValue()));
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class OAEntrySet
    extends AbstractSet {
        OAKeySet ks;

        private OAEntrySet() {
            this.ks = new OAKeySet();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator ksi;
                {
                    this.ksi = OAEntrySet.this.ks.iterator();
                }

                public boolean hasNext() {
                    return this.ksi.hasNext();
                }

                public Object next() {
                    Object k = this.ksi.next();
                    Object v = OverlayAnnotation.this.getProperty(k);
                    return new OAMapEntry(k, v);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return this.ks.size();
        }
    }

    private class OAKeySet
    extends AbstractSet {
        private Set parentKeys;

        private OAKeySet() {
            this.parentKeys = OverlayAnnotation.this.parent.keys();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator oi;
                Iterator pi;
                Object peek;
                {
                    this.oi = OverlayAnnotation.this.overlay != null ? OverlayAnnotation.this.overlay.keySet().iterator() : Collections.EMPTY_SET.iterator();
                    this.pi = OAKeySet.this.parentKeys.iterator();
                    this.peek = null;
                }

                public boolean hasNext() {
                    if (this.peek == null) {
                        this.peek = this.nextObject();
                    }
                    return this.peek != null;
                }

                public Object next() {
                    if (this.peek == null) {
                        this.peek = this.nextObject();
                    }
                    if (this.peek == null) {
                        throw new NoSuchElementException();
                    }
                    Object o = this.peek;
                    this.peek = null;
                    return o;
                }

                private Object nextObject() {
                    if (this.oi.hasNext()) {
                        return this.oi.next();
                    }
                    Object po = null;
                    while (po == null && this.pi.hasNext()) {
                        po = this.pi.next();
                        if (OverlayAnnotation.this.overlay == null || !OverlayAnnotation.this.overlay.containsKey(po)) continue;
                        po = null;
                    }
                    return po;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            int i = 0;
            Iterator keys = this.iterator();
            while (keys.hasNext()) {
                keys.next();
                ++i;
            }
            return i;
        }

        public boolean contains(Object o) {
            return OverlayAnnotation.this.overlay != null && OverlayAnnotation.this.overlay.containsKey(o) || this.parentKeys.contains(o);
        }
    }
}

