/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.util;

import java.io.IOException;
import java.io.StringReader;
import org.mskcc.dataservices.core.DataServiceException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlValidator
extends DefaultHandler {
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println(this.makeErrorMessage("Warning", sAXParseException));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(this.makeErrorMessage("Error", sAXParseException));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(this.makeErrorMessage("Fatal Error", sAXParseException));
    }

    protected String makeErrorMessage(String string, SAXParseException sAXParseException) {
        int n;
        if (sAXParseException == null) {
            return "[" + string + "] " + "!!!";
        }
        String string2 = sAXParseException.getSystemId();
        if (string2 != null && (n = string2.lastIndexOf(47)) != -1) {
            string2 = string2.substring(n + 1);
        }
        return "[" + string + "] " + ':' + sAXParseException.getLineNumber() + ':' + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage();
    }

    public static void validate(String string) throws DataServiceException {
        XmlValidator xmlValidator = new XmlValidator();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            xMLReader.setFeature(VALIDATION_FEATURE_ID, true);
            xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
            xMLReader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, true);
            xMLReader.setContentHandler(xmlValidator);
            xMLReader.setErrorHandler(xmlValidator);
            xMLReader.parse(new InputSource(new StringReader(string)));
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new DataServiceException(sAXNotRecognizedException.toString());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new DataServiceException(sAXNotSupportedException.toString());
        }
        catch (SAXParseException sAXParseException) {
            throw new DataServiceException(sAXParseException.toString());
        }
        catch (SAXException sAXException) {
            throw new DataServiceException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new DataServiceException(iOException.toString());
        }
    }
}

