/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.task;

import csplugins.dataviewer.mapper.MapGraphToInteractions;
import csplugins.dataviewer.ui.ErrorDisplay;
import csplugins.task.BaseTask;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.mskcc.dataservices.mapper.MapInteractionsToPsi;
import org.mskcc.dataservices.schemas.psi.EntrySet;

public class ExportPsiTask
extends BaseTask {
    private File file;
    private CyNetwork cyNetwork;
    private Component parentFrame;
    private static final String TASK_TITLE = "Exporting to PSI-MI";

    public ExportPsiTask(CyNetwork cyNetwork, File file) {
        super(TASK_TITLE);
        this.cyNetwork = cyNetwork;
        this.file = file;
    }

    public void setParentFrame(Component component) {
        this.parentFrame = component;
    }

    public void executeTask() throws Exception {
        try {
            this.setProgressMessage("Exporting to PSI-MI Format.");
            this.setMaxProgressValue(3);
            this.setProgressValue(0);
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            MapGraphToInteractions mapGraphToInteractions = new MapGraphToInteractions(cyNetwork);
            mapGraphToInteractions.doMapping();
            this.setProgressValue(1);
            ArrayList arrayList = mapGraphToInteractions.getInteractions();
            MapInteractionsToPsi mapInteractionsToPsi = new MapInteractionsToPsi(arrayList);
            mapInteractionsToPsi.doMapping();
            this.setProgressValue(2);
            EntrySet entrySet = mapInteractionsToPsi.getPsiXml();
            FileWriter fileWriter = new FileWriter(this.file);
            entrySet.marshal(fileWriter);
            String string = "PSI-MI written to file:  " + this.file;
            this.setProgressValue(3);
            this.updateUser(string);
        }
        catch (Exception exception) {
            this.showError(exception);
            throw exception;
        }
    }

    private void updateUser(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(ExportPsiTask.this.parentFrame, string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void showError(final Throwable throwable) {
        Runnable runnable = new Runnable(){

            public void run() {
                ErrorDisplay errorDisplay = new ErrorDisplay((JFrame)ExportPsiTask.this.parentFrame);
                errorDisplay.displayError(throwable);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

