/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.action;

import csplugins.dataviewer.action.BaseAction;
import csplugins.dataviewer.task.ExportPsiTask;
import csplugins.dataviewer.task.LoadPsiTask;
import csplugins.dataviewer.util.SimpleFileFilter;
import csplugins.task.Task;
import csplugins.task.ui.TaskMonitorUI;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeObj;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class LoadPsi
extends BaseAction {
    public static final String ACTION_IMPORT_PSI_WEB = "load_psi_web";
    public static final String ACTION_IMPORT_PSI_FILE = "load_psi_file";
    public static final String ACTION_EXPORT_PSI = "export_psi";
    private CytoscapeDesktop desktop = Cytoscape.getDesktop();

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals(ACTION_IMPORT_PSI_FILE)) {
                this.importPsiFile();
            } else if (string.equals(ACTION_IMPORT_PSI_WEB)) {
                this.importPsiWeb();
            } else if (string.equals(ACTION_EXPORT_PSI)) {
                this.exportPsiFile();
            }
        }
        catch (Exception exception) {
            this.showError(exception);
        }
    }

    private void importPsiWeb() {
        URL uRL = this.getURL("Enter URL for PSI-MI Document:  ");
        if (uRL != null) {
            LoadPsiTask loadPsiTask;
            File file;
            if (uRL.getProtocol().equalsIgnoreCase("file")) {
                file = new File(uRL.getFile());
                loadPsiTask = new LoadPsiTask(file);
            } else {
                loadPsiTask = new LoadPsiTask(uRL);
            }
            file = Cytoscape.getDesktop();
            loadPsiTask.setParentFrame((Component)((Object)file));
            this.startTask(loadPsiTask);
        }
    }

    private void importPsiFile() {
        String[] stringArray = new String[]{"xml"};
        String string = this.getFile(stringArray, "XML Files (*.xml)");
        if (string != null) {
            File file = new File(string);
            LoadPsiTask loadPsiTask = new LoadPsiTask(file);
            CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
            loadPsiTask.setParentFrame((Component)cytoscapeDesktop);
            this.startTask(loadPsiTask);
        }
    }

    private void exportPsiFile() throws ValidationException, IOException, MarshalException {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        String[] stringArray = new String[]{"xml"};
        jFileChooser.setFileFilter(new SimpleFileFilter(stringArray, "XML Files (*.xml)"));
        CytoscapeObj cytoscapeObj = Cytoscape.getCytoscapeObj();
        File file = cytoscapeObj.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if ((n = jFileChooser.showSaveDialog((Component)this.desktop)) == 0) {
            file = jFileChooser.getSelectedFile();
            if ((file = this.conditionallyAddFileExtension(file)).exists()) {
                String string = "File:  " + file + " exists.  " + "Do you want to overwrite it?";
                int n2 = JOptionPane.showConfirmDialog((Component)this.desktop, string, "Overwrite Existing File?", 0);
                if (n2 == 0) {
                    this.exportPsi(file);
                }
            } else {
                this.exportPsi(file);
            }
        } else {
            file = jFileChooser.getCurrentDirectory();
        }
        cytoscapeObj.setCurrentDirectory(file);
    }

    private File conditionallyAddFileExtension(File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(file.toString(), ".");
        String string = (String)stringTokenizer.nextElement();
        if (stringTokenizer.hasMoreElements()) {
            return file;
        }
        return new File(file + ".xml");
    }

    private void exportPsi(File file) {
        ExportPsiTask exportPsiTask = new ExportPsiTask(Cytoscape.getCurrentNetwork(), file);
        CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
        exportPsiTask.setParentFrame((Component)cytoscapeDesktop);
        this.startTask(exportPsiTask);
    }

    private void startTask(Task task) {
        CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
        new TaskMonitorUI(task, true, true, true, 0, (Component)cytoscapeDesktop);
        task.start();
    }
}

