/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.bio;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.Matrix;
import org.mskcc.dataservices.util.StringParser;

public class TestMatrix
extends TestCase {
    public void testObjectMatrix() {
        ArrayList arrayList = this.createSampleHeaders();
        HashMap hashMap = this.createSampleDescriptions();
        ArrayList arrayList2 = this.createSampleData();
        int n = StringParser.countColumns(arrayList2);
        Matrix matrix = new Matrix(arrayList2.size(), n);
        matrix.setHeaderNames(arrayList);
        matrix.setHeaderDescriptions(hashMap);
        matrix.setIdColumn(1);
        StringParser.parseIntoMatrix(matrix, arrayList2);
        String string = matrix.getId(0);
        TestMatrix.assertEquals((String)"YLR331C", (String)string);
        double d = matrix.getDataDouble(0, 2);
        TestMatrix.assertEquals((double)268.8, (double)d, (double)0.01);
        double d2 = matrix.getDataDouble(0, 9);
        TestMatrix.assertEquals((double)121.7, (double)d2, (double)0.01);
    }

    private ArrayList createSampleData() {
        String string = new String("10000_at\tYLR331C\t268.8\t141.4\t173.9\t123.2\t298.6\t424.8\t128.9\t121.7");
        String string2 = new String("10001_at\tYLR332W\t5962.8\t3892.9\t4313.5\t3604.4\t4263.2\t2786.8\t5179.9\t2634");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    private ArrayList createSampleHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ID_REF");
        arrayList.add("IDENTIFIER");
        arrayList.add("GSM6219");
        arrayList.add("GSM6220");
        arrayList.add("GSM6221");
        arrayList.add("GSM6222");
        arrayList.add("GSM6223");
        arrayList.add("GSM6224");
        arrayList.add("GSM6225");
        arrayList.add("GSM6226");
        return arrayList;
    }

    private HashMap createSampleDescriptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ID_REF", "Platform reference identifier");
        hashMap.put("IDENTIFIER", "probe identifier");
        hashMap.put("GSM6219", "Value for GSM6219: sgs (6-C-20211); src: sgs (6-C-20211)");
        hashMap.put("GSM6220", "Value for GSM6220: sgs rep (5) C-20229; src: sgs rep (5) C-20229");
        hashMap.put("GSM6221", "Value for GSM6221: sgs + mms (6-C-20212); src: sgs + mms (6-C-20212)");
        hashMap.put("GSM6222", "Value for GSM6222: sgs mms rep (7) C-20230; src: sgs mms rep (7) C-20230");
        hashMap.put("GSM223", "Value for GSM6223: wt (2-20156); src: wt (2-20156)");
        hashMap.put("GSM6224", "Value for GSM6224: wt rep (1)C-20239; src: wt rep (1)C-20239");
        hashMap.put("GSM6225", "Value for GSM6225: wt + mms (4-C-20157); src: wt + mms (4-C-20157)");
        hashMap.put("GSM6226", "Value for GSM6226: wt mms rep (3)C-20228; src: wt mms rep (3) C-20228");
        return hashMap;
    }
}

