/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.protocol;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.core.EmptySetException;

public class CPathProtocol {
    public static final String ARG_COMMAND = "cmd";
    public static final String ARG_QUERY = "q";
    public static final String ARG_FORMAT = "format";
    public static final String ARG_ORGANISM = "organism";
    public static final String ARG_MAX_HITS = "maxHits";
    public static final String ARG_START_INDEX = "startIndex";
    public static final String ARG_VERSION = "version";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_COUNT_ONLY = "count_only";
    public static final String CURRENT_VERSION = "1.0";
    public static final String COMMAND_GET_BY_KEYWORD = "get_by_keyword";
    public static final String COMMAND_GET_BY_INTERACTOR_XREF = "get_by_interactor_name_xref";
    public static final String COMMAND_GET_BY_ORGANISM = "get_by_organism";
    public static final String COMMAND_GET_BY_EXPERIMENT_TYPE = "get_by_experiment_type";
    public static final String COMMAND_GET_BY_PMID = "get_by_pmid";
    public static final String COMMAND_GET_BY_DATABASE = "get_by_database";
    public static final int DEFAULT_MAX_HITS = 10;
    public static final int NOT_SPECIFIED = -1;
    private static final String XML_TAG = "xml";
    private String command;
    private String query;
    private int taxonomyId;
    private int maxHits;
    private int startIndex;
    private String format;
    private String url;

    public CPathProtocol(String string) {
        this.url = string;
        this.maxHits = 10;
        this.taxonomyId = -1;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setOrganism(int n) {
        this.taxonomyId = n;
    }

    public void setMaxHits(int n) {
        this.maxHits = n;
    }

    public void setStartIndex(int n) {
        this.startIndex = n;
    }

    public String connect() throws DataServiceException {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(this.url);
        NameValuePair[] nameValuePairArray = this.createNameValuePairs();
        getMethod.setQueryString(nameValuePairArray);
        try {
            int n = httpClient.executeMethod(getMethod);
            this.checkHttpStatusCode(n);
            String string = getMethod.getResponseBodyAsString();
            if (string.toLowerCase().indexOf("xml") >= 0) {
                StringReader stringReader = new StringReader(string);
                SAXBuilder sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build((Reader)stringReader);
                this.checkForErrors(document);
                return string;
            }
            return string.trim();
        }
        catch (UnknownHostException unknownHostException) {
            String string = "Network error occurred while tring to connect to the cPath Web Service.  Could not find server:  " + unknownHostException.getMessage() + ". Please check your server and network settings, " + "and try again.";
            throw new DataServiceException(unknownHostException, string);
        }
        catch (IOException iOException) {
            String string = "Network error occurred while trying to connect to the cPath Web Service.  Please check your server and network settings, and try again.";
            throw new DataServiceException(iOException, string);
        }
        catch (JDOMException jDOMException) {
            String string = "Error occurred while trying to parse XML results retrieved from the cPath Web Service.  Please check your server and network settings, and try again.";
            throw new DataServiceException(jDOMException, string);
        }
    }

    public String getURI() {
        GetMethod getMethod = new GetMethod(this.url);
        NameValuePair[] nameValuePairArray = this.createNameValuePairs();
        getMethod.setQueryString(nameValuePairArray);
        try {
            return getMethod.getURI().getURI();
        }
        catch (URIException uRIException) {
            return null;
        }
    }

    private NameValuePair[] createNameValuePairs() {
        NameValuePair[] nameValuePairArray = null;
        if (this.taxonomyId == -1) {
            nameValuePairArray = new NameValuePair[6];
        } else {
            nameValuePairArray = new NameValuePair[7];
            nameValuePairArray[6] = new NameValuePair(ARG_ORGANISM, Integer.toString(this.taxonomyId));
        }
        nameValuePairArray[0] = new NameValuePair(ARG_COMMAND, this.command);
        nameValuePairArray[1] = new NameValuePair(ARG_QUERY, this.query);
        nameValuePairArray[2] = new NameValuePair(ARG_FORMAT, this.format);
        nameValuePairArray[3] = new NameValuePair(ARG_VERSION, CURRENT_VERSION);
        nameValuePairArray[4] = new NameValuePair(ARG_MAX_HITS, Integer.toString(this.maxHits));
        nameValuePairArray[5] = new NameValuePair(ARG_START_INDEX, Integer.toString(this.startIndex));
        return nameValuePairArray;
    }

    private void checkHttpStatusCode(int n) throws DataServiceException {
        if (n != 200) {
            String string = HttpStatus.getStatusText(n);
            String string2 = new String("Error Connecting to cPath Web Service (Details:  HTTP Status Code:  " + n + " --> " + string + ")");
            throw new DataServiceException(string2);
        }
    }

    private void checkForErrors(Document document) throws DataServiceException, EmptySetException {
        Element element = document.getRootElement();
        String string = element.getName();
        if (string.equals("error")) {
            String string2 = element.getChild("error_code").getText();
            String string3 = element.getChild("error_msg").getText();
            if (string2.equals("460")) {
                throw new EmptySetException();
            }
            String string4 = new String("Error Connecting to cPath Web Service (Error Code:  " + string2 + ", Error Message:  " + string3 + ")");
            throw new DataServiceException(string4);
        }
    }
}

