/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.interaction;

import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.mapper.MapInteractionsToPsi;
import org.mskcc.dataservices.schemas.psi.EntrySet;
import org.mskcc.dataservices.services.WriteInteractions;

public class WritePsiToCPath
extends DataServiceBase
implements WriteInteractions {
    private String serverResponse;

    public int writeInteractions(ArrayList arrayList) throws DataServiceException {
        try {
            EntrySet entrySet = this.generatePsi(arrayList);
            StringWriter stringWriter = new StringWriter();
            entrySet.marshal(stringWriter);
            String string = stringWriter.toString();
            XmlRpcClient xmlRpcClient = null;
            xmlRpcClient = new XmlRpcClient(this.getLocation());
            Vector<String> vector = new Vector<String>();
            vector.addElement(string);
            this.serverResponse = (String)xmlRpcClient.execute("import.submitData", vector);
            return arrayList.size();
        }
        catch (UnknownHostException unknownHostException) {
            String string = "Network error occurred while tring to write to cPath.  Could not find server:  " + unknownHostException.getMessage() + ". Please check your server and network settings, " + "and try again.";
            throw new DataServiceException(unknownHostException, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new DataServiceException(malformedURLException, "URL for cPath appears to be malformed:  " + this.getLocation() + ".  Please " + "check your network settings and try again.");
        }
        catch (IOException iOException) {
            throw new DataServiceException(iOException, "Network error occurred while trying to submit data to cPath.  Please check your network settings and try again.");
        }
        catch (XmlRpcException xmlRpcException) {
            throw new DataServiceException(xmlRpcException, "Network error occurred while trying to submit data to cPath.  Please check your network settings and try again.");
        }
        catch (ValidationException validationException) {
            throw new DataServiceException(validationException, "Your Cytoscape network could not be properly written out into valid PSI-MI XML Format.  Please check the terminal window for complete details.");
        }
        catch (MarshalException marshalException) {
            throw new DataServiceException(marshalException, "Your Cytoscape network could not be properly written out into valid PSI-MI XML Format.  Please check the terminal window for complete details.");
        }
    }

    public String getServerResponse() {
        return this.serverResponse;
    }

    private EntrySet generatePsi(ArrayList arrayList) {
        MapInteractionsToPsi mapInteractionsToPsi = new MapInteractionsToPsi(arrayList);
        mapInteractionsToPsi.doMapping();
        EntrySet entrySet = mapInteractionsToPsi.getPsiXml();
        return entrySet;
    }
}

