/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.interaction;

import java.util.ArrayList;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.core.EmptySetException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.mapper.MapPsiToInteractions;
import org.mskcc.dataservices.mapper.MapperException;
import org.mskcc.dataservices.protocol.CPathProtocol;

public class ReadPsiFromCPath
extends DataServiceBase {
    public static final int NOT_SPECIFIED = -1;
    private ArrayList interactions;
    private String uri;

    public ReadPsiFromCPath(String string) {
        this.setLocation(string);
    }

    public ArrayList getInteractionsByKeyword(String string, int n, int n2) throws DataServiceException, EmptySetException {
        this.process("get_by_keyword", string, n, 0, n2);
        return this.interactions;
    }

    public ArrayList getInteractionsByKeyword(String string, int n, int n2, int n3) throws DataServiceException, EmptySetException {
        this.process("get_by_keyword", string, n, n2, n3);
        return this.interactions;
    }

    public int getInteractionsCount(String string, int n) throws DataServiceException, EmptySetException {
        int n2;
        CPathProtocol cPathProtocol = new CPathProtocol(this.getLocation());
        cPathProtocol.setCommand("get_by_keyword");
        cPathProtocol.setFormat("count_only");
        cPathProtocol.setQuery(string);
        if (n != -1) {
            cPathProtocol.setOrganism(n);
        }
        this.uri = cPathProtocol.getURI();
        String string2 = cPathProtocol.connect();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataServiceException("Error Occurred while connecting to the cPath Web Service (Details:  Invalid data returned.  Double check that you are using the correct cPath URL.)");
        }
        return n2;
    }

    public ArrayList getInteractionsByKeyword(String string, int n) throws DataServiceException, EmptySetException {
        this.process("get_by_keyword", string, -1, 0, n);
        return this.interactions;
    }

    public String getLastQueryURI() {
        return this.uri;
    }

    private void process(String string, String string2, int n, int n2, int n3) throws DataServiceException {
        try {
            CPathProtocol cPathProtocol = new CPathProtocol(this.getLocation());
            cPathProtocol.setCommand(string);
            cPathProtocol.setFormat("xml");
            cPathProtocol.setQuery(string2);
            cPathProtocol.setStartIndex(n2);
            cPathProtocol.setMaxHits(n3);
            if (n != -1) {
                cPathProtocol.setOrganism(n);
            }
            this.uri = cPathProtocol.getURI();
            String string3 = cPathProtocol.connect();
            this.interactions = new ArrayList();
            MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string3, this.interactions);
            mapPsiToInteractions.doMapping();
        }
        catch (MapperException mapperException) {
            throw new DataServiceException("Error Occurred while connecting to the cPath Web Service (Details:  Could not parse XML response document.  Double check that you are using the correct cPath URL.");
        }
    }
}

