/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.ui;

import csplugins.dataviewer.model.UserSelection;
import csplugins.dataviewer.util.HtmlUtil;
import cytoscape.Cytoscape;
import cytoscape.data.ExpressionData;
import cytoscape.data.GraphObjAttributes;
import cytoscape.data.mRNAMeasurement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;

public class DetailsPanel
extends JPanel
implements Observer {
    private UserSelection userSelection;
    private TitledBorder border;
    private JEditorPane htmlPane;
    private JFrame parent;

    public DetailsPanel(UserSelection userSelection, JFrame jFrame) {
        this.userSelection = userSelection;
        this.parent = jFrame;
        this.userSelection.addObserver(this);
        this.border = new TitledBorder("Node / Edge Details");
        this.setLayout(new BorderLayout());
        this.setBorder(this.border);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        this.add((Component)jScrollPane, "Center");
        this.htmlPane.setText("<FONT FACE=ARIAL>Once cPath data is downloaded, select a node or edge in the main Cytoscape window to view details.</FONT>");
    }

    public void update(Observable observable, Object object) {
        this.parent.show();
        if (object.equals(UserSelection.INTERACTOR_CHANGED)) {
            this.updateInteractor();
        } else {
            this.updateInteraction();
        }
    }

    private void updateInteractor() {
        Interactor interactor = this.userSelection.getSelectedInteractor();
        String string = this.userSelection.getSelectedNodeId();
        this.border = new TitledBorder("Node Details");
        this.setBorder(this.border);
        if (interactor != null) {
            String string2;
            String string3;
            StringBuffer stringBuffer = new StringBuffer();
            HtmlUtil.startTable(stringBuffer);
            HtmlUtil.addData(stringBuffer, "Short Name:  ", interactor.getName().trim());
            String string4 = (String)interactor.getAttribute("FULL_NAME");
            if (string4 != null && string4.length() > 0) {
                HtmlUtil.addData(stringBuffer, "Full Name:  ", string4.trim());
            }
            if ((string3 = interactor.getDescription()) != null && string3.length() > 0) {
                HtmlUtil.addData(stringBuffer, "Description:  ", string3.trim());
            }
            if ((string2 = (String)interactor.getAttribute("ORGANISM_SPECIES")) != null && string2.length() > 0) {
                HtmlUtil.addData(stringBuffer, "Species:  ", string2.trim());
            }
            ExternalReference[] externalReferenceArray = interactor.getExternalRefs();
            this.outputExternalRefs(externalReferenceArray, stringBuffer);
            this.outputExpressionData(stringBuffer, string, externalReferenceArray);
            this.outputAdditionalAttributes(stringBuffer, string);
            HtmlUtil.endTable(stringBuffer);
            this.htmlPane.setText(stringBuffer.toString());
        } else {
            this.htmlPane.setText("<FONT FACE=ARIAL>cPath Data is not available for the selected node.</FONT>");
        }
        this.htmlPane.setCaretPosition(0);
    }

    private void outputExternalRefs(ExternalReference[] externalReferenceArray, StringBuffer stringBuffer) {
        if (externalReferenceArray != null && externalReferenceArray.length > 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < externalReferenceArray.length; ++i) {
                String string = externalReferenceArray[i].getDatabase();
                String string2 = externalReferenceArray[i].getId();
                stringBuffer2.append("- " + string + ":  " + string2 + "<BR>");
            }
            HtmlUtil.addData(stringBuffer, "External References:", stringBuffer2.toString());
        }
    }

    private void outputExpressionData(StringBuffer stringBuffer, String string, ExternalReference[] externalReferenceArray) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<TABLE WIDTH=100% CELLSPACING=2 CELLPADDING=2 BORDER=1>");
        stringBuffer2.append("<TR BGCOLOR='#FFFFCC'>");
        HtmlUtil.addTD(stringBuffer2, "ID");
        HtmlUtil.addTD(stringBuffer2, "Condition");
        HtmlUtil.addTD(stringBuffer2, "Ratio");
        stringBuffer2.append("</TR>");
        ExpressionData expressionData = Cytoscape.getExpressionData();
        int n = 0;
        if (expressionData != null) {
            n += this.extractMeasurement(expressionData, string, stringBuffer2);
            if (externalReferenceArray != null) {
                for (int i = 0; i < externalReferenceArray.length; ++i) {
                    ExternalReference externalReference = externalReferenceArray[i];
                    if (!externalReference.getDatabase().equalsIgnoreCase("Affymetrix")) continue;
                    n += this.extractMeasurement(expressionData, externalReference.getId(), stringBuffer2);
                }
            }
        }
        if (n == 0) {
            stringBuffer2.append("<TR><TD COLSPAN=3><FONT FACE=ARIAL>No expression data associated with this node.</FONT></TD></TR>");
        }
        HtmlUtil.endTable(stringBuffer2);
        HtmlUtil.addData(stringBuffer, "Expression data associated with this node:", stringBuffer2.toString());
    }

    private int extractMeasurement(ExpressionData expressionData, String string, StringBuffer stringBuffer) {
        int n = 0;
        Vector vector = expressionData.getMeasurements(string);
        if (vector != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
            String[] stringArray = expressionData.getConditionNames();
            for (int i = 0; i < stringArray.length; ++i) {
                mRNAMeasurement mRNAMeasurement2 = expressionData.getMeasurement(string, stringArray[i]);
                if (mRNAMeasurement2 == null) continue;
                stringBuffer.append("<TR>");
                HtmlUtil.addTD(stringBuffer, string);
                HtmlUtil.addTD(stringBuffer, stringArray[i]);
                HtmlUtil.addTD(stringBuffer, decimalFormat.format(mRNAMeasurement2.getRatio()));
                stringBuffer.append("</TR>");
                ++n;
            }
        }
        return n;
    }

    private void outputAdditionalAttributes(StringBuffer stringBuffer, String string) {
        Set set;
        HashMap hashMap;
        StringBuffer stringBuffer2 = new StringBuffer();
        GraphObjAttributes graphObjAttributes = Cytoscape.getCurrentNetwork().getNodeAttributes();
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###.###");
        if (graphObjAttributes != null && (hashMap = graphObjAttributes.getAttributes(string)) != null && (set = hashMap.keySet()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = hashMap.get(k);
                if (!(v instanceof Number)) continue;
                stringBuffer2.append("- " + k + ": " + decimalFormat.format(v));
            }
        }
        if (stringBuffer2.length() == 0) {
            stringBuffer2.append("None");
        }
        HtmlUtil.addData(stringBuffer, "Additional attributes associated with this node:", stringBuffer2.toString());
    }

    private void updateInteraction() {
        Interaction interaction = this.userSelection.getSelectedInteraction();
        this.border = new TitledBorder("Edge Details");
        this.setBorder(this.border);
        if (interaction != null) {
            Object object;
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            HtmlUtil.startTable(stringBuffer);
            String string2 = (String)interaction.getAttribute("INTERACTION_SHORT_NAME");
            if (string2 != null) {
                HtmlUtil.addData(stringBuffer, "Interaction Short Name", string2);
            }
            if ((string = (String)interaction.getAttribute("INTERACTION_FULL_NAME")) != null) {
                HtmlUtil.addData(stringBuffer, "Interaction Full Name", string);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            ArrayList arrayList = interaction.getInteractors();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (Interactor)arrayList.get(i);
                stringBuffer2.append("- " + ((Interactor)object).getName());
                if (i >= arrayList.size() - 1) continue;
                stringBuffer2.append("<BR>");
            }
            HtmlUtil.addData(stringBuffer, "Interactors", stringBuffer2.toString());
            String string3 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
            object = (String)interaction.getAttribute("PUB_MED_ID");
            if (string3 != null && string3.length() > 0) {
                HtmlUtil.addData(stringBuffer, "Experimental Evidence", string3);
                if (object != null && ((String)object).length() > 0) {
                    HtmlUtil.addData(stringBuffer, "PMID", (String)object);
                }
            }
            this.outputExternalRefs(interaction.getExternalRefs(), stringBuffer);
            HtmlUtil.endTable(stringBuffer);
            this.htmlPane.setText(stringBuffer.toString());
        } else {
            this.htmlPane.setText("<FONT FACE=ARIAL>cPath Data is not available for the selected node.</FONT>");
        }
        this.htmlPane.setCaretPosition(0);
    }
}

