/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.action;

import csplugins.dataviewer.ui.ErrorDisplay;
import csplugins.dataviewer.util.SimpleFileFilter;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeObj;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class BaseAction
extends AbstractAction {
    private CytoscapeDesktop desktop = Cytoscape.getDesktop();
    private static final String HTTP_PREFIX = "http://";

    public abstract void actionPerformed(ActionEvent var1);

    protected BaseAction() {
    }

    protected URL createURL(String string) {
        URL uRL = null;
        if (string.trim().length() == 0) {
            this.showError("You did not enter a valid URL.  Please try again.");
            return null;
        }
        if (!string.matches(".*://.*")) {
            string = new String(HTTP_PREFIX + string);
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.showError("Sorry, the URL you entered is invalid. Please check your spelling and try again.");
        }
        return uRL;
    }

    protected String getFile(String[] stringArray, String string) {
        int n;
        String string2 = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new SimpleFileFilter(stringArray, string));
        CytoscapeObj cytoscapeObj = Cytoscape.getCytoscapeObj();
        File file = cytoscapeObj.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if ((n = jFileChooser.showOpenDialog((Component)this.desktop)) == 0) {
            file = jFileChooser.getSelectedFile();
            string2 = file.getAbsolutePath();
        } else {
            file = jFileChooser.getCurrentDirectory();
        }
        cytoscapeObj.setCurrentDirectory(file);
        return string2;
    }

    protected URL getURL(String string) {
        String string2 = JOptionPane.showInputDialog((Component)this.desktop, (Object)string);
        if (string2 != null) {
            URL uRL = this.createURL(string2);
            if (uRL != null) {
                if (uRL.getProtocol().equalsIgnoreCase("http") || uRL.getProtocol().equalsIgnoreCase("ftp") || uRL.getProtocol().equalsIgnoreCase("file")) {
                    return uRL;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    protected final void showError(Exception exception) {
        ErrorDisplay errorDisplay = new ErrorDisplay((Frame)this.desktop);
        errorDisplay.displayError(exception);
    }

    protected final void showError(String string) {
        ErrorDisplay errorDisplay = new ErrorDisplay((Frame)this.desktop);
        errorDisplay.displayError(string);
    }
}

