package org.baderlab.brain;

import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.seq.ProteinTools;

import java.awt.*;
import java.util.ArrayList;

/**
 * Paints colors for the sequence logo according to the Hydroxyl-Basic-Acdic-Polar-Hydropobic classification
 * Symbol groups: ST (hydroxyl?) , KRH (basic), DEQN (acidic-polar?), FLAMPWIVCY (hydrophobic), G (?)
 *
 * ST           hydroxyl polar group                    magenta
 * KRH          basic                                   blue
 * DEQN         polar-acidic (DE more acidic than QN)   red
 * G            nonhydrophobic-nonpolar                 gray
 * FLAMPWIVCY   hydrophobic                             black
 *
 */
public class HydroxylProteinLogoStyle implements SymbolStyle {
    private ArrayList<Color> colorList;

    public HydroxylProteinLogoStyle() {
        AminoAcidGrouping aaGroup = new AminoAcidGrouping();
        aaGroup.setColoring(AminoAcidGrouping.COLORING_HYDROXYL);
        this.colorList = aaGroup.getColorList();
    }

    public HydroxylProteinLogoStyle(ArrayList<Color> colorList) {
        this.colorList = colorList;
    }

    public Paint outlinePaint(Symbol s) throws IllegalSymbolException {
        return fillPaint(s);
    }

    public Paint fillPaint(Symbol s) throws IllegalSymbolException {
        Paint fillColor = null;

        //ST
        if (s.equals(ProteinTools.s()) || s.equals(ProteinTools.t())) {
            fillColor = colorList.get(0);

        //KRH
        } else if (s.equals(ProteinTools.k()) || s.equals(ProteinTools.r())
                || s.equals(ProteinTools.d())) {
            fillColor = colorList.get(1);

        //DEQN
        } else if (s.equals(ProteinTools.d()) || s.equals(ProteinTools.e())
                || s.equals(ProteinTools.q()) || s.equals(ProteinTools.n()) ) {
            fillColor = colorList.get(2);

            //ST
        } else if (s.equals(ProteinTools.g())) {
                fillColor = colorList.get(3);

        //FLAMPWIVCY
        } else {
            fillColor = colorList.get(4);
        }

        return fillColor;
    }
}
