/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.importing;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ut.biolab.medsavant.shared.importing.FileFormat;

public class ImportDelimitedFile {
    public static CSVReader getFileReader(String path, char separator) throws FileNotFoundException {
        CSVReader reader = new CSVReader((Reader)new FileReader(path), separator);
        return reader;
    }

    public static Iterator<String[]> getFileIterator(String path, char separator, int headerLines, final FileFormat ff) throws FileNotFoundException, IOException {
        final CSVReader reader = ImportDelimitedFile.getFileReader(path, separator);
        for (int i = 0; i < headerLines; ++i) {
            reader.readNext();
        }
        final int[] fields = ff.getRequiredFieldIndexes();
        Iterator<String[]> i = new Iterator<String[]>(){
            private String[] nextLine;

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (this.nextLine == null) {
                    try {
                        this.nextLine = ff == null ? reader.readNext() : ImportDelimitedFile.getOnlyRequiredFields(reader.readNext(), fields);
                        return true;
                    }
                    catch (Exception ex) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex1) {
                            // empty catch block
                        }
                        return false;
                    }
                }
                boolean bl = hasNext = this.nextLine == null;
                if (!hasNext) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return hasNext;
            }

            @Override
            public String[] next() {
                if (this.nextLine != null) {
                    String[] result = this.nextLine;
                    this.nextLine = null;
                    return result;
                }
                try {
                    if (ff == null) {
                        return reader.readNext();
                    }
                    return ImportDelimitedFile.getOnlyRequiredFields(reader.readNext(), fields);
                }
                catch (IOException ex) {
                    return null;
                }
            }

            @Override
            public void remove() {
                try {
                    reader.readNext();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        return i;
    }

    public static List<String[]>[] getPreview(String path, char separator, int numHeaderLines, int numLines, FileFormat ff) throws FileNotFoundException {
        int[] fields = ff != null ? ff.getRequiredFieldIndexes() : null;
        CSVReader reader = ImportDelimitedFile.getFileReader(path, separator);
        List<String[]> headerLines = ImportDelimitedFile.getLinesFromReader(reader, numHeaderLines);
        List<String[]> previewLines = null;
        previewLines = ImportDelimitedFile.getLinesFromReader(reader, numLines, fields);
        return new List[]{headerLines, previewLines};
    }

    private static List<String[]> getLinesFromReader(CSVReader reader, int numLines) {
        return ImportDelimitedFile.getLinesFromReader(reader, numLines, null);
    }

    private static List<String[]> getLinesFromReader(CSVReader reader, int numLines, int[] fields) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (int i = 0; i < numLines; ++i) {
            try {
                String[] line = reader.readNext();
                if (line == null) break;
                if (fields == null) {
                    lines.add(line);
                    continue;
                }
                lines.add(ImportDelimitedFile.getOnlyRequiredFields(line, fields));
                continue;
            }
            catch (IOException ex) {
                System.err.println("Warning: hit end of file while getting lines from file");
                break;
            }
        }
        return lines;
    }

    private static String[] getOnlyRequiredFields(String[] line, int[] fields) {
        String[] result = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = line[fields[i]];
        }
        return result;
    }
}

