/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class DbObject<ParentType extends DbObject>
implements Serializable {
    private final ParentType _parent;
    private final String _name;

    protected DbObject(ParentType parent, String name) {
        this._parent = parent;
        this._name = name;
    }

    public DbSpec getSpec() {
        return ((DbObject)this.getParent()).getSpec();
    }

    protected ParentType getParent() {
        return this._parent;
    }

    public String getName() {
        return this._name;
    }

    public String getAbsoluteName() {
        String prefix;
        String absoluteName = this.getName();
        String string = prefix = this.getParent() != null ? ((DbObject)this.getParent()).getAbsoluteName() : null;
        if (absoluteName == null) {
            absoluteName = prefix;
        } else if (prefix != null) {
            absoluteName = prefix + "." + absoluteName;
        }
        return absoluteName;
    }

    protected <T extends DbObject<?>> T checkOwnership(T obj) {
        if (obj.getParent() != this) {
            throw new IllegalArgumentException("Given " + obj.getClass().getSimpleName() + " is not owned by this " + this.getClass().getSimpleName());
        }
        return obj;
    }

    protected <T extends DbObject<?>> T[] checkOwnership(T ... objs) {
        for (T obj : objs) {
            this.checkOwnership(obj);
        }
        return objs;
    }

    protected static <T extends DbObject<?>> T findObject(Collection<T> objects, String name) {
        for (DbObject obj : objects) {
            if (name != obj.getName() && (name == null || !name.equals(obj.getName()))) continue;
            return (T)obj;
        }
        return null;
    }

    protected static <T extends DbObject<?>> void addObjects(Collection<T> objs, DbObject<?> parent, T ... objArr) {
        if (objArr != null) {
            objs.addAll(Arrays.asList(parent.checkOwnership((T)objArr)));
        }
    }

    public String toString() {
        return this.getAbsoluteName();
    }
}

