/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.ForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.List;

public class DbForeignKeyConstraint
extends DbConstraint
implements ForeignKeyConstraint {
    private final DbTable _referencedTable;
    private final List<DbColumn> _referencedColumns = new ArrayList<DbColumn>();

    public DbForeignKeyConstraint(DbColumn parent, String name, DbTable referencedTable, String refColName) {
        super(parent, name, Constraint.Type.FOREIGN_KEY);
        this._referencedTable = referencedTable;
        DbForeignKeyConstraint.addObjects(this._referencedColumns, (DbObject)this._referencedTable, (DbObject[])new DbColumn[]{this._referencedTable.findColumn(refColName)});
    }

    public DbForeignKeyConstraint(DbTable parent, String name, DbTable referencedTable, String[] colNames, String[] refColNames) {
        this(parent, name, referencedTable, parent.findColumns(colNames), referencedTable.findColumns(refColNames));
    }

    public DbForeignKeyConstraint(DbTable parent, String name, DbTable referencedTable, DbColumn[] columns, DbColumn[] refColumns) {
        super(parent, name, Constraint.Type.FOREIGN_KEY, columns);
        this._referencedTable = referencedTable;
        DbForeignKeyConstraint.addObjects(this._referencedColumns, (DbObject)this._referencedTable, (DbObject[])refColumns);
    }

    @Override
    public DbTable getReferencedTable() {
        return this._referencedTable;
    }

    public List<DbColumn> getReferencedColumns() {
        return this._referencedColumns;
    }
}

