/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder.dbspec.basic;

import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbForeignKeyConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbObject;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbColumn
extends DbObject<DbTable>
implements Column,
Serializable {
    private static final Map<Integer, String> _typeNameMap = new HashMap<Integer, String>();
    private final String _typeName;
    private final Integer _typeLength;
    private final Integer _typeScale;
    private final List<DbConstraint> _constraints = new ArrayList<DbConstraint>();
    private Object _defaultValue;

    public DbColumn(DbTable parent, String name, String typeName, Integer typeLength, Integer typeScale) {
        super(parent, name);
        this._typeName = typeName;
        this._typeLength = typeLength;
        this._typeScale = typeScale;
    }

    @Override
    public DbTable getTable() {
        return (DbTable)this.getParent();
    }

    @Override
    public String getColumnNameSQL() {
        return this.getName();
    }

    @Override
    public String getTypeNameSQL() {
        return this._typeName;
    }

    @Override
    public Integer getTypeLength() {
        return this._typeLength;
    }

    @Override
    public Integer getTypeScale() {
        return this._typeScale;
    }

    public List<DbConstraint> getConstraints() {
        return this._constraints;
    }

    public DbColumn setDefaultValue(Object defaultValue) {
        this._defaultValue = defaultValue;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public DbConstraint notNull() {
        return this.notNull(null);
    }

    public DbConstraint notNull(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.NOT_NULL);
        return this.addConstraint(constraint);
    }

    public DbConstraint unique() {
        return this.unique(null);
    }

    public DbConstraint unique(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.UNIQUE);
        return this.addConstraint(constraint);
    }

    public DbConstraint primaryKey() {
        return this.primaryKey(null);
    }

    public DbConstraint primaryKey(String name) {
        DbConstraint constraint = this.getSpec().createColumnConstraint(this, name, Constraint.Type.PRIMARY_KEY);
        return this.addConstraint(constraint);
    }

    public DbForeignKeyConstraint references(String referencedTableName) {
        return this.references(null, referencedTableName);
    }

    public DbForeignKeyConstraint references(String name, String referencedTableName) {
        return this.references(name, referencedTableName, null);
    }

    public DbForeignKeyConstraint references(String name, String referencedTableName, String referencedColName) {
        DbTable table = ((DbSchema)this.getTable().getParent()).findTable(referencedTableName);
        DbForeignKeyConstraint fkConstraint = this.getSpec().createColumnForeignKeyConstraint(this, name, table, referencedColName);
        return this.addConstraint(fkConstraint);
    }

    public <T extends DbConstraint> T addConstraint(T constraint) {
        this._constraints.add(this.checkOwnership(constraint));
        return constraint;
    }

    public static String getTypeName(int type) {
        String name = _typeNameMap.get(type);
        if (name == null) {
            throw new IllegalArgumentException("Type " + type + " is not a valid sql type");
        }
        return name;
    }

    static {
        try {
            for (Field typeField : Types.class.getFields()) {
                int mods = typeField.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || typeField.getType() != Integer.TYPE) continue;
                Integer val = (Integer)typeField.get(null);
                _typeNameMap.put(val, typeField.getName());
            }
        }
        catch (Exception e) {
            throw new Error("<clinit> cannot access jdbc type constants", e);
        }
    }
}

