/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class UnaryCondition
extends Condition {
    private CustomUnaryOp _unaryOp;
    private SqlObject _value;

    public UnaryCondition(Op unaryOp, SqlObject obj) {
        this(unaryOp, (Object)obj);
    }

    public UnaryCondition(Op unaryOp, Object value) {
        this((CustomUnaryOp)unaryOp, value);
    }

    public UnaryCondition(CustomUnaryOp unaryOp, Object value) {
        this._unaryOp = unaryOp;
        this._value = this._unaryOp.getConverter().convert(value);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._value.collectSchemaObjects(vContext);
    }

    public void appendTo(AppendableExt app) throws IOException {
        this.openParen(app);
        if (this._unaryOp.isPrefixOp()) {
            app.append((Object)this._unaryOp).append((Appendee)this._value);
        } else {
            app.append((Appendee)this._value).append((Object)this._unaryOp);
        }
        this.closeParen(app);
    }

    public static UnaryCondition isNull(Object value) {
        return new UnaryCondition(Op.IS_NULL, value);
    }

    public static UnaryCondition isNotNull(Object value) {
        return new UnaryCondition(Op.IS_NOT_NULL, value);
    }

    public static UnaryCondition exists(Object query) {
        return new UnaryCondition(Op.EXISTS, query);
    }

    public static UnaryCondition unique(Object query) {
        return new UnaryCondition(Op.UNIQUE, query);
    }

    public static enum Op implements CustomUnaryOp
    {
        IS_NULL(" IS NULL", false, Converter.COLUMN_VALUE_TO_OBJ),
        IS_NOT_NULL(" IS NOT NULL", false, Converter.COLUMN_VALUE_TO_OBJ),
        EXISTS("EXISTS ", true, Converter.CUSTOM_TO_SUBQUERY),
        UNIQUE("UNIQUE ", true, Converter.CUSTOM_TO_SUBQUERY);

        private final String _opStr;
        private final boolean _isPrefixOp;
        private final Converter<Object, ? extends SqlObject> _converter;

        private Op(String opStr, boolean isPrefixOp, Converter<Object, ? extends SqlObject> converter) {
            this._opStr = opStr;
            this._isPrefixOp = isPrefixOp;
            this._converter = converter;
        }

        @Override
        public boolean isPrefixOp() {
            return this._isPrefixOp;
        }

        @Override
        public Converter<Object, ? extends SqlObject> getConverter() {
            return this._converter;
        }

        public String toString() {
            return this._opStr;
        }
    }

    public static interface CustomUnaryOp {
        public boolean isPrefixOp();

        public Converter<Object, ? extends SqlObject> getConverter();
    }
}

