/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Index;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class DropQuery
extends Query<DropQuery> {
    private Type _type;
    private SqlObject _obj;
    private Behavior _behavior;

    public DropQuery(Type type, Object obj) {
        this._type = type;
        this._obj = Converter.toCustomSqlObject(obj);
    }

    public DropQuery setBehavior(Behavior newBehavior) {
        this._behavior = newBehavior;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._obj.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append((CharSequence)"DROP").append((Object)this._type).append((Appendee)this._obj);
        if (this._behavior != null) {
            app.append((Object)this._behavior);
        }
    }

    public static DropQuery dropTable(Table table) {
        return DropQuery.dropTable((Object)table);
    }

    public static DropQuery dropTable(Object tableStr) {
        return new DropQuery(Type.TABLE, Converter.toCustomTableSqlObject(tableStr));
    }

    public static DropQuery dropIndex(Index index) {
        return DropQuery.dropIndex((Object)index);
    }

    public static DropQuery dropIndex(Object indexStr) {
        return new DropQuery(Type.INDEX, Converter.toCustomIndexSqlObject(indexStr));
    }

    public static DropQuery dropView(Table table) {
        return DropQuery.dropView((Object)table);
    }

    public static DropQuery dropView(Object tableStr) {
        return new DropQuery(Type.VIEW, Converter.toCustomTableSqlObject(tableStr));
    }

    public static enum Behavior {
        CASCADE(" CASCADE"),
        RESTRICT(" RESTRICT");

        private final String _bvrStr;

        private Behavior(String bvrStr) {
            this._bvrStr = bvrStr;
        }

        public String toString() {
            return this._bvrStr;
        }
    }

    public static enum Type {
        TABLE(" TABLE "),
        INDEX(" INDEX "),
        VIEW(" VIEW ");

        private final String _typeStr;

        private Type(String typeStr) {
            this._typeStr = typeStr;
        }

        public String toString() {
            return this._typeStr;
        }
    }
}

