/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.TypedColumnObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;
import java.util.ListIterator;

public class CreateTableQuery
extends BaseCreateQuery<CreateTableQuery> {
    protected SqlObjectList<SqlObject> _constraints = SqlObjectList.create();

    public CreateTableQuery(Table table) {
        this(table, false);
    }

    public CreateTableQuery(Table table, boolean includeColumns) {
        this((Object)table);
        if (includeColumns) {
            this._columns.addObjects(Converter.TYPED_COLUMN_TO_OBJ, table.getColumns());
            this._constraints.addObjects(Converter.CUSTOM_TO_CONSTRAINTCLAUSE, table.getConstraints());
        }
    }

    public CreateTableQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.TABLE, this._object);
    }

    @Override
    public CreateTableQuery addCustomColumns(Object ... typedColumnStrs) {
        this._columns.addObjects(Converter.TYPED_COLUMN_TO_OBJ, typedColumnStrs);
        return this;
    }

    @Deprecated
    public CreateTableQuery addColumn(Column column, ColumnConstraint constraint) {
        return this.addCustomColumn(column, constraint);
    }

    @Deprecated
    public CreateTableQuery addCustomColumn(Object columnStr, ColumnConstraint constraint) {
        SqlObject column = Converter.TYPED_COLUMN_TO_OBJ.convert(columnStr);
        if (column instanceof TypedColumnObject) {
            ((TypedColumnObject)column).addConstraint((Object)constraint);
        } else {
            column = new ConstrainedColumn(column, (Object)constraint);
        }
        this._columns.addObject(column);
        return this;
    }

    @Deprecated
    public CreateTableQuery setColumnConstraint(Column column, ColumnConstraint constraint) {
        return this.addColumnConstraint(column, (Object)constraint);
    }

    public CreateTableQuery addColumnConstraint(Column column, Object constraint) {
        ListIterator iter = this._columns.listIterator();
        while (iter.hasNext()) {
            SqlObject tmpCol = (SqlObject)iter.next();
            if (!(tmpCol instanceof TypedColumnObject) || ((TypedColumnObject)tmpCol)._column != column) continue;
            ((TypedColumnObject)tmpCol).addConstraint(constraint);
            break;
        }
        return this;
    }

    public CreateTableQuery setColumnDefaultValue(Column column, Object defaultValue) {
        ListIterator iter = this._columns.listIterator();
        while (iter.hasNext()) {
            SqlObject tmpCol = (SqlObject)iter.next();
            if (!(tmpCol instanceof TypedColumnObject) || ((TypedColumnObject)tmpCol)._column != column) continue;
            ((TypedColumnObject)tmpCol).setDefaultValue(defaultValue);
            break;
        }
        return this;
    }

    public CreateTableQuery addConstraints(Constraint ... constraints) {
        return this.addCustomConstraints(constraints);
    }

    public CreateTableQuery addCustomConstraints(Object ... constraintStrs) {
        this._constraints.addObjects(Converter.CUSTOM_TO_CONSTRAINTCLAUSE, constraintStrs);
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._constraints.collectSchemaObjects(vContext);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._columns.isEmpty()) {
            throw new ValidationException("Table has no columns");
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append((CharSequence)"CREATE TABLE ").append((Appendee)this._object).append((CharSequence)" (").append((Appendee)this._columns);
        if (!this._constraints.isEmpty()) {
            app.append((CharSequence)",").append(this._constraints);
        }
        app.append((CharSequence)")");
        this.appendTableSpace(app);
    }

    private static class ConstrainedColumn
    extends SqlObject {
        private SqlObject _column;
        private Object _constraint;

        private ConstrainedColumn(SqlObject column, Object constraint) {
            this._column = column;
            this._constraint = constraint;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._column.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append((Appendee)this._column).append((CharSequence)" ").append(this._constraint);
        }
    }

    @Deprecated
    public static enum ColumnConstraint {
        NOT_NULL("NOT NULL"),
        UNIQUE("UNIQUE"),
        PRIMARY_KEY("PRIMARY KEY");

        private final String _constraintClause;

        private ColumnConstraint(String constraintClause) {
            this._constraintClause = constraintClause;
        }

        public String toString() {
            return this._constraintClause;
        }
    }
}

