/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import java.io.IOException;

public abstract class BaseCreateQuery<ThisType extends BaseCreateQuery<ThisType>>
extends Query<ThisType> {
    protected SqlObject _object;
    protected SqlObjectList<SqlObject> _columns = SqlObjectList.create();
    private String _tableSpace;

    protected BaseCreateQuery(SqlObject objectStr) {
        this._object = objectStr;
    }

    public ThisType setName(String name) {
        return this.setCustomName(name);
    }

    public ThisType setCustomName(Object name) {
        this._object = Converter.toCustomSqlObject(name);
        return (ThisType)((BaseCreateQuery)this.getThisType());
    }

    public ThisType addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    public ThisType setTableSpace(String tableSpace) {
        this._tableSpace = tableSpace;
        return (ThisType)((BaseCreateQuery)this.getThisType());
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._object.collectSchemaObjects(vContext);
        this._columns.collectSchemaObjects(vContext);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (SelectQuery.hasAllColumns(this._columns)) {
            throw new ValidationException("Cannot use the '*' syntax in this query");
        }
    }

    protected void appendTableSpace(AppendableExt app) throws IOException {
        if (this._tableSpace != null) {
            app.append((CharSequence)(" TABLESPACE " + this._tableSpace));
        }
    }

    public abstract ThisType addCustomColumns(Object ... var1);

    public abstract DropQuery getDropQuery();
}

