/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.UserComment;

public class UserCommentGroup
implements Serializable {
    private final int projectId;
    private final int referenceId;
    private final String chrom;
    private final long startPosition;
    private final long endPosition;
    private final String ref;
    private final String alt;
    private final int userCommentGroupId;
    private final Set<OntologyTerm> ontologyTermsCovered;
    private List<UserComment> comments;

    public UserCommentGroup(int groupId, int projectId, int referenceId, String chrom, long startPosition, long endPosition, String ref, String alt, Date modification, List<UserComment> comments) {
        this.userCommentGroupId = groupId;
        this.projectId = projectId;
        this.referenceId = referenceId;
        this.chrom = chrom;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.ref = ref;
        this.alt = alt;
        this.ontologyTermsCovered = new HashSet<OntologyTerm>();
        if (comments != null) {
            for (UserComment lc : comments) {
                this.ontologyTermsCovered.add(lc.getOntologyTerm());
            }
            this.comments = comments;
        } else {
            this.comments = new ArrayList<UserComment>(0);
        }
    }

    public Set<OntologyTerm> getOntologyTermsCovered() {
        return this.ontologyTermsCovered;
    }

    public int getUserCommentGroupId() {
        return this.userCommentGroupId;
    }

    public int getNumComments() {
        return this.comments.size();
    }

    public Iterator<UserComment> iterator() {
        return new Iterator<UserComment>(){
            private final Iterator<UserComment> it;
            {
                this.it = UserCommentGroup.this.comments.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public UserComment next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported");
            }
        };
    }
}

