/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Gene
implements Serializable,
Comparable<Gene> {
    private final String name;
    private final String chrom;
    private final int start;
    private final int end;
    private final int codingStart;
    private final int codingEnd;
    private final String transcript;

    public Gene(String name, String chrom, int start, int end, int codingStart, int codingEnd, String transcript) {
        this.name = name;
        this.chrom = chrom;
        this.start = start;
        this.end = end;
        this.codingStart = codingStart;
        this.codingEnd = codingEnd;
        this.transcript = transcript;
    }

    public Gene(String name, String chrom, int start, int end) {
        this(name, chrom, start, end, -1, -1, null);
    }

    public String getName() {
        return this.name;
    }

    public String getChrom() {
        return this.chrom;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getCodingStart() {
        return this.codingStart;
    }

    public int getCodingEnd() {
        return this.codingEnd;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public String getDescription() throws MalformedURLException, IOException {
        String baseURLp1 = "http://www.genenames.org/cgi-bin/quick_search.pl?.cgifields=type&type=equal&num=50&search=";
        String baseURLp2 = "&submit=Submit";
        URL url = new URL(baseURLp1 + this.name + baseURLp2);
        Document doc = Jsoup.parse((URL)url, (int)20000);
        Elements tableClass = doc.select("table.quick_search");
        Element e = tableClass.select("tr:has(td)").first();
        String description = e.select("td:has(a) + td").text();
        return description;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Gene t) {
        int result = this.name.compareTo(t.name);
        if (result == 0 && (result = this.chrom.compareTo(t.chrom)) == 0 && (result = this.start - t.start) == 0 && (result = this.end - t.end) == 0 && this.transcript != null) {
            result = this.transcript.compareTo(t.transcript);
        }
        return result;
    }

    public boolean equals(Object that) {
        if (that instanceof Gene) {
            return this.compareTo((Gene)that) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 11 * hash + (this.chrom != null ? this.chrom.hashCode() : 0);
        hash = 11 * hash + this.start;
        hash = 11 * hash + this.end;
        hash = 11 * hash + (this.transcript != null ? this.transcript.hashCode() : 0);
        return hash;
    }
}

