/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.NetworkManager;
import org.ut.biolab.medsavant.shared.importing.FileFormat;
import org.ut.biolab.medsavant.shared.importing.ImportDelimitedFile;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.RegionSet;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.RegionSetManagerAdapter;

public class RegionSetManager
extends MedSavantServerUnicastRemoteObject
implements RegionSetManagerAdapter,
MedSavantDatabase.RegionSetMembershipColumns {
    private static final Log LOG = LogFactory.getLog(RegionSetManager.class);
    private static RegionSetManager instance;

    private RegionSetManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized RegionSetManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new RegionSetManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegionSet(String sessID, String regionSetName, int genomeID, char delim, FileFormat fileFormat, int numHeaderLines, int fileID) throws IOException, SQLException, RemoteException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.setAutoCommit(false);
            InsertQuery query = MedSavantDatabase.RegionSetTableSchema.preparedInsert(MedSavantDatabase.RegionSetColumns.NAME);
            PreparedStatement prep = conn.prepareStatement(query.toString(), 1);
            prep.setString(1, regionSetName);
            prep.executeUpdate();
            ResultSet rs = prep.getGeneratedKeys();
            rs.next();
            int regionSetID = rs.getInt(1);
            File f = NetworkManager.getInstance().getFileByTransferID(sessID, fileID);
            Iterator<String[]> i = ImportDelimitedFile.getFileIterator(f.getAbsolutePath(), delim, numHeaderLines, fileFormat);
            query = MedSavantDatabase.RegionSetMembershipTableSchema.preparedInsert(GENOME_ID, REGION_SET_ID, CHROM, START, END, DESCRIPTION);
            prep = conn.prepareStatement(query.toString());
            while (i.hasNext() && !Thread.currentThread().isInterrupted()) {
                Object[] line = i.next();
                LOG.info((Object)StringUtils.join((Object[])line, (char)'\t'));
                prep.setInt(1, genomeID);
                prep.setInt(2, regionSetID);
                prep.setString(3, (String)line[0]);
                prep.setString(4, (String)line[1]);
                prep.setString(5, (String)line[2]);
                prep.setString(6, (String)line[3]);
                prep.executeUpdate();
            }
            if (Thread.currentThread().isInterrupted()) {
                conn.rollback();
            } else {
                conn.commit();
            }
            conn.setAutoCommit(true);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegionSet(String sessID, int regionSetID) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.createStatement().executeUpdate(MedSavantDatabase.RegionSetMembershipTableSchema.delete(REGION_SET_ID, regionSetID).toString());
            conn.createStatement().executeUpdate(MedSavantDatabase.RegionSetTableSchema.delete(MedSavantDatabase.RegionSetColumns.REGION_SET_ID, regionSetID).toString());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RegionSet> getRegionSets(String sessID) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            SelectQuery query = MedSavantDatabase.RegionSetMembershipTableSchema.groupBy(REGION_SET_ID).leftJoin(MedSavantDatabase.RegionSetTableSchema, "region_set_id").select(REGION_SET_ID, "NAME", "COUNT(*)");
            LOG.info((Object)("getRegionSets: " + query));
            ResultSet rs = conn.createStatement().executeQuery(query.toString());
            ArrayList<RegionSet> result = new ArrayList<RegionSet>();
            while (rs.next()) {
                result.add(new RegionSet(rs.getInt(1), rs.getString(2), rs.getInt(3)));
            }
            ArrayList<RegionSet> arrayList = result;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GenomicRegion> getRegionsInSet(String sessID, RegionSet set) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            SelectQuery query = MedSavantDatabase.RegionSetMembershipTableSchema.where(REGION_SET_ID, set.getID()).select(DESCRIPTION, CHROM, START, END);
            LOG.info((Object)("getRegionsInSet(" + set.getName() + "): " + query));
            ResultSet rs = conn.createStatement().executeQuery(query.toString());
            ArrayList<GenomicRegion> result = new ArrayList<GenomicRegion>();
            while (rs.next()) {
                result.add(new GenomicRegion(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getInt(4)));
            }
            ArrayList<GenomicRegion> arrayList = result;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GenomicRegion> getRegionsInSets(String sessID, Collection<RegionSet> sets) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>(sets.size());
            int maxRegions = 0;
            for (RegionSet s : sets) {
                ids.add(s.getID());
                maxRegions += s.getSize();
            }
            SelectQuery query = MedSavantDatabase.RegionSetMembershipTableSchema.distinct().whereIn(REGION_SET_ID, ids).select(DESCRIPTION, CHROM, START, END);
            ResultSet rs = conn.executeQuery(query.toString());
            ArrayList<GenomicRegion> result = new ArrayList<GenomicRegion>();
            while (rs.next()) {
                result.add(new GenomicRegion(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getInt(4)));
            }
            ArrayList<GenomicRegion> arrayList = result;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRegionSet(String sessID, RegionSet set, int genomeID, String chrom, int start, int end, String desc) throws SQLException, RemoteException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            InsertQuery query = MedSavantDatabase.RegionSetMembershipTableSchema.insert(GENOME_ID, genomeID, REGION_SET_ID, set.getID(), CHROM, chrom, START, start, END, end, DESCRIPTION, desc);
            conn.executeUpdate(query.toString());
        }
        finally {
            conn.close();
        }
    }
}

