/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.NetworkManager;
import org.ut.biolab.medsavant.server.serverapi.ReferenceManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.AnnotationDownloadInformation;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.AnnotationManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.IOUtils;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AnnotationManager
extends MedSavantServerUnicastRemoteObject
implements AnnotationManagerAdapter,
MedSavantDatabase.AnnotationColumns {
    private static final Log LOG = LogFactory.getLog(AnnotationManager.class);
    private static AnnotationManager instance;
    private static final File localDirectory;

    private AnnotationManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized AnnotationManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new AnnotationManager();
        }
        return instance;
    }

    @Override
    public boolean installAnnotationForProject(String sessionID, int currentProjectID, int transferID) throws RemoteException, SessionExpiredException, SQLException {
        try {
            LOG.info((Object)"Installing annotation transferred from client");
            NetworkManager netMgr = NetworkManager.getInstance();
            File annotationFile = netMgr.getFileByTransferID(sessionID, transferID);
            File installPath = AnnotationManager.generateInstallationDirectory();
            LOG.info((Object)("Installing to " + installPath.getAbsolutePath()));
            File newPath = new File(installPath, "tmp.zip");
            LOG.info((Object)("Copy file to " + installPath.getAbsolutePath()));
            IOUtils.copyFile(annotationFile, newPath);
            LOG.info((Object)"Unzipping file");
            AnnotationManager.unpackAnnotationZip(newPath);
            LOG.info((Object)"Touching done file");
            File doneFile = new File(installPath, "installed.touch");
            doneFile.createNewFile();
            return AnnotationManager.registerAnnotationWithProject(installPath, sessionID) >= 0;
        }
        catch (Exception ex) {
            LOG.error((Object)"Problem installing annotation", (Throwable)ex);
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean installAnnotationForProject(String sessID, int projectID, AnnotationDownloadInformation info) {
        return this.doInstallAnnotationForProject(sessID, projectID, info) >= 0;
    }

    public int doInstallAnnotationForProject(String sessID, int projectID, AnnotationDownloadInformation info) {
        try {
            int i = this.getInstalledAnnotationID(sessID, info);
            if (i < 0) {
                LOG.info((Object)("Installing annotation " + info));
                File installPath = AnnotationManager.generateInstallationDirectory();
                File doneFile = new File(installPath, "installed.touch");
                LOG.info((Object)("Checking for successful installation at " + installPath.getAbsolutePath()));
                if (!doneFile.exists()) {
                    File downloadPath = new File(installPath, "tmp.zip");
                    LOG.info((Object)"Downloading annotation, be patient...");
                    AnnotationManager.downloadAnnotation(info, downloadPath);
                    LOG.info((Object)"Registering annotation to project");
                    AnnotationManager.unpackAnnotationZip(downloadPath);
                    doneFile.createNewFile();
                } else {
                    LOG.info((Object)"Annotation files already on disk");
                }
                i = AnnotationManager.registerAnnotationWithProject(installPath, sessID);
                LOG.info((Object)"Done installing annotation");
            }
            return i;
        }
        catch (Exception ex) {
            LOG.error((Object)"Problem installing annotation", (Throwable)ex);
            return -1;
        }
    }

    public static void addAnnotationFormat(String sessID, int annotID, int pos, String colName, String colType, boolean filterable, String alias, String desc, Set<String> tags) throws SQLException, SessionExpiredException {
        LOG.debug((Object)("Adding annotation format for " + colName));
        colName = colName.replaceAll("[^A-Za-z0-9]", "");
        String tagStr = "";
        for (String tag : tags) {
            tagStr = "," + tag;
        }
        InsertQuery query = MedSavantDatabase.AnnotationFormatTableSchema.insert(ANNOTATION_ID, annotID, MedSavantDatabase.AnnotationFormatColumns.POSITION, pos, MedSavantDatabase.AnnotationFormatColumns.COLUMN_NAME, colName, MedSavantDatabase.AnnotationFormatColumns.COLUMN_TYPE, colType, MedSavantDatabase.AnnotationFormatColumns.FILTERABLE, filterable, MedSavantDatabase.AnnotationFormatColumns.ALIAS, alias, MedSavantDatabase.AnnotationFormatColumns.DESCRIPTION, desc, MedSavantDatabase.AnnotationFormatColumns.TAGS, tagStr.length() > 0 ? tagStr.substring(1) : "");
        PooledConnection c = ConnectionController.connectPooled(sessID);
        c.createStatement().executeUpdate(query.toString());
        c.close();
    }

    public static int addAnnotation(String sessID, String prog, String vers, int refID, String path, boolean hasRef, boolean hasAlt, int type, boolean endInclusive) throws SQLException, SessionExpiredException {
        LOG.debug((Object)"Adding annotation...");
        TableSchema table = MedSavantDatabase.AnnotationTableSchema;
        InsertQuery query = MedSavantDatabase.AnnotationTableSchema.insert(PROGRAM, prog, VERSION, vers, REFERENCE_ID, refID, PATH, path, HAS_REF, hasRef, HAS_ALT, hasAlt, TYPE, type, IS_END_INCLUSIVE, endInclusive);
        PooledConnection c = ConnectionController.connectPooled(sessID);
        PreparedStatement stmt = c.prepareStatement(query.toString(), 1);
        stmt.execute();
        ResultSet res = stmt.getGeneratedKeys();
        res.next();
        int annotid = res.getInt(1);
        c.close();
        return annotid;
    }

    private static AnnotationFormat parseFormat(File tabixFile, File xmlFormatFile) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(xmlFormatFile);
        doc.getDocumentElement().normalize();
        boolean hasRef = doc.getDocumentElement().getAttribute("hasref").equals("true");
        boolean hasAlt = doc.getDocumentElement().getAttribute("hasalt").equals("true");
        boolean isEndInclusive = !doc.getDocumentElement().getAttribute("isEndInclusive").isEmpty();
        String version = doc.getDocumentElement().getAttribute("version");
        String program = doc.getDocumentElement().getAttribute("program");
        String referenceName = doc.getDocumentElement().getAttribute("reference");
        AnnotationFormat.AnnotationType annotationType = AnnotationFormat.AnnotationType.fromString(doc.getDocumentElement().getAttribute("type"));
        NodeList fields = doc.getElementsByTagName("field");
        CustomField[] annotationFields = new CustomField[fields.getLength()];
        for (int i = 0; i < fields.getLength(); ++i) {
            Element field = (Element)fields.item(i);
            annotationFields[i] = new CustomField(field.getAttribute("name"), field.getAttribute("type"), field.getAttribute("filterable").equals("true"), field.getAttribute("alias"), field.getAttribute("description"), field.getAttribute("tags"), false);
        }
        return new AnnotationFormat(program, version, referenceName, tabixFile.getAbsolutePath(), hasRef, hasAlt, annotationType, isEndInclusive, annotationFields);
    }

    private static File unpackAnnotationZip(File zip) throws ZipException, IOException {
        IOUtils.unzipFile(zip, new File(zip.getAbsolutePath()).getParent());
        zip.delete();
        return new File(new File(zip.getAbsolutePath()).getParent());
    }

    @Override
    public Annotation getAnnotation(String sid, int annotation_id) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        TableSchema annTable = MedSavantDatabase.AnnotationTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(annTable.getTable());
        query.addAllColumns();
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, annTable.getTable(), refTable.getTable(), BinaryConditionMS.equalTo(annTable.getDBColumn(REFERENCE_ID), refTable.getDBColumn("reference_id")));
        query.addCondition(BinaryConditionMS.equalTo(annTable.getDBColumn(ANNOTATION_ID), annotation_id));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        Annotation result = new Annotation(rs.getInt(ANNOTATION_ID.getColumnName()), rs.getString(PROGRAM.getColumnName()), rs.getString(VERSION.getColumnName()), rs.getInt("reference_id"), rs.getString("name"), rs.getString(PATH.getColumnName()), AnnotationFormat.AnnotationType.fromInt(rs.getInt(TYPE.getColumnName())), rs.getBoolean(IS_END_INCLUSIVE.getColumnName()));
        return result;
    }

    @Override
    public Annotation[] getAnnotations(String sid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        TableSchema annTable = MedSavantDatabase.AnnotationTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(annTable.getTable());
        query.addAllColumns();
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, annTable.getTable(), refTable.getTable(), BinaryConditionMS.equalTo(annTable.getDBColumn(REFERENCE_ID), refTable.getDBColumn("reference_id")));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        while (rs.next()) {
            result.add(new Annotation(rs.getInt(ANNOTATION_ID.getColumnName()), rs.getString(PROGRAM.getColumnName()), rs.getString(VERSION.getColumnName()), rs.getInt("reference_id"), rs.getString("name"), rs.getString(PATH.getColumnName()), AnnotationFormat.AnnotationType.fromInt(rs.getInt(TYPE.getColumnName())), rs.getBoolean(IS_END_INCLUSIVE.getColumnName())));
        }
        return result.toArray(new Annotation[0]);
    }

    @Override
    public int[] getAnnotationIDs(String sessID, int projID, int refID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("annotation_ids"));
        query.addCondition(ComboCondition.and(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID), BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refID), BinaryConditionMS.equalTo(table.getDBColumn("published"), true)));
        query.addOrdering(table.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        String a = query.toString();
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        if (!rs.next()) {
            return new int[0];
        }
        String annotationString = rs.getString("annotation_ids");
        if (annotationString == null || annotationString.isEmpty()) {
            return new int[0];
        }
        String[] split = annotationString.split(",");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    @Override
    public AnnotationFormat[] getAnnotationFormats(String sessID, int projectID, int refID) throws SQLException, RemoteException, SessionExpiredException {
        int[] annotationIDs = this.getAnnotationIDs(sessID, projectID, refID);
        AnnotationFormat[] annotationFormats = new AnnotationFormat[annotationIDs.length];
        int i = 0;
        for (int annotationId : annotationIDs) {
            annotationFormats[i] = this.getAnnotationFormat(sessID, annotationId);
            ++i;
        }
        return annotationFormats;
    }

    @Override
    public AnnotationFormat getAnnotationFormat(String sessID, int annotID) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema annTable = MedSavantDatabase.AnnotationTableSchema;
        SelectQuery query1 = new SelectQuery();
        query1.addFromTable(annTable.getTable());
        query1.addAllColumns();
        query1.addCondition(BinaryConditionMS.equalTo(annTable.getDBColumn(ANNOTATION_ID), annotID));
        ResultSet rs1 = ConnectionController.executeQuery(sessID, query1.toString());
        rs1.next();
        String program = rs1.getString(PROGRAM.getColumnName());
        String version = rs1.getString(VERSION.getColumnName());
        String referenceName = ReferenceManager.getInstance().getReferenceName(sessID, rs1.getInt(REFERENCE_ID.getColumnName()));
        String path = rs1.getString(PATH.getColumnName());
        boolean hasRef = rs1.getBoolean(HAS_REF.getColumnName());
        boolean hasAlt = rs1.getBoolean(HAS_ALT.getColumnName());
        boolean isEndInclusive = rs1.getBoolean(IS_END_INCLUSIVE.getColumnName());
        AnnotationFormat.AnnotationType type = AnnotationFormat.AnnotationType.fromInt(rs1.getInt(TYPE.getColumnName()));
        TableSchema annFormatTable = MedSavantDatabase.AnnotationFormatTableSchema;
        SelectQuery query2 = new SelectQuery();
        query2.addFromTable(annFormatTable.getTable());
        query2.addAllColumns();
        query2.addCondition(BinaryConditionMS.equalTo(annFormatTable.getDBColumn(MedSavantDatabase.AnnotationFormatColumns.ANNOTATION_ID), annotID));
        query2.addOrdering(annFormatTable.getDBColumn(MedSavantDatabase.AnnotationFormatColumns.POSITION), OrderObject.Dir.ASCENDING);
        ResultSet rs2 = ConnectionController.executeQuery(sessID, query2.toString());
        ArrayList<CustomField> fields = new ArrayList<CustomField>();
        while (rs2.next()) {
            fields.add(new CustomField(rs2.getString(MedSavantDatabase.AnnotationFormatColumns.COLUMN_NAME.getColumnName()), rs2.getString(MedSavantDatabase.AnnotationFormatColumns.COLUMN_TYPE.getColumnName()), rs2.getBoolean(MedSavantDatabase.AnnotationFormatColumns.FILTERABLE.getColumnName()), rs2.getString(MedSavantDatabase.AnnotationFormatColumns.ALIAS.getColumnName()), rs2.getString(MedSavantDatabase.AnnotationFormatColumns.DESCRIPTION.getColumnName()), rs2.getString(MedSavantDatabase.AnnotationFormatColumns.TAGS.getColumnName()), false));
        }
        return new AnnotationFormat(program, version, referenceName, path, hasRef, hasAlt, type, isEndInclusive, fields.toArray(new CustomField[0]));
    }

    public static void printFile(File f) throws FileNotFoundException, IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        br.close();
    }

    public static void downloadAnnotation(AnnotationDownloadInformation adi, File location) throws MalformedURLException, IOException {
        URL u = new URL(adi.getURL());
        File targetDir = location.getParentFile();
        targetDir.mkdirs();
        String targetFilename = location.getName();
        LOG.debug((Object)("Downloading " + u.toString() + " to " + new File(targetDir, targetFilename).getAbsolutePath()));
        NetworkUtils.downloadFile(u, targetDir, targetFilename);
    }

    private static File getDirectoryForAnnotation(AnnotationDownloadInformation info) {
        return AnnotationManager.getDirectoryForAnnotation(info.getProgramName(), info.getProgramVersion(), info.getReference());
    }

    private static File getDirectoryForAnnotation(String programName, String programVersion, String reference) {
        return new File(localDirectory.getAbsolutePath() + "/" + reference + "/" + programName + "/" + programVersion);
    }

    private static File getTabixFile(File dir) {
        return AnnotationManager.getFileWithExtentionInDir(dir, "gz");
    }

    private static File getTabixIndexFile(File dir) {
        return AnnotationManager.getFileWithExtentionInDir(dir, "tbi");
    }

    private static File getFormatFile(File dir) {
        return AnnotationManager.getFileWithExtentionInDir(dir, "xml");
    }

    private static File getFileWithExtentionInDir(File dir, final String ext) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("." + ext);
            }
        })[0];
    }

    private int getInstalledAnnotationID(String sessID, AnnotationDownloadInformation info) throws RemoteException, SQLException, SessionExpiredException {
        TableSchema table = MedSavantDatabase.AnnotationTableSchema;
        SelectQuery query1 = new SelectQuery();
        query1.addFromTable(table.getTable());
        query1.addAllColumns();
        query1.addCondition(ComboCondition.and(BinaryConditionMS.equalTo(table.getDBColumn(PROGRAM), info.getProgramName()), BinaryConditionMS.equalTo(table.getDBColumn(VERSION), info.getProgramVersion()), BinaryConditionMS.equalTo(table.getDBColumn(REFERENCE_ID), ReferenceManager.getInstance().getReferenceID(sessID, info.getReference()))));
        ResultSet rs1 = ConnectionController.executeQuery(sessID, query1.toString());
        if (rs1.next()) {
            return rs1.getInt("annotation_id");
        }
        return -1;
    }

    @Override
    public void uninstallAnnotation(String sessionID, int annotationID) throws RemoteException, SQLException, SessionExpiredException {
        File installationPath = this.getInstallationDirectoryFromID(sessionID, annotationID);
        TableSchema table = MedSavantDatabase.AnnotationTableSchema;
        DeleteQuery query1 = new DeleteQuery(table.getTable());
        query1.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(ANNOTATION_ID), annotationID));
        ConnectionController.executeUpdate(sessionID, query1.toString());
        TableSchema table2 = MedSavantDatabase.AnnotationFormatTableSchema;
        DeleteQuery query2 = new DeleteQuery(table2.getTable());
        query2.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(ANNOTATION_ID), annotationID));
        ConnectionController.executeUpdate(sessionID, query2.toString());
        try {
            Process p = Runtime.getRuntime().exec("chmod -R o+w " + installationPath.getAbsolutePath());
            p.waitFor();
        }
        catch (Exception e) {
            // empty catch block
        }
        AnnotationManager.deleteDirectory(installationPath);
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    AnnotationManager.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private static File generateInstallationDirectory() {
        int i = 1;
        while (true) {
            File dir;
            if (!(dir = new File(localDirectory.getAbsolutePath(), i + "")).exists()) {
                LOG.info((Object)("Creating installation directory: " + dir.getAbsolutePath()));
                if (!dir.mkdirs()) {
                    LOG.error((Object)("Couldn't create installation directory for annotation: " + dir.getAbsolutePath()));
                }
                return dir;
            }
            ++i;
        }
    }

    private static int registerAnnotationWithProject(File dir, String sessionID) throws RemoteException, SAXException, SQLException, IOException, ParserConfigurationException, SessionExpiredException {
        LOG.info((Object)"Parsing format...");
        AnnotationFormat format = AnnotationManager.parseFormat(AnnotationManager.getTabixFile(dir), AnnotationManager.getFormatFile(dir));
        LOG.info((Object)"... DONE");
        LOG.info((Object)("FORMAT: " + format));
        int id = AnnotationManager.addAnnotation(sessionID, format.getProgram(), format.getVersion(), ReferenceManager.getInstance().getReferenceID(sessionID, format.getReferenceName()), AnnotationManager.getTabixFile(dir).getAbsolutePath(), format.hasRef(), format.hasAlt(), AnnotationFormat.AnnotationType.toInt(format.getType()), format.isEndInclusive());
        PooledConnection conn = ConnectionController.connectPooled(sessionID);
        conn.setAutoCommit(false);
        int i = 0;
        for (CustomField a : format.getCustomFields()) {
            AnnotationManager.addAnnotationFormat(sessionID, id, i++, id + "_" + a.getColumnName(), a.getTypeString(), a.isFilterable(), a.getAlias(), a.getDescription(), a.getTags());
        }
        conn.commit();
        conn.setAutoCommit(true);
        conn.close();
        LOG.info((Object)("Installed to " + dir.getAbsolutePath()));
        return id;
    }

    private File getInstallationDirectoryFromID(String sessID, int annotationID) throws SQLException, SessionExpiredException {
        TableSchema table = MedSavantDatabase.AnnotationTableSchema;
        SelectQuery query1 = new SelectQuery();
        query1.addFromTable(table.getTable());
        query1.addColumns(table.getDBColumn(PATH));
        query1.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(ANNOTATION_ID), annotationID));
        LOG.info((Object)query1.toString());
        ResultSet rs1 = ConnectionController.executeQuery(sessID, query1.toString());
        if (rs1.next()) {
            String path = rs1.getString(1);
            LOG.info((Object)("Path to installation directory is " + path));
            File f = new File(path);
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            return f;
        }
        LOG.info((Object)("Error getting path to installation directory for annotation with ID " + annotationID));
        return null;
    }

    @Override
    public Set<String> getAnnotationTags(String sessID) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema annFormatTable = MedSavantDatabase.AnnotationFormatTableSchema;
        SelectQuery query2 = new SelectQuery();
        query2.addFromTable(annFormatTable.getTable());
        query2.addColumns(annFormatTable.getDBColumn(MedSavantDatabase.AnnotationFormatColumns.TAGS.getColumnName()));
        query2.setIsDistinct(true);
        ResultSet rs2 = ConnectionController.executeQuery(sessID, query2.toString());
        HashSet<String> tags = new HashSet<String>();
        while (rs2.next()) {
            String[] tagArray;
            String tagStr = rs2.getString(MedSavantDatabase.AnnotationFormatColumns.TAGS.getColumnName());
            for (String tag : tagArray = tagStr.split(",")) {
                tags.add(tag);
            }
        }
        rs2.close();
        return tags;
    }

    @Override
    public Map<String, Set<CustomField>> getAnnotationFieldsByTag(String sessionId, boolean includeUndefined) throws SQLException, RemoteException, SessionExpiredException {
        Annotation[] annotations;
        String UNDEFINED_TAG = "UNDEFINED";
        HashMap<String, Set<CustomField>> amap = new HashMap<String, Set<CustomField>>();
        for (Annotation annotation : annotations = this.getAnnotations(sessionId)) {
            CustomField[] customFields;
            AnnotationFormat af = this.getAnnotationFormat(sessionId, annotation.getID());
            for (CustomField customField : customFields = af.getCustomFields()) {
                Set<String> tags = customField.getTags();
                if (tags.isEmpty() && includeUndefined) {
                    tags.add("UNDEFINED");
                }
                for (String tag : tags) {
                    HashSet<CustomField> cs = (HashSet<CustomField>)amap.get(tag);
                    if (cs == null) {
                        cs = new HashSet<CustomField>();
                    }
                    cs.add(customField);
                    amap.put(tag, cs);
                }
            }
        }
        return amap;
    }

    static {
        localDirectory = new File(DirectorySettings.getMedSavantDirectory() + "/annotation");
    }
}

