/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.ontology;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.ontology.OBOParser;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.Ontology;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.OntologyManagerAdapter;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.util.RemoteFileCache;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class OntologyManager
extends MedSavantServerUnicastRemoteObject
implements OntologyManagerAdapter,
MedSavantDatabase.OntologyColumns,
MedSavantDatabase.OntologyInfoColumns {
    private static final Log LOG = LogFactory.getLog(OntologyManager.class);
    private static OntologyManager instance;
    private PooledConnection connection;
    private final TableSchema ontologySchema = MedSavantDatabase.OntologyTableSchema;
    private final TableSchema ontologyInfoSchema = MedSavantDatabase.OntologyInfoTableSchema;

    public static OntologyManager getInstance() throws RemoteException {
        if (instance == null) {
            instance = new OntologyManager();
        }
        return instance;
    }

    private OntologyManager() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOntology(String sessID, String name, OntologyType type, URL oboData, URL mappingData) throws IOException, SQLException, SessionExpiredException {
        switch (type) {
            case GO: {
                this.populateGOTables(sessID, name, oboData, mappingData);
                break;
            }
            case HPO: {
                this.populateHPOTables(sessID, name, oboData, mappingData);
                break;
            }
            case OMIM: {
                this.populateOMIMTables(sessID, name, oboData, mappingData);
            }
        }
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.executePreparedUpdate(this.ontologyInfoSchema.delete(ONTOLOGY_NAME, name).toString(), new Object[0]);
            conn.executePreparedUpdate(this.ontologyInfoSchema.preparedInsert(TYPE, ONTOLOGY_NAME, OBO_URL, MAPPING_URL).toString(), type.toString(), name, oboData.toString(), mappingData.toString());
        }
        finally {
            conn.close();
        }
    }

    @Override
    public void removeOntology(String sessID, String ontName) throws IOException, SQLException, RemoteException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology[] getOntologies(String sessID) throws SQLException, RemoteException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            ArrayList<Ontology> results = new ArrayList<Ontology>();
            ResultSet rs = conn.executePreparedQuery(this.ontologyInfoSchema.distinct().select(TYPE, ONTOLOGY_NAME, OBO_URL, MAPPING_URL).toString(), new Object[0]);
            while (rs.next()) {
                String name = rs.getString(2);
                try {
                    results.add(new Ontology(Enum.valueOf(OntologyType.class, rs.getString(1)), rs.getString(2), new URL(rs.getString(3)), new URL(rs.getString(4))));
                }
                catch (MalformedURLException ex) {
                    LOG.warn((Object)String.format("Error parsing URL for %s: %s", name, MiscUtils.getMessage(ex)), (Throwable)ex);
                }
            }
            Ontology[] ontologyArray = results.toArray(new Ontology[0]);
            return ontologyArray;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyTerm[] getAllTerms(String sessID, OntologyType ont) throws InterruptedException, SQLException, SessionExpiredException {
        this.makeProgress(sessID, "Connecting...", 0.0);
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            double prog = 0.2;
            this.makeProgress(sessID, "Executing query...", prog);
            String q = this.ontologySchema.where(ONTOLOGY, ont.toString()).whereNotNull(GENES).orderBy(ID).select(ID, NAME, DEF, ALT_IDS, PARENTS).toString();
            LOG.info((Object)("Getting all ontology terms: " + q));
            ResultSet rs = conn.executePreparedQuery(q, new Object[0]);
            while (rs.next()) {
                prog = 0.5 + prog * 0.5;
                this.makeProgress(sessID, "Retrieving ontology terms...", prog);
                result.add(new OntologyTerm(ont, rs.getString(1), rs.getString(2), rs.getString(3), StringUtils.split((String)rs.getString(4), (char)','), StringUtils.split((String)rs.getString(5), (char)',')));
            }
        }
        finally {
            conn.close();
        }
        return result.toArray(new OntologyTerm[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getGenesForTerm(String sessID, OntologyTerm term, String refID) throws SQLException, SessionExpiredException {
        ArrayList<String> result = new ArrayList<String>();
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            String geneString;
            ResultSet rs = conn.executePreparedQuery(this.ontologySchema.where(ID, term.getID(), ONTOLOGY, term.getOntology().toString()).select(GENES), new Object[0]);
            if (rs.next() && (geneString = rs.getString(1)) != null && geneString.length() > 2) {
                result.addAll(Arrays.asList(geneString.substring(1).split("\\|")));
            }
        }
        finally {
            conn.close();
        }
        return result.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<OntologyTerm, String[]> getGenesForTerms(String sessID, OntologyTerm[] terms, String refID) throws SQLException, SessionExpiredException {
        HashMap<OntologyTerm, String[]> result = new HashMap<OntologyTerm, String[]>();
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            StringBuilder termsString = new StringBuilder("'");
            if (terms.length > 0) {
                termsString.append(terms[0].getID());
                for (int i = 1; i < terms.length; ++i) {
                    termsString.append("', '");
                    termsString.append(terms[i].getID());
                }
                termsString.append('\'');
                ResultSet rs = conn.executePreparedQuery(String.format("SELECT id,genes FROM ontology WHERE ontology=? and id IN (%s)", termsString), terms[0].getOntology().toString());
                while (rs.next()) {
                    OntologyTerm term = OntologyManager.findTermByID(terms, rs.getString(1));
                    String genesString = rs.getString(2);
                    if (genesString == null || genesString.length() <= 2) continue;
                    result.put(term, genesString.substring(1).split("\\|"));
                }
            }
        }
        finally {
            conn.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyTerm[] getTermsForGene(String sessID, OntologyType ont, String geneName) throws SQLException, SessionExpiredException {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            if (ont != null) {
                ResultSet rs = conn.executePreparedQuery("SELECT id,name,def,alt_ids,parents FROM ontology WHERE ontology=? AND INSTR(genes, ?)", ont.toString(), "|" + geneName + "|");
                while (rs.next()) {
                    result.add(new OntologyTerm(ont, rs.getString(1), rs.getString(2), rs.getString(3), StringUtils.split((String)rs.getString(4), (char)','), StringUtils.split((String)rs.getString(5), (char)',')));
                }
            } else {
                ResultSet rs = conn.executePreparedQuery("SELECT id,ontology.name,def,alt_ids,parents,type FROM ontology RIGHT JOIN ontology_info ON ontology = ontology_info.name WHERE INSTR(genes, ?)", "|" + geneName + "|");
                while (rs.next()) {
                    result.add(new OntologyTerm(OntologyType.valueOf(rs.getString(6)), rs.getString(1), rs.getString(2), rs.getString(3), StringUtils.split((String)rs.getString(4), (char)','), StringUtils.split((String)rs.getString(5), (char)',')));
                }
            }
        }
        finally {
            conn.close();
        }
        return result.toArray(new OntologyTerm[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntologyTerm getOntologyTerm(String sessID, OntologyType ont, String ontologyId) throws SQLException, SessionExpiredException {
        PooledConnection conn = null;
        ResultSet rs = null;
        try {
            conn = ConnectionController.connectPooled(sessID);
            rs = conn.executePreparedQuery("SELECT id,name,def,alt_ids,parents FROM ontology WHERE ontology=? AND id=?", ont.toString(), ontologyId);
            if (rs.next()) {
                OntologyTerm ontologyTerm = new OntologyTerm(ont, rs.getString(1), rs.getString(2), rs.getString(3), StringUtils.split((String)rs.getString(4), (char)','), StringUtils.split((String)rs.getString(5), (char)','));
                return ontologyTerm;
            }
            OntologyTerm ontologyTerm = null;
            return ontologyTerm;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGOTables(String sessID, String name, URL oboData, URL goToGeneData) throws IOException, SQLException, SessionExpiredException {
        LOG.info((Object)("Parsing OBO " + oboData));
        Map<String, OntologyTerm> terms = new OBOParser(OntologyType.GO).load(oboData);
        this.connection = ConnectionController.connectPooled(sessID);
        LOG.info((Object)("Session " + sessID + " made connection"));
        try {
            this.populateTable(name, terms);
            HashMap<String, Set<String>> allGenes = new HashMap<String, Set<String>>();
            LOG.info((Object)("Reading annotation file " + goToGeneData + " (Cache: " + RemoteFileCache.getCacheFile(goToGeneData) + ")"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(RemoteFileCache.getCacheFile(goToGeneData)))));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] fields;
                    if (line.length() <= 0 || line.charAt(0) == '!' || (fields = line.split("\t")).length <= 4 || fields[3].equals("NOT")) continue;
                    this.addGenesToTerm(terms, allGenes, fields[2], fields[4]);
                }
                PreparedStatement updateStatement = this.connection.prepareStatement("UPDATE ontology SET genes=? WHERE id=?");
                for (String t : allGenes.keySet()) {
                    Set termGenes = (Set)allGenes.get(t);
                    String geneString = StringUtils.join((Iterable)termGenes, (char)'|');
                    this.connection.executePreparedUpdate(updateStatement, "|" + geneString + "|", t);
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            this.connection.close();
            this.connection = null;
        }
    }

    private void addGenesToTerm(Map<String, OntologyTerm> allTerms, Map<String, Set<String>> allGenes, String gene, String term) {
        Set<String> termGenes = allGenes.get(term);
        if (termGenes == null) {
            termGenes = new HashSet<String>();
            allGenes.put(term, termGenes);
        }
        termGenes.add(gene);
        OntologyTerm term2 = allTerms.get(term);
        if (term2 != null) {
            for (String p : term2.getParentIDs()) {
                this.addGenesToTerm(allTerms, allGenes, gene, p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateHPOTables(String sessID, String name, URL oboData, URL hpoToGeneData) throws IOException, SQLException, SessionExpiredException {
        Map<String, OntologyTerm> terms = new OBOParser(OntologyType.HPO).load(oboData);
        this.connection = ConnectionController.connectPooled(sessID);
        try {
            String line;
            this.populateTable(name, terms);
            PreparedStatement updStmt = this.connection.prepareStatement("UPDATE ontology SET genes=? WHERE id=?");
            BufferedReader reader = new BufferedReader(new FileReader(RemoteFileCache.getCacheFile(hpoToGeneData)));
            while ((line = reader.readLine()) != null) {
                int hpPos;
                if (line.length() <= 0 || line.charAt(0) == '#' || (hpPos = line.indexOf("(HP:")) <= 0) continue;
                String term = line.substring(hpPos + 1, hpPos + 11);
                int genesStart = line.indexOf("\t[");
                if (genesStart <= 0) continue;
                line = line.substring(genesStart + 2, line.length() - 1);
                String[] genes = line.split(", ");
                String geneString = "|";
                for (String g : genes) {
                    geneString = geneString + g.substring(0, g.indexOf(40)) + "|";
                }
                this.connection.executePreparedUpdate(updStmt, geneString, term);
            }
        }
        finally {
            this.connection.close();
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateOMIMTables(String sessID, String name, URL oboData, URL omimToHPOData) throws IOException, SQLException, SessionExpiredException {
        Map<String, OntologyTerm> terms = new OBOParser(OntologyType.OMIM).load(oboData);
        this.connection = ConnectionController.connectPooled(sessID);
        try {
            String line;
            this.populateTable(name, terms);
            PreparedStatement updStmt = this.connection.prepareStatement("UPDATE ontology SET genes=? WHERE id=?");
            PreparedStatement hpoSelStmt = this.connection.prepareStatement("SELECT genes FROM ontology where ontology='HPO' AND (id=? OR INSTR(alt_ids, ?))");
            HashMap<String, String[]> hpoGeneCache = new HashMap<String, String[]>();
            BufferedReader reader = new BufferedReader(new FileReader(RemoteFileCache.getCacheFile(omimToHPOData)));
            String omimTerm = null;
            String omimGenes = null;
            while ((line = reader.readLine()) != null) {
                String hpoTerm;
                String[] hpoGenes;
                String[] fields;
                if (!line.startsWith("OMIM") || (fields = line.split("\t")).length < 5 || fields[3].equals("NOT")) continue;
                String newTerm = "MIM:" + fields[1];
                if (!newTerm.equals(omimTerm)) {
                    if (omimGenes != null) {
                        this.connection.executePreparedUpdate(updStmt, omimGenes, omimTerm);
                        omimGenes = null;
                    }
                    omimTerm = newTerm;
                }
                if ((hpoGenes = (String[])hpoGeneCache.get(hpoTerm = fields[4])) == null) {
                    ResultSet rs = this.connection.executePreparedQuery(hpoSelStmt, hpoTerm, hpoTerm);
                    if (rs.next()) {
                        String geneString = rs.getString(1);
                        hpoGenes = geneString != null ? geneString.split("\\|") : new String[]{};
                    } else {
                        hpoGenes = new String[]{};
                        LOG.info((Object)("Unable to find HPO term " + hpoTerm + " for " + omimTerm));
                    }
                    hpoGeneCache.put(hpoTerm, hpoGenes);
                }
                for (String g : hpoGenes) {
                    if (g.length() <= 0) continue;
                    g = "|" + g + "|";
                    if (omimGenes == null) {
                        omimGenes = g;
                        continue;
                    }
                    if (omimGenes.contains(g)) continue;
                    omimGenes = omimGenes + g.substring(1);
                }
            }
            if (omimGenes != null) {
                this.connection.executePreparedUpdate(updStmt, omimGenes, omimTerm);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    private void populateTable(String name, Map<String, OntologyTerm> terms) throws SQLException {
        Object backupTableName = null;
        PreparedStatement prep4 = this.connection.prepareStatement(this.ontologySchema.preparedInsert(ONTOLOGY, ID, NAME, DEF).toString());
        PreparedStatement prep5a = this.connection.prepareStatement(this.ontologySchema.preparedInsert(ONTOLOGY, ID, NAME, DEF, ALT_IDS).toString());
        PreparedStatement prep5b = this.connection.prepareStatement(this.ontologySchema.preparedInsert(ONTOLOGY, ID, NAME, DEF, PARENTS).toString());
        PreparedStatement prep6 = this.connection.prepareStatement(this.ontologySchema.preparedInsert(ONTOLOGY, ID, NAME, DEF, ALT_IDS, PARENTS).toString());
        int mostAltIDs = 1;
        for (OntologyTerm t : terms.values()) {
            PreparedStatement prep;
            if (t.getAltIDs().length > 0) {
                if (t.getParentIDs().length > 0) {
                    prep = prep6;
                    prep.setString(6, StringUtils.join((Object[])t.getParentIDs(), (char)','));
                } else {
                    prep = prep5a;
                }
                prep.setString(5, StringUtils.join((Object[])t.getAltIDs(), (char)','));
                if (t.getAltIDs().length > mostAltIDs) {
                    mostAltIDs = t.getAltIDs().length;
                    LOG.info((Object)(t.getID() + " had " + mostAltIDs + " alt_ids."));
                }
            } else if (t.getParentIDs().length > 0) {
                prep = prep5b;
                prep.setString(5, StringUtils.join((Object[])t.getParentIDs(), (char)','));
            } else {
                prep = prep4;
            }
            prep.setString(1, name);
            prep.setString(2, t.getID());
            prep.setString(3, t.getName());
            prep.setString(4, t.getDef());
            prep.executeUpdate();
        }
        LOG.debug((Object)String.format("Inserted %d records.", terms.size()));
        if (backupTableName != null) {
            this.connection.executeUpdate("DROP TABLE ontology_back");
            LOG.debug((Object)"Dropped ontology_back.");
        }
    }

    private static OntologyTerm findTermByID(OntologyTerm[] terms, String termID) {
        for (OntologyTerm t : terms) {
            if (!t.getID().equals(termID)) continue;
            return t;
        }
        return null;
    }

    public void populate(final String sessID) {
        try {
            MedSavantServerEngine.submitShortJob(new MedSavantServerJob(SessionManager.getInstance().getUserForSession(sessID), "Ontology Populator", null){

                @Override
                public boolean run() {
                    try {
                        LOG.info((Object)("dbname for connection: " + ConnectionController.getDBName(sessID)));
                        LOG.info((Object)"Adding GO Ontology");
                        OntologyManager.this.addOntology(sessID, OntologyType.GO.toString(), OntologyType.GO, WebResources.GO_OBO_URL, WebResources.GO_TO_GENES_URL);
                        LOG.info((Object)"Adding HPO Ontology");
                        OntologyManager.this.addOntology(sessID, OntologyType.HPO.toString(), OntologyType.HPO, WebResources.HPO_OBO_URL, WebResources.HPO_TO_GENES_URL);
                        LOG.info((Object)"Adding OMIM Ontology");
                        OntologyManager.this.addOntology(sessID, OntologyType.OMIM.toString(), OntologyType.OMIM, WebResources.OMIM_OBO_URL, WebResources.OMIM_TO_HPO_URL);
                        SessionManager.getInstance().unregisterSession(sessID);
                        return true;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error populating ontology tables.", (Throwable)ex);
                        return false;
                    }
                }
            });
        }
        catch (Exception ex) {
            LOG.error((Object)"Error populating ontology tables.", (Throwable)ex);
        }
    }
}

