/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Function;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.admin.SetupMedSavantDatabase;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.db.util.DBSettings;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.server.db.variants.Jannovar;
import org.ut.biolab.medsavant.server.db.variants.TSVFile;
import org.ut.biolab.medsavant.server.db.variants.VariantManagerUtils;
import org.ut.biolab.medsavant.server.db.variants.VariantParser;
import org.ut.biolab.medsavant.server.phasing.BEAGLEWrapper;
import org.ut.biolab.medsavant.server.serverapi.AnnotationLogManager;
import org.ut.biolab.medsavant.server.serverapi.AnnotationManager;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.server.serverapi.PatientManager;
import org.ut.biolab.medsavant.server.serverapi.ProjectManager;
import org.ut.biolab.medsavant.server.serverapi.ReferenceManager;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.serverapi.VariantManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.AnnotationLog;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.IOUtils;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class ImportUpdateManager {
    private static final Log LOG = LogFactory.getLog(ImportUpdateManager.class);

    public static int doImport(final String sessionID, final int projectID, final int referenceID, final File[] allVCFFiles, final boolean includeHomozygousReferenceCalls, final boolean preAnnotateWithJannovar, final boolean doPhasing, final String[][] tags) throws IOException, SQLException, Exception {
        String userId = SessionManager.getInstance().getUserForSession(sessionID);
        final String database = SessionManager.getInstance().getDatabaseForSession(sessionID);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd - HH:mm:ss");
        final int updateID = AnnotationLogManager.getInstance().addAnnotationLogEntry(sessionID, projectID, referenceID, AnnotationLog.Action.ADD_VARIANTS);
        MedSavantServerJob importJob = new MedSavantServerJob(userId, database + ": VCF Import, " + dateFormat.format(new Date()), null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() throws Exception {
                ProjectManager.getInstance().restorePublishedFileTable(sessionID);
                LOG.info((Object)"Starting import");
                File workingDirectory = DirectorySettings.generateDateStampDirectory(DirectorySettings.getTmpDirectory());
                LOG.info((Object)("Working directory is " + workingDirectory.getAbsolutePath()));
                int startFile = 0;
                int endFile = Math.min(allVCFFiles.length, MedSavantServerEngine.getMaxThreads());
                ArrayList<TSVFile> allAnnotatedFiles = new ArrayList<TSVFile>();
                int[] allAnnotationIDs = new int[]{};
                File workingDir = null;
                File finalAnnotationDestDir = DirectorySettings.getAnnotatedTSVDirectory(database, projectID, referenceID);
                if (!finalAnnotationDestDir.exists()) {
                    finalAnnotationDestDir.mkdirs();
                }
                try {
                    this.getJobProgress().setMessage("Preparing database for new variants...");
                    int[] annotationIDs = AnnotationManager.getInstance().getAnnotationIDs(sessionID, projectID, referenceID);
                    CustomField[] customFields = ProjectManager.getInstance().getCustomVariantFields(sessionID, projectID, referenceID, ProjectManager.getInstance().getNewestUpdateID(sessionID, projectID, referenceID, false));
                    int numVariantsImported = 0;
                    ProjectManager.getInstance().setCustomVariantFields(sessionID, projectID, referenceID, updateID, customFields);
                    while (startFile < endFile) {
                        TSVFile[] annotatedFiles;
                        workingDir = ImportUpdateManager.createSubdir(workingDirectory, "annotate_upload");
                        File[] vcfFiles = (File[])ArrayUtils.subarray((Object[])allVCFFiles, (int)startFile, (int)endFile);
                        this.getJobProgress().setMessage("Preparing VCFs " + startFile + " - " + endFile + " of " + allVCFFiles.length + " for further annotations");
                        TSVFile[] importedTSVFiles = ImportUpdateManager.doConvertVCFToTSV(sessionID, vcfFiles, preAnnotateWithJannovar, doPhasing, updateID, projectID, referenceID, includeHomozygousReferenceCalls, workingDirectory, this);
                        this.getJobProgress().setMessage("Annotating VCFs " + startFile + " - " + endFile + " of " + allVCFFiles.length);
                        for (TSVFile file : importedTSVFiles) {
                            numVariantsImported += file.getNumLines();
                        }
                        for (TSVFile annotatedFile : annotatedFiles = ImportUpdateManager.annotateTSVFiles(sessionID, updateID, projectID, referenceID, annotationIDs, customFields, importedTSVFiles, workingDir, this)) {
                            File dst = new File(finalAnnotationDestDir, annotatedFile.getFile().getName());
                            annotatedFile.moveTo(dst);
                            allAnnotatedFiles.add(annotatedFile);
                        }
                        allAnnotationIDs = ArrayUtils.addAll((int[])allAnnotationIDs, (int[])annotationIDs);
                        if (VariantManager.REMOVE_WORKING_DIR) {
                            MiscUtils.deleteDirectory(workingDir);
                        }
                        startFile += MedSavantServerEngine.getMaxThreads();
                        endFile = Math.min(allVCFFiles.length, endFile + MedSavantServerEngine.getMaxThreads());
                    }
                    this.getJobProgress().setMessage("Done annotating, loading all variants into database.");
                    workingDir = ImportUpdateManager.createSubdir(workingDirectory, "annotate_upload");
                    String currentTableName = ProjectManager.getInstance().getNameOfVariantTable(sessionID, projectID, referenceID, true, false);
                    String tableNameSubset = ProjectManager.getInstance().addVariantTableToDatabase(sessionID, projectID, referenceID, updateID, annotationIDs, customFields, true);
                    ImportUpdateManager.appendTSVFilesToVariantTable(sessionID, projectID, referenceID, updateID, allAnnotatedFiles.toArray(new TSVFile[allAnnotatedFiles.size()]), currentTableName);
                    int[] fileIds = ImportUpdateManager.getFileIds(sessionID, projectID, referenceID, updateID);
                    String viewName = DBSettings.getVariantViewName(projectID, referenceID);
                    int totalNumVariants = numVariantsImported + VariantManager.getInstance().getNumFilteredVariantsHelper(sessionID, viewName, new Condition[0][]);
                    TableSchema publishedVariantView = CustomTables.getInstance().getCustomTableSchema(sessionID, viewName);
                    TableSchema unpublishedVariantTable = CustomTables.getInstance().getCustomTableSchema(sessionID, currentTableName);
                    MedSavantDatabase.VariantFileTableSchema publishedFileTable = MedSavantDatabase.VariantFileIBTableSchema;
                    MedSavantDatabase.VariantFileTableSchema unpublishedFileTable = MedSavantDatabase.VariantFileTableSchema;
                    TableSchema tmpTable = null;
                    try {
                        tmpTable = SetupMedSavantDatabase.makeTemporaryVariantFileIBTable(sessionID);
                        SelectQuery query = new SelectQuery();
                        query.addAllTableColumns(unpublishedFileTable.getTable());
                        Condition[] conditionArray = new Condition[2];
                        conditionArray[0] = BinaryCondition.equalTo(unpublishedFileTable.getDBColumn("project_id"), projectID);
                        conditionArray[1] = BinaryCondition.equalTo(unpublishedFileTable.getDBColumn("reference_id"), referenceID);
                        query.addCondition(ComboCondition.and(conditionArray));
                        DBUtils.copyQueryResultToNewTable(sessionID, query, tmpTable.getTableName(), (MedSavantServerJob)this);
                        query = new SelectQuery();
                        query.addAllTableColumns(unpublishedVariantTable.getTable());
                        query.addJoin(SelectQuery.JoinType.INNER, unpublishedVariantTable.getTable(), tmpTable.getTable(), BinaryCondition.equalTo(unpublishedVariantTable.getDBColumn(BasicVariantColumns.FILE_ID), tmpTable.getDBColumn("file_id")));
                        query.addCondition(BinaryCondition.lessThan(new FunctionCall(new Function(){

                            @Override
                            public String getFunctionNameSQL() {
                                return "RAND";
                            }
                        }), VariantManager.getSubsetFraction(totalNumVariants), true));
                        DBUtils.copyQueryResultToNewTable(sessionID, query, tableNameSubset, (MedSavantServerJob)this);
                    }
                    finally {
                        if (tmpTable != null) {
                            DBUtils.dropTable(sessionID, tmpTable.getTableName());
                        }
                    }
                    ImportUpdateManager.registerTable(sessionID, projectID, referenceID, updateID, currentTableName, tableNameSubset, allAnnotationIDs);
                    VariantManagerUtils.addTagsToUpload(sessionID, updateID, tags);
                    ImportUpdateManager.createPatientsForUpdate(sessionID, currentTableName, projectID, updateID);
                }
                finally {
                    if (VariantManager.REMOVE_WORKING_DIR) {
                        if (workingDirectory != null && workingDirectory.exists()) {
                            MiscUtils.deleteDirectory(workingDirectory);
                        }
                        MiscUtils.deleteDirectory(finalAnnotationDestDir);
                    }
                }
                LOG.info((Object)"Finished import");
                return true;
            }
        };
        MedSavantServerEngine.runJobInCurrentThread(importJob);
        return updateID;
    }

    private static int[] getFileIds(String sessionId, int projectID, int referenceID, int updateID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantFileTableSchema table = MedSavantDatabase.VariantFileTableSchema;
        SelectQuery sq = new SelectQuery();
        sq.addFromTable(table.getTable());
        Column[] columnArray = new Column[1];
        columnArray[0] = table.getDBColumn("file_id");
        sq.addColumns(columnArray);
        sq.addCondition(BinaryCondition.equalTo(table.getDBColumn("reference_id"), referenceID));
        sq.addCondition(BinaryCondition.equalTo(table.getDBColumn("project_id"), projectID));
        sq.addCondition(BinaryCondition.equalTo(table.getDBColumn("upload_id"), updateID));
        ResultSet rs = ConnectionController.executeQuery(sessionId, sq.toString());
        ArrayList<Integer> fileIds = new ArrayList<Integer>();
        while (rs.next()) {
            fileIds.add(rs.getInt("file_id"));
        }
        return ArrayUtils.toPrimitive((Integer[])fileIds.toArray(new Integer[fileIds.size()]));
    }

    public static int doUpdate(final String sessionID, final int projectID, final int referenceID, final int[] annotationIDs, final CustomField[] customFields, final boolean publishUponCompletion) throws Exception {
        String userId = SessionManager.getInstance().getUserForSession(sessionID);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd - HH:mm:ss");
        String existingVariantTableName = ProjectManager.getInstance().getNameOfVariantTable(sessionID, projectID, referenceID, true, false);
        final String existingViewName = DBSettings.getVariantViewName(projectID, referenceID);
        final int updateID = AnnotationLogManager.getInstance().addAnnotationLogEntry(sessionID, projectID, referenceID, AnnotationLog.Action.UPDATE_TABLE);
        String database = SessionManager.getInstance().getDatabaseForSession(sessionID);
        MedSavantServerJob updateJob = new MedSavantServerJob(userId, database + ": VCF Update - " + dateFormat.format(new Date()), null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() throws Exception {
                File workingDirectory = DirectorySettings.generateDateStampDirectory(DirectorySettings.getTmpDirectory());
                try {
                    ProjectManager.getInstance().restorePublishedFileTable(sessionID);
                    this.getJobProgress().setMessage("Writing existing variants to file");
                    TSVFile existingViewAsTSV = ImportUpdateManager.doDumpTableAsTSV(sessionID, existingViewName, ImportUpdateManager.createSubdir(workingDirectory, "dump"));
                    this.getJobProgress().setMessage("Annotating...");
                    String tableName = ProjectManager.getInstance().addVariantTableToDatabase(sessionID, projectID, referenceID, updateID, annotationIDs, customFields, false);
                    String tableNameSubset = ProjectManager.getInstance().addVariantTableToDatabase(sessionID, projectID, referenceID, updateID, annotationIDs, customFields, true);
                    File workingDir = ImportUpdateManager.createSubdir(workingDirectory, "annotate_upload");
                    ProjectManager.getInstance().setCustomVariantFields(sessionID, projectID, referenceID, updateID, customFields);
                    TSVFile[] annotatedFiles = ImportUpdateManager.annotateTSVFiles(sessionID, updateID, projectID, referenceID, annotationIDs, customFields, new TSVFile[]{existingViewAsTSV}, workingDir, this);
                    ImportUpdateManager.appendTSVFilesToVariantTable(sessionID, projectID, referenceID, updateID, annotatedFiles, tableName);
                    SelectQuery sq = new SelectQuery();
                    TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessionID, tableName);
                    sq.addFromTable(table.getTable());
                    sq.addAllColumns();
                    sq.addCondition(VariantManager.getSubsetRestrictionCondition(existingViewAsTSV.getNumLines()));
                    DBUtils.copyQueryResultToNewTable(sessionID, sq, tableNameSubset);
                    ImportUpdateManager.registerTable(sessionID, projectID, referenceID, updateID, tableName, tableNameSubset, annotationIDs);
                    if (publishUponCompletion) {
                        ImportUpdateManager.publishLatestUpdate(sessionID, projectID);
                    }
                }
                finally {
                    if (VariantManager.REMOVE_WORKING_DIR) {
                        MiscUtils.deleteDirectory(workingDirectory);
                    }
                }
                return true;
            }
        };
        MedSavantServerEngine.runJobInCurrentThread(updateJob);
        return updateID;
    }

    private static void publishLatestUpdate(String sessionID, int projectID) throws RemoteException, Exception {
        VariantManager.getInstance().publishVariants(sessionID, projectID);
    }

    private static void setAnnotationStatus(String sessionID, int updateID, AnnotationLog.Status status) throws SQLException, SessionExpiredException {
        AnnotationLogManager.getInstance().setAnnotationLogStatus(sessionID, updateID, status);
    }

    private static void registerTable(String sessionID, int projectID, int referenceID, int updateID, String tableName, String tableNameSub, int[] annotationIDs) throws RemoteException, SQLException, SessionExpiredException {
        ProjectManager.getInstance().addTableToMap(sessionID, projectID, referenceID, updateID, false, tableName, annotationIDs, tableNameSub);
    }

    public static TSVFile[] doConvertVCFToTSV(String sessID, File[] vcfFiles, boolean preAnnotateWithJannovar, boolean doPhasing, int updateID, int projectID, int referenceID, boolean includeHomozygousReferenceCalls, final File workingDirectory, MedSavantServerJob parentJob) throws Exception {
        int i;
        String database = SessionManager.getInstance().getDatabaseForSession(sessID);
        File outDir = ImportUpdateManager.createSubdir(workingDirectory, "converted");
        LOG.info((Object)("Converting VCF files to TSV, working directory is " + outDir.getAbsolutePath()));
        File[] processedVCFs = vcfFiles;
        parentJob.getJobProgress().setMessage("Performing functional annotations for VCFs.");
        if (doPhasing || preAnnotateWithJannovar) {
            LogManager.getInstance().addServerLog(sessID, LogManagerAdapter.LogType.INFO, "Annotating VCF files with Jannovar");
            processedVCFs = new Jannovar(ReferenceManager.getInstance().getReferenceName(sessID, referenceID)).annotateVCFFiles(vcfFiles, database, projectID, workingDirectory);
        }
        if (doPhasing) {
            final File[] phasedFiles = new File[processedVCFs.length];
            parentJob.getJobProgress().setMessage("Phasing...");
            LOG.info((Object)"Beginning phasing.");
            ArrayList threads = new ArrayList(processedVCFs.length);
            String username = SessionManager.getInstance().getUserForSession(sessID);
            i = 0;
            while (i < processedVCFs.length) {
                final File vcfFile = processedVCFs[i];
                final int fileIndex = i++;
                MedSavantServerJob msj = new MedSavantServerJob(username, "Phasing", parentJob){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean run() throws Exception {
                        LOG.info((Object)("\tPhasing " + vcfFile.getAbsolutePath()));
                        File phasingWorkDir = null;
                        try {
                            phasingWorkDir = new File(workingDirectory, "phasing_" + fileIndex);
                            if (!phasingWorkDir.exists() && !phasingWorkDir.mkdirs()) {
                                throw new IOException("Could not create working phasing directory " + phasingWorkDir.getAbsolutePath());
                            }
                            LOG.info((Object)("\tInitiating phasing on " + vcfFile.getAbsolutePath()));
                            BEAGLEWrapper bw = new BEAGLEWrapper(phasingWorkDir, vcfFile, 1);
                            LOG.info((Object)"\tCalling bw.run");
                            File f = bw.run();
                            LOG.info((Object)("\tRun returned with " + (f != null ? f.getAbsolutePath() : "NULL")));
                            File dst = new File(workingDirectory, f.getName());
                            if (!IOUtils.moveFile(f, dst)) {
                                throw new IOException("Couldn't move phased file " + f.getCanonicalPath());
                            }
                            phasedFiles[fileIndex] = dst;
                        }
                        catch (IllegalArgumentException iae) {
                            if (iae.getMessage().contains("invalid allele")) {
                                LOG.error((Object)("Skipping phasing for " + vcfFile.getCanonicalPath() + ", possibly because it contains structural variants.  exception: " + iae.getMessage()));
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Skipping phasing for " + vcfFile.getCanonicalPath() + " due to unexpected exception"), (Throwable)ex);
                        }
                        finally {
                            if (phasingWorkDir.exists()) {
                                LOG.info((Object)("\tDelete phasing directory " + phasingWorkDir.getAbsolutePath()));
                                IOUtils.deleteDirectory(phasingWorkDir);
                            }
                            if (phasedFiles[fileIndex] == null) {
                                LOG.info((Object)("Phasing for file " + vcfFile.getAbsolutePath() + " was skipped."));
                                phasedFiles[fileIndex] = vcfFile;
                            }
                        }
                        LOG.info((Object)("\tPhasing " + vcfFile.getAbsolutePath() + " complete."));
                        return true;
                    }
                };
                MedSavantServerEngine.submitLongJob(msj).get();
            }
            processedVCFs = phasedFiles;
            LOG.info((Object)"Phasing complete.");
        }
        for (File f : processedVCFs) {
            LOG.info((Object)("Got processed VCF " + f.getAbsolutePath() + " and exists=" + f.exists()));
        }
        parentJob.getJobProgress().setMessage("Parsing VCFs.");
        ArrayList<MedSavantServerJob> threads = new ArrayList<MedSavantServerJob>(vcfFiles.length);
        String stamp = System.nanoTime() + "";
        for (int i2 = 0; i2 < processedVCFs.length; ++i2) {
            File vcfFile = processedVCFs[i2];
            File originalVCF = vcfFiles[i2];
            int fileID = VariantManager.addEntryToFileTable(sessID, updateID, projectID, referenceID, originalVCF);
            File outFile = new File(outDir, "tmp_" + stamp + "_" + fileID + ".tdf");
            threads.add(new VariantParser(sessID, parentJob, vcfFile, outFile, updateID, fileID, includeHomozygousReferenceCalls));
            ++fileID;
            LOG.info((Object)("Queueing thread to parse " + vcfFile.getAbsolutePath()));
        }
        MedSavantServerEngine.submitLongJobs(threads);
        TSVFile[] tsvFiles = new TSVFile[threads.size()];
        LOG.info((Object)"All parsing annotation threads done");
        i = 0;
        for (MedSavantServerJob msg : threads) {
            VariantParser t = (VariantParser)msg;
            tsvFiles[i++] = new TSVFile(new File(t.getOutputFilePath()), t.getNumVariants());
            if (t.didSucceed()) continue;
            LOG.info((Object)"At least one parser thread errored out");
            LOG.error((Object)("At least one parser thread (" + t.getVCF().getAbsolutePath() + ") errored out"), (Throwable)t.getException());
            t.getException().printStackTrace();
            throw t.getException();
        }
        return tsvFiles;
    }

    private static TSVFile doDumpTableAsTSV(String sessionID, String tableName, File workingDir) throws SQLException, IOException, InterruptedException, SessionExpiredException {
        LOG.info((Object)("Dumping existing table to file, working directory is " + workingDir.getAbsolutePath()));
        File outfile = new File(workingDir, tableName + ".dump");
        VariantManagerUtils.variantTableToTSVFile(sessionID, tableName, outfile);
        int nv = VariantManager.getInstance().getNumFilteredVariantsHelper(sessionID, tableName, new Condition[][]{{Condition.EMPTY}});
        return new TSVFile(outfile, nv);
    }

    private static File createSubdir(File parent, String child) throws IOException, InterruptedException {
        File dir = new File(parent, child);
        dir.mkdirs();
        Process p = Runtime.getRuntime().exec("chmod -R a+wx " + dir);
        p.waitFor();
        return dir;
    }

    private static File[] splitFilesByDNAAndFileID(TSVFile[] tsvFiles, File workingDir) throws FileNotFoundException, IOException {
        LOG.info((Object)("Splitting " + tsvFiles.length + " files by DNA and FileID, working directory is " + workingDir.getAbsolutePath()));
        Object[] splitTSVFiles = new File[]{};
        for (TSVFile file : tsvFiles) {
            Object[] someSplitFiles = VariantManagerUtils.splitTSVFileByFileAndDNAID(workingDir, file.getFile());
            splitTSVFiles = (File[])ArrayUtils.addAll((Object[])splitTSVFiles, (Object[])someSplitFiles);
        }
        return splitTSVFiles;
    }

    private static Annotation[] getAnnotationsFromIDs(int[] annotIDs, String sessID) throws RemoteException, SQLException, SessionExpiredException {
        int numAnnotations = annotIDs.length;
        Annotation[] annotations = new Annotation[numAnnotations];
        for (int i = 0; i < numAnnotations; ++i) {
            annotations[i] = AnnotationManager.getInstance().getAnnotation(sessID, annotIDs[i]);
            LOG.info((Object)("\t" + (i + 1) + ". " + annotations[i].getProgram() + " " + annotations[i].getReferenceName() + " " + annotations[i].getVersion()));
        }
        return annotations;
    }

    private static void createPatientsForUpdate(String sessionID, String tableName, int projectID, int updateID) throws RemoteException, SQLException, SessionExpiredException {
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessionID, tableName);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.setIsDistinct(true);
        query.addColumns(table.getDBColumn(BasicVariantColumns.DNA_ID.getColumnName()));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(BasicVariantColumns.UPLOAD_ID.getColumnName()), updateID));
        ArrayList<String> dnaIDs = new ArrayList<String>();
        LOG.info((Object)("Creating patient for update " + query.toString()));
        ResultSet rs = ConnectionController.executeQuery(sessionID, query.toString());
        while (rs.next()) {
            String dnaID = rs.getString(1);
            dnaIDs.add(dnaID);
        }
        rs.close();
        Map<String, String> dnaIDToHospitalIDMap = PatientManager.getInstance().getValuesFromDNAIDs(sessionID, projectID, BasicPatientColumns.HOSPITAL_ID.getColumnName(), dnaIDs);
        LOG.info((Object)"Getting orphaned DNA IDs");
        for (String dnaID : dnaIDs) {
            if (dnaIDToHospitalIDMap.containsKey(dnaID)) {
                LOG.info((Object)("Already a patient with DNA ID: " + dnaID));
                continue;
            }
            LOG.info((Object)("No patient with DNA ID " + dnaID + ", creating one"));
            ArrayList<CustomField> patientFields = new ArrayList<CustomField>();
            ArrayList<String> fieldValues = new ArrayList<String>();
            patientFields.add(PatientManager.HOSPITAL_ID);
            fieldValues.add(dnaID);
            patientFields.add(PatientManager.DNA_IDS);
            fieldValues.add(dnaID);
            PatientManager.getInstance().addPatient(sessionID, projectID, patientFields, fieldValues);
        }
    }

    private static TSVFile[] annotateTSVFiles(String sessionID, File[] tsvFiles, Annotation[] annotations, CustomField[] customFields, File createSubdir, MedSavantServerJob parentJob) throws Exception {
        return VariantManagerUtils.annotateTSVFiles(sessionID, tsvFiles, annotations, customFields, parentJob);
    }

    private static TSVFile[] annotateTSVFiles(String sessionID, int updateID, int projectID, int referenceID, int[] annotationIDs, CustomField[] customFields, TSVFile[] tsvFiles, File workingDir, MedSavantServerJob parentJob) throws Exception {
        try {
            LogManager.getInstance().addServerLog(sessionID, LogManagerAdapter.LogType.INFO, "Annotating TSV files, working directory is " + workingDir.getAbsolutePath());
        }
        catch (RemoteException ex) {
        }
        catch (SessionExpiredException ex) {
            // empty catch block
        }
        LOG.info((Object)("Annotating TSV files, working directory is " + workingDir.getAbsolutePath()));
        File[] splitTSVFiles = null;
        try {
            TSVFile[] annotatedTSVFiles;
            Annotation[] annotations = ImportUpdateManager.getAnnotationsFromIDs(annotationIDs, sessionID);
            parentJob.getJobProgress().setMessage("Preparing variants for annotation");
            splitTSVFiles = ImportUpdateManager.splitFilesByDNAAndFileID(tsvFiles, ImportUpdateManager.createSubdir(workingDir, "split"));
            TSVFile[] tSVFileArray = annotatedTSVFiles = ImportUpdateManager.annotateTSVFiles(sessionID, splitTSVFiles, annotations, customFields, ImportUpdateManager.createSubdir(workingDir, "annotate"), parentJob);
            return tSVFileArray;
        }
        catch (Exception e) {
            AnnotationLogManager.getInstance().setAnnotationLogStatus(sessionID, updateID, AnnotationLog.Status.ERROR);
            throw e;
        }
        finally {
            if (splitTSVFiles == null) {
                for (File splitTSVFile : splitTSVFiles) {
                    if (!splitTSVFile.exists()) continue;
                    splitTSVFile.delete();
                }
            }
        }
    }

    private static void appendTSVFilesToVariantTable(String sessionID, int projectID, int referenceID, int updateID, TSVFile[] annotatedTSVFiles, String tableName) throws RemoteException, SessionExpiredException, SQLException, IOException, InterruptedException {
        try {
            LogManager.getInstance().addServerLog(sessionID, LogManagerAdapter.LogType.INFO, "Uploading " + annotatedTSVFiles.length + " TSV files");
        }
        catch (RemoteException ex) {
        }
        catch (SessionExpiredException ex) {
            // empty catch block
        }
        for (TSVFile af : annotatedTSVFiles) {
            LOG.info((Object)("Uploading " + af.getFile().getAbsolutePath() + "..."));
            VariantManagerUtils.uploadTSVFileToVariantTable(sessionID, af.getFile(), tableName);
        }
        ImportUpdateManager.setAnnotationStatus(sessionID, updateID, AnnotationLog.Status.PENDING);
    }
}

