/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.util;

import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.IOUtils;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;

public class TabixTableLoader {
    private final DbTable table;

    public TabixTableLoader(DbTable t) {
        this.table = t;
    }

    public void loadGenes(String sessID, URI uri, String genome, String type, String ... colNames) throws IOException, SQLException, SessionExpiredException {
        BlockCompressedInputStream input = null;
        Connection conn = null;
        int lineNum = 1;
        try {
            String line;
            input = new BlockCompressedInputStream(NetworkUtils.getSeekableStreamForURI(uri));
            conn = ConnectionController.connectPooled(sessID);
            conn.setAutoCommit(false);
            InsertQuery query = new InsertQuery(this.table);
            query.addColumn(this.table.findColumn("genome"), genome);
            query.addColumn(this.table.findColumn("type"), type);
            ArrayList<DbColumn> dataCols = new ArrayList<DbColumn>(colNames.length);
            for (String colName : colNames) {
                if (colName == null) continue;
                dataCols.add(this.table.findColumn(colName));
            }
            query.addPreparedColumnCollection(dataCols);
            PreparedStatement prep = conn.prepareStatement(query.toString());
            boolean trace = true;
            while ((line = IOUtils.readLine((InputStream)input)) != null) {
                if (line.charAt(0) != '#') {
                    String[] fields = line.split("\t");
                    prep.clearParameters();
                    int j = 0;
                    for (int i = 0; i < colNames.length; ++i) {
                        if (colNames[i] == null) continue;
                        prep.setObject(++j, fields[i]);
                        if (!trace) continue;
                    }
                    prep.executeUpdate();
                    trace = false;
                }
                ++lineNum;
            }
        }
        catch (IOException x) {
            throw x;
        }
        catch (SQLException x) {
            System.out.println("Error at Tabix line " + lineNum);
            throw x;
        }
        finally {
            if (conn != null) {
                conn.setAutoCommit(true);
                conn.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }
}

