/*
 * Decompiled with CFR 0.152.
 */
package jannovar.interval;

import jannovar.interval.Interval;
import jannovar.interval.LeftComparator;
import jannovar.interval.Node;
import jannovar.interval.RightComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IntervalTree<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Node<T> root;
    private List<Interval<T>> intervals;
    private LeftComparator leftcomp = null;
    private RightComparator rightcomp = null;
    private Interval<T> leftNeighbor = null;
    private Interval<T> rightNeighbor = null;

    private IntervalTree() {
    }

    public IntervalTree(List<Interval<T>> intervals) {
        this.initializeComparators();
        this.root = new Node<T>(intervals, this.leftcomp, this.rightcomp);
        this.intervals = intervals;
    }

    private void initializeComparators() {
        if (this.leftcomp == null) {
            this.leftcomp = new LeftComparator();
        }
        if (this.rightcomp == null) {
            this.rightcomp = new RightComparator();
        }
    }

    public ArrayList<T> search(int low, int high) {
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        this.leftNeighbor = null;
        this.rightNeighbor = null;
        this.searchInterval(this.root, result, low, high);
        ArrayList<T> obtlst = new ArrayList<T>();
        for (Interval<T> it : result) {
            obtlst.add(it.getValue());
        }
        if (obtlst.isEmpty()) {
            this.searchInbetween(low);
        }
        return obtlst;
    }

    public T getRightNeighbor() {
        if (this.rightNeighbor == null) {
            return null;
        }
        return this.rightNeighbor.getValue();
    }

    public T getLeftNeighbor() {
        if (this.leftNeighbor == null) {
            return null;
        }
        return this.leftNeighbor.getValue();
    }

    private void switchLeftNeighborIfBetter(Interval<T> item, int x) {
        if (item == null) {
            return;
        }
        if (this.leftNeighbor == null) {
            this.leftNeighbor = item;
            return;
        }
        if (item.getHigh() >= x) {
            return;
        }
        if (item.getHigh() > this.leftNeighbor.getHigh()) {
            this.leftNeighbor = item;
        }
    }

    private void switchRightNeighborIfBetter(Interval<T> item, int x) {
        if (item == null) {
            return;
        }
        if (this.rightNeighbor == null) {
            this.rightNeighbor = item;
            return;
        }
        if (item.getLow() <= x) {
            return;
        }
        if (item.getLow() < this.rightNeighbor.getLow()) {
            this.rightNeighbor = item;
        }
    }

    private void searchInbetween(int x) {
        Node<T> n = this.root;
        while (n != null) {
            Interval<T> item;
            Node<T> rd;
            Interval<T> item2;
            if (x < n.getMedian()) {
                if (n.hasInterval()) {
                    item2 = n.getLeftmostItem();
                    this.switchRightNeighborIfBetter(item2, x);
                } else {
                    rd = n.getLeftmostDescendentOfRightChild();
                    item = rd.getLeftmostItem();
                    this.switchRightNeighborIfBetter(item, x);
                }
                n = n.getLeft();
                continue;
            }
            if (n.hasInterval()) {
                item2 = n.getRightmostItem();
                this.switchLeftNeighborIfBetter(item2, x);
            } else {
                rd = n.getRightmostDescendentOfLeftChild();
                item = rd.getRightmostItem();
                this.switchLeftNeighborIfBetter(item, x);
            }
            n = n.getRight();
        }
    }

    private void searchInterval(Node<T> n, ArrayList<Interval<T>> result, int ilow, int ihigh) {
        if (n == null) {
            return;
        }
        if (ilow < n.getMedian()) {
            int size = n.leftorder.size();
            for (int i = 0; i < size && n.leftorder.get(i).getLow() <= ihigh; ++i) {
                result.add(n.leftorder.get(i));
            }
        } else if (ihigh > n.getMedian()) {
            int size = n.rightorder.size();
            for (int i = 0; i < size && n.rightorder.get(i).getHigh() >= ilow; ++i) {
                result.add(n.rightorder.get(i));
            }
        }
        if (ilow < n.getMedian() && n.getLeft() != null) {
            this.searchInterval(n.getLeft(), result, ilow, ihigh);
        }
        if (ihigh > n.getMedian() && n.getRight() != null) {
            this.searchInterval(n.getRight(), result, ilow, ihigh);
        }
    }

    public void debugPrint(Node<T> n) {
        System.out.println("IntervalTree<T> starting at  " + n.toString());
        n.debugPrint(null, 0);
        System.out.println("LeftNeighbor:" + this.leftNeighbor);
        System.out.println("RightNeighbor:" + this.rightNeighbor);
    }

    public void debugPrint() {
        this.debugPrint(this.root);
    }
}

