/*
 * Decompiled with CFR 0.152.
 */
package jannovar.gff;

import jannovar.common.FeatureType;
import java.util.HashMap;

public class Feature {
    String sequence_id;
    String source;
    FeatureType type;
    int start;
    int end;
    double score;
    boolean strand;
    byte phase;
    HashMap<String, String> attributes = new HashMap();

    public String getSequence_id() {
        return this.sequence_id;
    }

    public String getSource() {
        return this.source;
    }

    public FeatureType getType() {
        return this.type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double getScore() {
        return this.score;
    }

    public boolean isStrand() {
        return this.strand;
    }

    public boolean getStrand() {
        return this.strand;
    }

    public short getPhase() {
        return this.phase;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setSequence_id(String sequence_id) {
        this.sequence_id = sequence_id;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setType(FeatureType type) {
        this.type = type;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setStrand(boolean strand) {
        this.strand = strand;
    }

    public void setPhase(byte phase) {
        this.phase = phase;
    }

    public void setAttributes(HashMap<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String id, String value) {
        if (this.attributes.containsKey(id)) {
            value = this.attributes.get(id) + "," + value;
        }
        this.attributes.put(id, value);
    }

    public String getAttribute(String id) {
        return this.attributes.get(id);
    }

    public String toString() {
        return "Feature [sequence_id=" + this.sequence_id + ", source=" + this.source + ", type=" + (Object)((Object)this.type) + ", start=" + this.start + ", end=" + this.end + ", score=" + this.score + ", strand=" + this.strand + ", phase=" + this.phase + ", attributes=" + this.attributes + "]";
    }

    public String toLine() {
        boolean wroteFirst = false;
        StringBuffer buffy = new StringBuffer();
        buffy.append(this.sequence_id).append("\t");
        buffy.append(this.source).append("\t");
        buffy.append(FeatureType.toString(this.type)).append("\t");
        buffy.append(this.start).append("\t");
        buffy.append(this.end).append("\t");
        buffy.append(this.score != 0.0 ? Double.valueOf(this.score) : ".").append("\t");
        buffy.append(this.strand ? "+" : "-").append("\t");
        buffy.append(this.phase > -1 ? Byte.valueOf(this.phase) : ".").append("\t");
        for (String key : this.attributes.keySet()) {
            if (wroteFirst) {
                buffy.append(";");
            }
            buffy.append(key).append("=").append(this.attributes.get(key));
            wroteFirst = true;
        }
        return buffy.toString();
    }
}

