/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.reference.TranscriptModel;

public class IntronicAnnotation {
    public static Annotation createIntronicAnnotation(TranscriptModel trmdl, int k, int start, int end, String ref, String alt) {
        String annot;
        int distR;
        int distL;
        String prefix = "";
        String code = "c";
        if (trmdl.isNonCodingGene()) {
            code = "n";
        }
        if (trmdl.isPlusStrand()) {
            if (start < trmdl.getCDSStart()) {
                prefix = "-";
            }
            if (start > trmdl.getCDSEnd()) {
                prefix = "*";
            }
            if ((distL = start - trmdl.getExonEnd(k - 1)) <= (distR = trmdl.getExonStart(k) - end)) {
                int posToCDS;
                if (trmdl.isNonCodingGene()) {
                    posToCDS = trmdl.getDistanceToFivePrimeTerminuscDNA(trmdl.getExonEnd(k - 1));
                    prefix = "";
                } else {
                    posToCDS = start > trmdl.getCDSEnd() ? trmdl.getDistanceToCDSend(trmdl.getExonEnd(k - 1)) : trmdl.getDistanceToCDSstart(trmdl.getExonEnd(k - 1));
                }
                annot = String.format("%s:intron%d:%s.%s%d+%d%s>%s", trmdl.getAccessionNumber(), k, code, prefix, posToCDS, distL, ref, alt);
            } else {
                int posToCDS;
                if (trmdl.isNonCodingGene()) {
                    posToCDS = trmdl.getDistanceToFivePrimeTerminuscDNA(trmdl.getExonStart(k));
                    prefix = "";
                } else {
                    posToCDS = start > trmdl.getCDSEnd() ? trmdl.getDistanceToCDSend(trmdl.getExonStart(k)) : trmdl.getDistanceToCDSstart(trmdl.getExonStart(k));
                }
                annot = String.format("%s:intron%d:%s.%s%d-%d%s>%s", trmdl.getAccessionNumber(), k, code, prefix, posToCDS, distR, ref, alt);
            }
        } else {
            if (start > trmdl.getCDSEnd()) {
                prefix = "-";
            }
            if (end < trmdl.getCDSStart()) {
                prefix = "*";
            }
            if ((distL = trmdl.getExonStart(k + 1) - end) <= (distR = start - trmdl.getExonEnd(k))) {
                int posToCDS;
                if (trmdl.isNonCodingGene()) {
                    posToCDS = trmdl.getDistanceToFivePrimeTerminuscDNA(trmdl.getExonStart(k + 1));
                    prefix = "";
                } else {
                    posToCDS = end < trmdl.getCDSStart() ? trmdl.getDistanceToCDSend(trmdl.getExonStart(k + 1)) : trmdl.getDistanceToCDSstart(trmdl.getExonStart(k + 1));
                }
                annot = String.format("%s:intron%d:%s.%s%d+%d%s>%s", trmdl.getAccessionNumber(), trmdl.getExonCount() - k - 1, code, prefix, posToCDS, distL, ref, alt);
            } else {
                int posToCDS;
                if (trmdl.isNonCodingGene()) {
                    posToCDS = trmdl.getDistanceToFivePrimeTerminuscDNA(trmdl.getExonEnd(k));
                    prefix = "";
                } else {
                    posToCDS = end < trmdl.getCDSStart() ? trmdl.getDistanceToCDSend(trmdl.getExonEnd(k)) : trmdl.getDistanceToCDSstart(trmdl.getExonEnd(k));
                }
                annot = String.format("%s:intron%d:%s.%s%d-%d%s>%s", trmdl.getAccessionNumber(), trmdl.getExonCount() - k - 1, code, prefix, posToCDS, distR, ref, alt);
            }
        }
        int m = Math.min(distR, distL);
        Annotation ann = new Annotation(trmdl, annot, VariantType.INTRONIC);
        ann.setDistanceToNearestExon(m);
        return ann;
    }

    public static Annotation createNcRNAIntronicAnnotation(TranscriptModel trmdl, int k, int start, int end, String ref, String alt) {
        Annotation ann = IntronicAnnotation.createIntronicAnnotation(trmdl, k, start, end, ref, alt);
        ann.setVarType(VariantType.ncRNA_INTRONIC);
        return ann;
    }
}

