/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import jannovar.exception.JannovarException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.LockController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.db.util.DBSettings;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.server.db.variants.ImportUpdateManager;
import org.ut.biolab.medsavant.server.log.EmailLogger;
import org.ut.biolab.medsavant.server.ontology.OntologyManager;
import org.ut.biolab.medsavant.server.serverapi.AnnotationLogManager;
import org.ut.biolab.medsavant.server.serverapi.AnnotationManager;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.server.serverapi.NetworkManager;
import org.ut.biolab.medsavant.server.serverapi.PatientManager;
import org.ut.biolab.medsavant.server.serverapi.ProjectManager;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.AnnotationLog;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.ScatterChartEntry;
import org.ut.biolab.medsavant.shared.model.ScatterChartMap;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.SimplePatient;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;
import org.ut.biolab.medsavant.shared.model.UserComment;
import org.ut.biolab.medsavant.shared.model.UserCommentGroup;
import org.ut.biolab.medsavant.shared.model.VariantComment;
import org.ut.biolab.medsavant.shared.model.exception.LockException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.VariantManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.IOUtils;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class VariantManager
extends MedSavantServerUnicastRemoteObject
implements VariantManagerAdapter,
BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(VariantManager.class);
    private static final int APPROX_MAX_SUBSET_SIZE = 1000000;
    private static final int COUNT_ESTIMATE_THRESHOLD = 1000;
    private static final int BIN_TOTAL_THRESHOLD = 1000000;
    private static final int PATIENT_HEATMAP_THRESHOLD = 1000;
    private static VariantManager instance;
    public static boolean REMOVE_WORKING_DIR;

    private VariantManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized VariantManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new VariantManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishVariants(String sessID, int projectID) throws Exception, LockException {
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(sessID), projectID);
        String database = SessionManager.getInstance().getDatabaseForSession(sessID);
        LOG.info((Object)("Beginning publish of all tables for project " + projectID));
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            LOG.info((Object)"Getting map of update ids");
            int[] refIDs = ProjectManager.getInstance().getReferenceIDsForProject(sessID, projectID);
            HashMap<Integer, Integer> ref2Update = new HashMap<Integer, Integer>();
            for (int refID : refIDs) {
                ref2Update.put(refID, ProjectManager.getInstance().getNewestUpdateID(sessID, projectID, refID, false));
                ProjectManager.getInstance().publishVariantTable(sessID, conn, projectID, refID);
            }
            LOG.info((Object)"Setting log status to published");
            Object object = ref2Update.keySet().iterator();
            while (object.hasNext()) {
                Integer refId = (Integer)object.next();
                AnnotationLogManager.getInstance().setAnnotationLogStatus(sessID, (Integer)ref2Update.get(refId), AnnotationLog.Status.PUBLISHED);
            }
            LOG.info((Object)"Publishing tables");
            ProjectManager.getInstance().publishVariantTable(sessID, conn, projectID, refIDs);
            LOG.info((Object)"Terminating active sessions");
            SessionManager.getInstance().terminateSessionsForDatabase(SessionManager.getInstance().getDatabaseForSession(sessID), "Administrator (" + SessionManager.getInstance().getUserForSession(sessID) + ") published new variants");
            LogManager.getInstance().addServerLog(sessID, LogManagerAdapter.LogType.INFO, "Published " + ProjectManager.getInstance().getProjectName(sessID, projectID));
            LOG.info((Object)"Publish complete");
        }
        finally {
            conn.close();
            LockController.getInstance().releaseLock(database, projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishVariants(String sessID, int projID, int refID) throws Exception, LockException {
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(sessID), projID);
        String database = SessionManager.getInstance().getDatabaseForSession(sessID);
        LOG.info((Object)("Publishing table. pid:" + projID + " refid:" + refID));
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            LOG.info((Object)"Setting log status to published");
            AnnotationLogManager.getInstance().setAnnotationLogStatus(sessID, refID, AnnotationLog.Status.PUBLISHED);
            LOG.info((Object)"Terminating active sessions");
            ProjectManager.getInstance().publishVariantTable(sessID, conn, projID, refID);
            LOG.info((Object)"Publish complete");
            SessionManager.getInstance().terminateSessionsForDatabase(SessionManager.getInstance().getDatabaseForSession(sessID), "Administrator (" + SessionManager.getInstance().getUserForSession(sessID) + ") published new variants");
            LOG.info((Object)"Publishing table");
            LogManager.getInstance().addServerLog(sessID, LogManagerAdapter.LogType.INFO, "Published " + ProjectManager.getInstance().getProjectName(sessID, projID));
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            ex.printStackTrace();
        }
        finally {
            conn.close();
            LockController.getInstance().releaseLock(database, projID);
        }
    }

    @Override
    @Deprecated
    public void publishVariants(String sessID, int projID, int refID, int updID) throws Exception, LockException {
        this.publishVariants(sessID, projID, refID);
    }

    @Override
    @Deprecated
    public void cancelPublish(String sid, int projectID, int referenceID, int updateID) throws Exception, LockException {
        String database = SessionManager.getInstance().getDatabaseForSession(sid);
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(sid), projectID);
        LOG.info((Object)("Cancelling publish. pid:" + projectID + " refid:" + referenceID));
        ProjectManager.getInstance().cancelPublish(sid, projectID, referenceID);
        LOG.info((Object)"Cancel complete");
        LockController.getInstance().releaseLock(database, projectID);
        LogManager.getInstance().addServerLog(sid, LogManagerAdapter.LogType.INFO, "Cancelled publish of " + ProjectManager.getInstance().getProjectName(sid, projectID));
    }

    @Override
    public int updateTable(String userSessionID, int projID, int refID, int[] annotIDs, CustomField[] customFields, boolean autoPublish, String email) throws Exception, LockException {
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(userSessionID), projID);
        String database = SessionManager.getInstance().getDatabaseForSession(userSessionID);
        String backgroundSessionID = SessionManager.getInstance().createBackgroundSessionFromSession(userSessionID);
        try {
            EmailLogger.logByEmail("Update started", "Update started. " + annotIDs.length + " annotation(s) will be performed. You will be notified again upon completion.", email);
            int updateID = ImportUpdateManager.doUpdate(backgroundSessionID, projID, refID, annotIDs, customFields, autoPublish);
            EmailLogger.logByEmail("Update finished", "Update completed. " + annotIDs.length + " annotation(s) were performed.", email);
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.INFO, "Done updating " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projID));
            int n = updateID;
            return n;
        }
        catch (Exception e) {
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.ERROR, "Update failed for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projID) + ". " + e.getLocalizedMessage());
            EmailLogger.logByEmail("Update failed", "Update failed with error: " + MiscUtils.getStackTrace(e), email);
            LOG.error((Object)e);
            throw e;
        }
        finally {
            LockController.getInstance().releaseLock(database, projID);
            SessionManager.getInstance().unregisterSession(backgroundSessionID);
        }
    }

    @Override
    public int uploadTransferredVariants(String userSessionID, int[] transferIDs, int projID, int refID, String[][] tags, boolean includeHomoRef, String email, boolean autoPublish, boolean preAnnotateWithAnnovar, boolean doPhasing) throws Exception, LockException {
        return this.uploadVariants(userSessionID, transferIDs, projID, refID, tags, includeHomoRef, email, autoPublish, preAnnotateWithAnnovar, doPhasing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int uploadVariants(String userSessionID, int[] transferIDs, int projID, int refID, String[][] tags, boolean includeHomoRef, String email, boolean autoPublish, boolean preAnnotateWithAnnovar, boolean doPhasing) throws Exception, LockException {
        if (ProjectManager.getInstance().hasUnpublishedChanges(userSessionID, projID, refID)) {
            throw new IllegalArgumentException("Can't import variants for this project and reference until unpublished changes are published.");
        }
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(userSessionID), projID);
        String database = SessionManager.getInstance().getDatabaseForSession(userSessionID);
        String backgroundSessionID = SessionManager.getInstance().createBackgroundSessionFromSession(userSessionID);
        try {
            LOG.info((Object)"Importing variants by transferring from client");
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.INFO, "Started upload of variants for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projID));
            NetworkManager netMgr = NetworkManager.getInstance();
            File[] vcfFiles = new File[transferIDs.length];
            String[] sourceNames = new String[transferIDs.length];
            int i = 0;
            for (int id : transferIDs) {
                vcfFiles[i] = netMgr.getFileByTransferID(userSessionID, id);
                sourceNames[i] = netMgr.getSourceNameByTransferID(userSessionID, id);
                ++i;
            }
            int n = this.uploadVariants(backgroundSessionID, vcfFiles, sourceNames, projID, refID, tags, includeHomoRef, email, autoPublish, preAnnotateWithAnnovar, doPhasing);
            return n;
        }
        finally {
            LockController.getInstance().releaseLock(database, projID);
            SessionManager.getInstance().unregisterSession(backgroundSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int uploadVariants(String userSessionID, File dirContainingVCFs, int projID, int refID, String[][] tags, boolean includeHomoRef, String email, boolean autoPublish, boolean preAnnotateWithAnnovar, boolean doPhasing) throws RemoteException, SessionExpiredException, IOException, Exception, LockException {
        if (ProjectManager.getInstance().hasUnpublishedChanges(userSessionID, projID, refID)) {
            throw new IllegalArgumentException("Can't import variants for this project and reference until unpublished changes are published.");
        }
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(userSessionID), projID);
        String database = SessionManager.getInstance().getDatabaseForSession(userSessionID);
        String backgroundSessionID = SessionManager.getInstance().createBackgroundSessionFromSession(userSessionID);
        try {
            LOG.info((Object)("Importing variants already stored on server in dir " + dirContainingVCFs.getAbsolutePath()));
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.INFO, "Started upload of variants for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projID));
            if (!dirContainingVCFs.exists()) {
                LOG.info((Object)"Directory from which to load variants does not exist, bailing out.");
                int n = -1;
                return n;
            }
            File[] vcfFiles = dirContainingVCFs.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName();
                    return name.endsWith(".vcf") || name.endsWith(".vcf.gz") || name.endsWith(".vcf.bz2") || name.endsWith(".tgz");
                }
            });
            if (vcfFiles.length == 0) {
                LOG.info((Object)"Directory exists but contains no .vcf or .vcf.gz files.");
                throw new IllegalArgumentException("Directory on server exists, but does not contain any recognized file types");
            }
            int n = this.uploadVariants(backgroundSessionID, vcfFiles, null, projID, refID, tags, includeHomoRef, email, autoPublish, preAnnotateWithAnnovar, doPhasing);
            return n;
        }
        finally {
            LockController.getInstance().releaseLock(database, projID);
            SessionManager.getInstance().unregisterSession(backgroundSessionID);
        }
    }

    private boolean isVCF41File(File f) {
        return f.getName().toLowerCase().endsWith(".vcf");
    }

    public static File getVCFDestinationDir(String database, int projectID) {
        File gd = DirectorySettings.getGenoTypeDirectory(database, projectID);
        return gd;
    }

    public static File getVCFDestination(File inputFile, String database, int projectID) {
        File gd = VariantManager.getVCFDestinationDir(database, projectID);
        File dest = new File(gd, inputFile.getName());
        int prefix = 0;
        while (dest.exists()) {
            dest = new File(gd, prefix + "_" + inputFile.getName());
            ++prefix;
        }
        return dest;
    }

    private int uploadVariants(String userSessionID, File[] inputFiles, String[] sourceNames, int projectID, int referenceID, String[][] tags, boolean includeHomoRef, String email, boolean autoPublish, boolean preAnnotateWithJannovar, boolean doPhasing) throws Exception, LockException {
        LockController.getInstance().requestLock(SessionManager.getInstance().getDatabaseForSession(userSessionID), projectID);
        String database = SessionManager.getInstance().getDatabaseForSession(userSessionID);
        String backgroundSessionID = SessionManager.getInstance().createBackgroundSessionFromSession(userSessionID);
        try {
            ArrayList<File> vcfFileList = new ArrayList<File>(inputFiles.length);
            for (File inputFile : inputFiles) {
                if (this.isVCF41File(inputFile)) {
                    if (IOUtils.isInDirectory(inputFile, DirectorySettings.getTmpDirectory())) {
                        File dest = VariantManager.getVCFDestination(inputFile, database, projectID);
                        if (!IOUtils.moveFile(inputFile, dest)) {
                            throw new IOException("Cannot move VCF file to genotype storage.");
                        }
                        LOG.info((Object)("Moved input VCF " + inputFile + " to " + dest));
                        inputFile = dest;
                    } else {
                        LOG.info((Object)("VCF file " + inputFile + " was not found in server tmp directory -- keeping it where it is."));
                    }
                    vcfFileList.add(inputFile);
                    continue;
                }
                int i = 0;
                File outputDir = new File(inputFile.getParent() + File.separator + inputFile.getName() + "_extracted_" + i);
                while (outputDir.exists()) {
                    LOG.error((Object)("Unzip destination directory " + outputDir + " already exists, trying new directory name..."));
                    outputDir = new File(inputFile.getParent() + File.separator + inputFile.getName() + "_extracted_" + ++i);
                }
                if (!outputDir.mkdirs()) {
                    throw new IOException("Cannot make target directory " + outputDir);
                }
                List<File> files = IOUtils.decompressAndDelete(inputFile, outputDir);
                for (File putativeVCF : files) {
                    if (this.isVCF41File(putativeVCF)) {
                        File dest = VariantManager.getVCFDestination(putativeVCF, database, projectID);
                        if (!IOUtils.moveFile(putativeVCF, dest)) {
                            throw new IOException("Cannot move VCF file in compressed file to genotype storage.");
                        }
                        LOG.info((Object)("Moved input VCF " + putativeVCF + " contained in compressed file to " + dest));
                        putativeVCF = dest;
                        vcfFileList.add(putativeVCF);
                        continue;
                    }
                    LOG.error((Object)("Unrecognized file " + putativeVCF + " -- skipping"));
                    putativeVCF.delete();
                }
                outputDir.delete();
            }
            File[] vcfFiles = vcfFileList.toArray(new File[vcfFileList.size()]);
            EmailLogger.logByEmail("Upload started", "Upload started. " + vcfFiles.length + " file(s) will be imported. You will be notified again upon completion.", email);
            LogManager.getInstance().addServerLog(userSessionID, LogManagerAdapter.LogType.INFO, "Upload started. " + vcfFiles.length + " file(s) will be imported. You will be notified again upon completion.");
            int updateID = -1;
            updateID = ImportUpdateManager.doImport(backgroundSessionID, projectID, referenceID, vcfFiles, includeHomoRef, preAnnotateWithJannovar, doPhasing, tags);
            EmailLogger.logByEmail("Upload finished", "Upload completed. " + vcfFiles.length + " file(s) were imported.", email);
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.INFO, "Done uploading variants for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projectID));
            if (autoPublish) {
                LOG.info((Object)"Publishing");
                VariantManager.getInstance().publishVariants(backgroundSessionID, projectID);
            } else {
                LOG.info((Object)"Not publishing");
            }
            int n = updateID;
            return n;
        }
        catch (JannovarException je) {
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.ERROR, "Error uploading variants for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projectID) + ". " + je.getLocalizedMessage());
            EmailLogger.logByEmail("Upload failed", "Upload failed with error: " + MiscUtils.getStackTrace(je), email);
            LOG.error((Object)je);
            throw new IllegalArgumentException("Could not annotate variant file: " + je.getLocalizedMessage());
        }
        catch (Exception e) {
            LogManager.getInstance().addServerLog(backgroundSessionID, LogManagerAdapter.LogType.ERROR, "Error uploading variants for " + ProjectManager.getInstance().getProjectName(backgroundSessionID, projectID) + ". " + e.getLocalizedMessage());
            EmailLogger.logByEmail("Upload failed", "Upload failed with error: " + MiscUtils.getStackTrace(e), email);
            LOG.error((Object)"Could not annotate variant file: ", (Throwable)e);
            throw e;
        }
        finally {
            LockController.getInstance().releaseLock(database, projectID);
            SessionManager.getInstance().unregisterSession(backgroundSessionID);
        }
    }

    public static double getSubsetFraction(int nv) {
        if (nv > 1000000) {
            double fractionOfOriginalTable = 1000000.0 / (double)nv;
            return fractionOfOriginalTable;
        }
        return 1.0;
    }

    public static Condition getSubsetRestrictionCondition(int nv) {
        LOG.info((Object)("getting subset restriction condition for " + nv + " variants"));
        return BinaryCondition.lessThan(new FunctionCall(new CustomSql("RAND")), VariantManager.getSubsetFraction(nv), true);
    }

    @Override
    public int removeVariants(final String userSessionID, final int projID, final int refID, final List<SimpleVariantFile> files, final boolean autoPublish, final String email) throws Exception, LockException {
        LOG.info((Object)"Beginning removal of variants");
        if (ProjectManager.getInstance().hasUnpublishedChanges(userSessionID, projID, refID)) {
            throw new IllegalArgumentException("Can't remove variants for this project and reference until unpublished changes are published.");
        }
        final int[] returnVal = new int[]{1};
        MedSavantServerJob msj = new MedSavantServerJob(SessionManager.getInstance().getUserForSession(userSessionID), "Removing variants", null){

            @Override
            public boolean run() throws Exception {
                String database = SessionManager.getInstance().getDatabaseForSession(userSessionID);
                LockController.getInstance().requestLock(database, projID);
                LogManager.getInstance().addServerLog(userSessionID, LogManagerAdapter.LogType.INFO, "Removing " + files.size() + " files");
                int oldUpdateId = ProjectManager.getInstance().getNewestUpdateID(userSessionID, projID, refID, true);
                int updateId = AnnotationLogManager.getInstance().addAnnotationLogEntry(userSessionID, projID, refID, AnnotationLog.Action.REMOVE_VARIANTS);
                try {
                    LogManager.getInstance().addServerLog(userSessionID, LogManagerAdapter.LogType.INFO, "Removing variants from " + ProjectManager.getInstance().getProjectName(userSessionID, projID));
                    ProjectManager.getInstance().restorePublishedFileTable(userSessionID);
                    VariantManager.this.removeEntriesFromFileTable(userSessionID, files);
                    String viewName = DBSettings.getVariantViewName(projID, refID);
                    int numVariantsInFiles = VariantManager.this.countPublishedVariantsInFiles(userSessionID, projID, refID, files);
                    int numTotalVariants = VariantManager.this.getNumFilteredVariantsHelper(userSessionID, viewName, new Condition[0][]);
                    int numVariantsAfterDeletion = numTotalVariants - numVariantsInFiles;
                    int[] annIDs = AnnotationManager.getInstance().getAnnotationIDs(userSessionID, projID, refID);
                    CustomField[] customFields = ProjectManager.getInstance().getCustomVariantFields(userSessionID, projID, refID, oldUpdateId);
                    String newSubsetTableName = ProjectManager.getInstance().addVariantTableToDatabase(userSessionID, projID, refID, updateId, annIDs, customFields, true);
                    TableSchema viewSchema = CustomTables.getInstance().getCustomTableSchema(userSessionID, viewName);
                    Condition[] conditions = new Condition[files.size() + 1];
                    int i = 0;
                    for (SimpleVariantFile svf : files) {
                        conditions[i++] = BinaryCondition.notEqualTo(viewSchema.getDBColumn(BasicVariantColumns.FILE_ID), svf.getFileId());
                    }
                    conditions[i] = VariantManager.getSubsetRestrictionCondition(numVariantsAfterDeletion);
                    LOG.info((Object)("Creating new subset table called " + newSubsetTableName));
                    this.getJobProgress().setMessage("Creating new subset table...");
                    SelectQuery sq = new SelectQuery();
                    sq.addAllColumns();
                    sq.addFromTable(viewSchema.getTable());
                    sq.addCondition(ComboCondition.and(conditions));
                    DBUtils.copyQueryResultToNewTable(userSessionID, sq, newSubsetTableName);
                    AnnotationLogManager.getInstance().setAnnotationLogStatus(userSessionID, updateId, AnnotationLog.Status.PENDING);
                    ProjectManager.getInstance().setupTablesForVariantRemoval(userSessionID, projID, refID, updateId, newSubsetTableName);
                    CustomField[] cf = ProjectManager.getInstance().getCustomVariantFields(userSessionID, projID, refID, oldUpdateId);
                    if (cf != null) {
                        ProjectManager.getInstance().setCustomVariantFields(userSessionID, projID, refID, updateId, cf);
                    }
                    if (autoPublish) {
                        VariantManager.this.publishVariants(userSessionID, projID);
                        SessionManager.getInstance().unregisterSession(userSessionID);
                    }
                    LogManager.getInstance().addServerLog(userSessionID, LogManagerAdapter.LogType.INFO, "Done removing variants from " + ProjectManager.getInstance().getProjectName(userSessionID, projID));
                    returnVal[0] = updateId;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    LogManager.getInstance().addServerLog(userSessionID, LogManagerAdapter.LogType.ERROR, "Error removing variants from " + ProjectManager.getInstance().getProjectName(userSessionID, projID));
                    AnnotationLogManager.getInstance().setAnnotationLogStatus(userSessionID, updateId, AnnotationLog.Status.ERROR);
                    EmailLogger.logByEmail("Removal failed", "Removal failed with error: " + MiscUtils.getStackTrace(e), email);
                    throw e;
                }
                finally {
                    for (SimpleVariantFile svf : files) {
                        File f = new File(svf.getPath());
                        if (f.exists()) {
                            File p;
                            if (IOUtils.isInDirectory(f, DirectorySettings.getTmpDirectory())) {
                                p = f.getParentFile();
                                f.delete();
                                IOUtils.deleteEmptyParents(p, DirectorySettings.getTmpDirectory());
                                continue;
                            }
                            if (IOUtils.isInDirectory(f, DirectorySettings.getGenoTypeDirectory())) {
                                p = f.getParentFile();
                                f.delete();
                                IOUtils.deleteEmptyParents(p, DirectorySettings.getGenoTypeDirectory());
                                continue;
                            }
                            LOG.info((Object)("Not removing .vcf file " + svf.getPath() + " -- not in a MedSavant directory."));
                            continue;
                        }
                        LOG.info((Object)("Not removing .vcf file " + svf.getPath() + " -- does not exist on file system."));
                    }
                    LockController.getInstance().releaseLock(database, projID);
                }
            }
        };
        MedSavantServerEngine.runJobInCurrentThread(msj);
        return returnVal[0];
    }

    private int countPublishedVariantsInFiles(String sid, int projID, int refID, Collection<SimpleVariantFile> files) throws RemoteException, SQLException, SessionExpiredException {
        String viewName = DBSettings.getVariantViewName(projID, refID);
        TableSchema vtable = CustomTables.getInstance().getCustomTableSchema(sid, viewName);
        int i = 0;
        Condition[] conditions = new Condition[files.size()];
        for (SimpleVariantFile f : files) {
            conditions[i++] = BinaryConditionMS.equalTo(vtable.getDBColumn(BasicVariantColumns.FILE_ID), f.getFileId());
        }
        SelectQuery query = new SelectQuery();
        query.addFromTable(vtable.getTable());
        query.addCustomColumns(FunctionCall.countAll());
        this.addConditionsToQuery(query, new Condition[][]{{ComboCondition.or(conditions)}});
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        LOG.error((Object)("Couldn't count published variants, query: " + query.toString()));
        throw new SQLException("Couldn't count published variants");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportVariants(String userSessionID, int projID, int refID, Condition[][] conditions, boolean orderedByPosition, boolean zipOutputFile) throws SQLException, RemoteException, SessionExpiredException, IOException, InterruptedException {
        File file;
        block5: {
            String backgroundSessionID = SessionManager.getInstance().createBackgroundSessionFromSession(userSessionID);
            File baseDir = DirectorySettings.generateDateStampDirectory(DirectorySettings.getTmpDirectory());
            Process p = Runtime.getRuntime().exec("chmod -R o+w " + baseDir.getCanonicalPath());
            p.waitFor();
            String filename = ProjectManager.getInstance().getProjectName(backgroundSessionID, projID).replace(" ", "") + "-varexport-" + System.currentTimeMillis() + ".tdf";
            file = new File(baseDir, filename);
            File zipFile = null;
            try {
                LOG.info((Object)("Exporting variants to " + file.getAbsolutePath()));
                long start = System.currentTimeMillis();
                TableSchema table = CustomTables.getInstance().getCustomTableSchema(backgroundSessionID, ProjectManager.getInstance().getVariantTableName(backgroundSessionID, projID, refID, true));
                SelectQuery query = new SelectQuery();
                query.addFromTable(table.getTable());
                query.addAllColumns();
                this.addConditionsToQuery(query, conditions);
                if (orderedByPosition) {
                    query.addOrderings(table.getDBColumn(START_POSITION), table.getDBColumn(END_POSITION));
                }
                String intoString = "INTO OUTFILE \"" + file.getAbsolutePath().replaceAll("\\\\", "/") + "\" " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)"\t") + "' " + "ENCLOSED BY '" + "\"" + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)"\\") + "' ";
                String queryString = query.toString().replace("FROM", intoString + "FROM");
                LOG.info((Object)queryString);
                ConnectionController.executeQuery(backgroundSessionID, queryString);
                if (zipOutputFile) {
                    LOG.info((Object)"Zipping export...");
                    zipFile = new File(file.getAbsoluteFile() + ".zip");
                    IOUtils.zipFile(file, zipFile);
                }
                LOG.info((Object)("Done exporting variants to " + file.getAbsolutePath()));
                LOG.info((Object)("Export took " + (System.currentTimeMillis() - start) / 1000L + " seconds"));
                if (!zipOutputFile) break block5;
                boolean deleted = file.delete();
                LOG.info((Object)("Deleting " + file.getAbsolutePath() + " - " + (deleted ? "successful" : "failed")));
            }
            catch (Throwable throwable) {
                if (zipOutputFile) {
                    boolean deleted = file.delete();
                    LOG.info((Object)("Deleting " + file.getAbsolutePath() + " - " + (deleted ? "successful" : "failed")));
                    file = zipFile;
                    LOG.info((Object)"Done zipping");
                }
                throw throwable;
            }
            file = zipFile;
            LOG.info((Object)"Done zipping");
        }
        int fileID = NetworkManager.getInstance().openReaderOnServer(userSessionID, file);
        return fileID;
    }

    @Override
    public TableSchema getCustomTableSchema(String sessionId, int projectId, int referenceId) throws SQLException, RemoteException, SessionExpiredException {
        return CustomTables.getInstance().getCustomTableSchema(sessionId, ProjectManager.getInstance().getVariantTableName(sessionId, projectId, referenceId, true));
    }

    @Override
    public List<Object[]> getVariants(String sessionId, int projectId, int referenceId, int start, int limit) throws SQLException, RemoteException, SessionExpiredException {
        return this.getVariants(sessionId, projectId, referenceId, new Condition[1][], start, limit);
    }

    @Override
    public List<Object[]> getVariants(String sessionId, int projectId, int referenceId, Condition[][] conditions, int start, int limit) throws SQLException, RemoteException, SessionExpiredException {
        return this.getVariants(sessionId, projectId, referenceId, conditions, start, limit, null);
    }

    @Override
    public List<Object[]> getVariants(String sessionId, int projectId, int referenceId, Condition[][] conditions, int start, int limit, String[] orderByCols) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessionId, ProjectManager.getInstance().getVariantTableName(sessionId, projectId, referenceId, true));
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        this.addConditionsToQuery(query, conditions);
        if (orderByCols != null) {
            query.addCustomOrderings(orderByCols);
        }
        String queryString = query.toString();
        if (limit != -1) {
            queryString = start != -1 ? queryString + " LIMIT " + start + ", " + limit : queryString + " LIMIT " + limit;
        }
        LOG.info((Object)queryString);
        ResultSet rs = ConnectionController.executeQuery(sessionId, queryString);
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int numberColumns = rsMetaData.getColumnCount();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] v = new Object[numberColumns];
            for (int i = 1; i <= numberColumns; ++i) {
                v[i - 1] = rs.getObject(i);
            }
            result.add(v);
        }
        return result;
    }

    @Override
    public int getVariantCount(String sid, int projectId, int referenceId) throws SQLException, RemoteException, SessionExpiredException {
        return this.getFilteredVariantCount(sid, projectId, referenceId, new Condition[0][], true);
    }

    @Override
    public int getFilteredVariantCount(String sid, int projectId, int referenceId, Condition[][] conditions) throws SQLException, RemoteException, SessionExpiredException {
        return this.getFilteredVariantCount(sid, projectId, referenceId, conditions, false);
    }

    private int getFilteredVariantCount(String sid, int projectId, int referenceId, Condition[][] conditions, boolean forceExact) throws SQLException, RemoteException, SessionExpiredException {
        int estimate;
        Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sid, projectId, referenceId);
        String tableViewName = (String)variantTableInfo[0];
        String tablenameSub = (String)variantTableInfo[1];
        float subMultiplier = ((Float)variantTableInfo[2]).floatValue();
        if (tableViewName == null) {
            return -1;
        }
        if (tablenameSub != null && !forceExact && conditions.length > 0 && (estimate = (int)((float)this.getNumFilteredVariantsHelper(sid, tablenameSub, conditions) * subMultiplier)) >= 1000) {
            return estimate;
        }
        return this.getNumFilteredVariantsHelper(sid, tableViewName, conditions);
    }

    public int getNumFilteredVariantsHelper(String sessID, String tableViewName, Condition[][] conditions) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tableViewName);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns(FunctionCall.countAll());
        this.addConditionsToQuery(q, conditions);
        LOG.info((Object)q);
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        rs.next();
        LOG.info((Object)("Number of variants remaining: " + rs.getInt(1)));
        return rs.getInt(1);
    }

    @Override
    public int getVariantCountForDNAIDs(String sessID, int projID, int refID, Condition[][] conditions, Collection<String> dnaIDs) throws SQLException, RemoteException, SessionExpiredException {
        if (dnaIDs.isEmpty()) {
            return 0;
        }
        String name = ProjectManager.getInstance().getVariantTableName(sessID, projID, refID, true);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, name);
        InCondition dnaCondition = new InCondition((Object)table.getDBColumn(DNA_ID.getColumnName()), dnaIDs);
        Condition[] c1 = new Condition[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            c1[i] = ComboCondition.and(conditions[i]);
        }
        Condition[] finalCondition = new Condition[]{ComboCondition.and(dnaCondition, ComboCondition.or(c1))};
        return this.getFilteredVariantCount(sessID, projID, refID, new Condition[][]{finalCondition});
    }

    @Override
    public boolean willApproximateCountsForConditions(String sid, int projectId, int referenceId, Condition[][] conditions) throws SQLException, RemoteException, SessionExpiredException {
        int total = this.getFilteredVariantCount(sid, projectId, referenceId, conditions);
        return total >= 1000000;
    }

    @Override
    public Map<Range, Long> getFilteredFrequencyValuesForNumericColumn(String sid, int projectId, int referenceId, Condition[][] conditions, CustomField column, boolean logBins) throws InterruptedException, SQLException, RemoteException, SessionExpiredException {
        TableSchema table;
        int total = this.getFilteredVariantCount(sid, projectId, referenceId, conditions);
        Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sid, projectId, referenceId);
        String tablename = (String)variantTableInfo[0];
        String tablenameSub = (String)variantTableInfo[1];
        float multiplier = ((Float)variantTableInfo[2]).floatValue();
        if (total >= 1000000) {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablenameSub);
        } else {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
            multiplier = 1.0f;
        }
        Range range = DBUtils.getInstance().getExtremeValuesForColumn(sid, table.getTableName(), column.getColumnName());
        double binSize = MiscUtils.generateBins(column, range, logBins);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns(FunctionCall.countAll());
        this.addConditionsToQuery(q, conditions);
        String round = logBins ? "floor(log10(" + column.getColumnName() + ")) as m" : "floor(" + column.getColumnName() + " / " + binSize + ") as m";
        String query = q.toString().replace("COUNT(*)", "COUNT(*), " + round);
        query = query + " GROUP BY m ORDER BY m ASC";
        ResultSet rs = ConnectionController.executeQuery(sid, query);
        TreeMap<Range, Long> results = new TreeMap<Range, Long>();
        while (rs.next()) {
            int binNo = rs.getInt(2);
            Range r = logBins ? new Range(Math.pow(10.0, binNo), Math.pow(10.0, binNo + 1)) : new Range((double)binNo * binSize, (double)(binNo + 1) * binSize);
            long count = (long)((float)rs.getLong(1) * multiplier);
            results.put(r, count);
        }
        return results;
    }

    @Override
    public Map<String, Integer> getFilteredFrequencyValuesForCategoricalColumn(String sessID, int projID, int refID, Condition[][] conditions, String colName) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema table;
        int total = this.getFilteredVariantCount(sessID, projID, refID, conditions);
        Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sessID, projID, refID);
        String tablename = (String)variantTableInfo[0];
        String tablenameSub = (String)variantTableInfo[1];
        float multiplier = ((Float)variantTableInfo[2]).floatValue();
        if (total >= 1000000) {
            table = CustomTables.getInstance().getCustomTableSchema(sessID, tablenameSub);
        } else {
            table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
            multiplier = 1.0f;
        }
        DbColumn column = table.getDBColumn(colName);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addColumns(column);
        q.addCustomColumns(FunctionCall.countAll());
        this.addConditionsToQuery(q, conditions);
        q.addGroupings(column);
        if (column.getColumnNameSQL().equals(ALT.getColumnName()) || column.getColumnNameSQL().equals(REF.getColumnName())) {
            q.addCondition(this.createNucleotideCondition(column));
        }
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        while (rs.next()) {
            String key = rs.getString(1);
            if (key == null) {
                key = "";
            }
            map.put(key, (int)((float)rs.getInt(2) * multiplier));
        }
        return map;
    }

    @Override
    public ScatterChartMap getFilteredFrequencyValuesForScatter(String sid, int projectId, int referenceId, Condition[][] conditions, String columnnameX, String columnnameY, boolean columnXCategorical, boolean columnYCategorical, boolean sortKaryotypically) throws InterruptedException, SQLException, RemoteException, SessionExpiredException {
        TableSchema table;
        int total = this.getFilteredVariantCount(sid, projectId, referenceId, conditions);
        Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sid, projectId, referenceId);
        String tablename = (String)variantTableInfo[0];
        String tablenameSub = (String)variantTableInfo[1];
        float multiplier = ((Float)variantTableInfo[2]).floatValue();
        if (total >= 1000000) {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablenameSub);
        } else {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
            multiplier = 1.0f;
        }
        DbColumn columnX = table.getDBColumn(columnnameX);
        DbColumn columnY = table.getDBColumn(columnnameY);
        double binSizeX = 0.0;
        if (!columnXCategorical) {
            Range rangeX = DBUtils.getInstance().getExtremeValuesForColumn(sid, table.getTableName(), columnnameX);
            binSizeX = MiscUtils.generateBins(new CustomField(columnnameX, columnX.getTypeNameSQL() + "(" + columnX.getTypeLength() + ")", false, "", ""), rangeX, false);
        }
        double binSizeY = 0.0;
        if (!columnYCategorical) {
            Range rangeY = DBUtils.getInstance().getExtremeValuesForColumn(sid, table.getTableName(), columnnameY);
            binSizeY = MiscUtils.generateBins(new CustomField(columnnameY, columnY.getTypeNameSQL() + "(" + columnY.getTypeLength() + ")", false, "", ""), rangeY, false);
        }
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns(FunctionCall.countAll());
        this.addConditionsToQuery(q, conditions);
        if (columnnameX.equals(ALT.getColumnName()) || columnnameX.equals(REF.getColumnName())) {
            q.addCondition(this.createNucleotideCondition(columnX));
        }
        if (columnnameY.equals(ALT.getColumnName()) || columnnameY.equals(REF.getColumnName())) {
            q.addCondition(this.createNucleotideCondition(columnY));
        }
        String m = columnnameX + " as m";
        if (!columnXCategorical) {
            m = "floor(" + columnnameX + " / " + binSizeX + ") as m";
        }
        String n = columnnameY + " as n";
        if (!columnYCategorical) {
            n = "floor(" + columnnameY + " / " + binSizeY + ") as n";
        }
        String query = q.toString().replace("COUNT(*)", "COUNT(*), " + m + ", " + n);
        query = query + " GROUP BY m, n ORDER BY m, n ASC";
        ResultSet rs = ConnectionController.executeQuery(sid, query);
        ArrayList<ScatterChartEntry> entries = new ArrayList<ScatterChartEntry>();
        ArrayList<String> xRanges = new ArrayList<String>();
        ArrayList<String> yRanges = new ArrayList<String>();
        while (rs.next()) {
            String x = rs.getString(2);
            String y = rs.getString(3);
            if (x == null) {
                x = "null";
            }
            if (y == null) {
                y = "null";
            }
            if (!columnXCategorical) {
                x = MiscUtils.doubleToString((double)Integer.parseInt(x) * binSizeX, 2) + " - " + MiscUtils.doubleToString((double)Integer.parseInt(x) * binSizeX + binSizeX, 2);
            }
            if (!columnYCategorical) {
                y = MiscUtils.doubleToString((double)Integer.parseInt(y) * binSizeY, 2) + " - " + MiscUtils.doubleToString((double)Integer.parseInt(y) * binSizeY + binSizeY, 2);
            }
            ScatterChartEntry entry = new ScatterChartEntry(x, y, (int)((float)rs.getInt(1) * multiplier));
            entries.add(entry);
            if (!xRanges.contains(entry.getXRange())) {
                xRanges.add(entry.getXRange());
            }
            if (yRanges.contains(entry.getYRange())) continue;
            yRanges.add(entry.getYRange());
        }
        if (sortKaryotypically) {
            Collections.sort(xRanges, new ChromosomeComparator());
        } else if (columnXCategorical) {
            Collections.sort(xRanges);
        }
        if (columnYCategorical) {
            Collections.sort(yRanges);
        }
        return new ScatterChartMap(xRanges, yRanges, entries);
    }

    @Override
    public int getVariantCountInRange(String sid, int projectId, int referenceId, Condition[][] conditions, String chrom, long start, long end) throws SQLException, RemoteException, SessionExpiredException {
        String name = ProjectManager.getInstance().getVariantTableName(sid, projectId, referenceId, true);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, name);
        Condition[] rangeConditions = new Condition[]{BinaryCondition.equalTo(table.getDBColumn(CHROM), chrom), BinaryCondition.greaterThan(table.getDBColumn(START_POSITION), start, true), BinaryCondition.lessThan(table.getDBColumn(START_POSITION), end, false)};
        Condition[] c1 = new Condition[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            c1[i] = ComboCondition.and(conditions[i]);
        }
        Condition[] finalCondition = new Condition[]{ComboCondition.and(ComboCondition.and(rangeConditions), ComboCondition.or(c1))};
        return this.getFilteredVariantCount(sid, projectId, referenceId, new Condition[][]{finalCondition});
    }

    @Override
    public Map<String, Map<Range, Integer>> getChromosomeHeatMap(String sid, int projectId, int referenceId, Condition[][] conditions, int binsize) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema table;
        int total = this.getFilteredVariantCount(sid, projectId, referenceId, conditions);
        Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sid, projectId, referenceId);
        String tablename = (String)variantTableInfo[0];
        String tablenameSub = (String)variantTableInfo[1];
        float multiplier = ((Float)variantTableInfo[2]).floatValue();
        if (total >= 1000000) {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablenameSub);
        } else {
            table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
            multiplier = 1.0f;
        }
        SelectQuery queryBase = new SelectQuery();
        queryBase.addFromTable(table.getTable());
        queryBase.addColumns(table.getDBColumn(CHROM));
        String roundFunction = "ROUND(" + START_POSITION.getColumnName() + "/" + binsize + ",0)";
        queryBase.addCustomColumns(FunctionCall.countAll());
        queryBase.addGroupings(table.getDBColumn(CHROM));
        this.addConditionsToQuery(queryBase, conditions);
        String query = queryBase.toString().replace("COUNT(*)", "COUNT(*)," + roundFunction) + "," + roundFunction;
        ResultSet rs = ConnectionController.executeQuery(sid, query);
        HashMap<String, Map<Range, Integer>> results = new HashMap<String, Map<Range, Integer>>();
        while (rs.next()) {
            String chrom = rs.getString(1);
            Map chromMap = !results.containsKey(chrom) ? new HashMap() : (Map)results.get(chrom);
            int binNo = rs.getInt(3);
            Range binRange = new Range(binNo * binsize, (binNo + 1) * binsize);
            int count = (int)((float)rs.getInt(2) * multiplier);
            chromMap.put(binRange, count);
            results.put(chrom, chromMap);
        }
        return results;
    }

    @Override
    public int getPatientCountWithVariantsInRange(String sid, int projectId, int referenceId, Condition[][] conditions, String chrom, int start, int end) throws SQLException, RemoteException, SessionExpiredException {
        TableSchema table = this.getCustomTableSchema(sid, projectId, referenceId);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns("COUNT(DISTINCT " + DNA_ID.getColumnName() + ")");
        this.addConditionsToQuery(q, conditions);
        Condition[] cond = new Condition[3];
        q.addCondition(ComboCondition.and(new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)table.getDBColumn(CHROM), (Object)chrom), MiscUtils.getIntersectCondition(start, end, table.getDBColumn(START_POSITION), table.getDBColumn(END_POSITION))));
        String query = q.toString();
        query = query.replaceFirst("'", "").replaceFirst("'", "");
        ResultSet rs = ConnectionController.executeQuery(sid, query);
        rs.next();
        int numrows = rs.getInt(1);
        return numrows;
    }

    @Override
    public void addConditionsToQuery(SelectQuery query, Condition[][] conditions) {
        Condition[] c = new Condition[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            c[i] = ComboCondition.and(conditions[i]);
        }
        query.addCondition(ComboCondition.or(c));
    }

    @Override
    public Map<String, List<String>> getSavantBookmarkPositionsForDNAIDs(String sessID, int projID, int refID, Condition[][] conditions, List<String> dnaIds, int limit) throws SQLException, RemoteException, SessionExpiredException {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        TableSchema table = this.getCustomTableSchema(sessID, projID, refID);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn(DNA_ID), table.getDBColumn(CHROM), table.getDBColumn(START_POSITION));
        this.addConditionsToQuery(query, conditions);
        Condition[] dnaIdConditions = new Condition[dnaIds.size()];
        for (int i = 0; i < dnaIds.size(); ++i) {
            dnaIdConditions[i] = BinaryConditionMS.equalTo(table.getDBColumn(DNA_ID), dnaIds.get(i));
            results.put(dnaIds.get(i), new ArrayList());
        }
        query.addCondition(ComboCondition.or(dnaIdConditions));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString() + (limit == -1 ? "" : " LIMIT " + limit));
        while (rs.next()) {
            ((List)results.get(rs.getString(1))).add(rs.getString(2) + ":" + (rs.getLong(3) - 100L) + "-" + (rs.getLong(3) + 100L));
        }
        return results;
    }

    @Override
    public Map<String, Integer> getNumVariantsInFamily(String sessID, int projID, int refID, String famID, Condition[][] conditions) throws SQLException, RemoteException, SessionExpiredException {
        String name = ProjectManager.getInstance().getVariantTableName(sessID, projID, refID, true);
        if (name == null) {
            return null;
        }
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, name);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addColumns(table.getDBColumn(DNA_ID));
        q.addCustomColumns(FunctionCall.countAll());
        q.addGroupings(table.getDBColumn(DNA_ID));
        this.addConditionsToQuery(q, conditions);
        Map<String, String> patientToDNAIDMap = PatientManager.getInstance().getDNAIDsForFamily(sessID, projID, famID);
        HashMap<String, Object> betterPatientToDNAIDMap = new HashMap<String, Object>();
        ArrayList<String> dnaIDs = new ArrayList<String>();
        for (String patientID : patientToDNAIDMap.keySet()) {
            String dnaIDString = patientToDNAIDMap.get(patientID);
            ArrayList idList = new ArrayList();
            for (String dnaID : dnaIDString.split(",")) {
                if (dnaID == null || dnaID.isEmpty()) continue;
                dnaIDs.add(dnaID);
                idList.add(dnaID);
            }
            betterPatientToDNAIDMap.put(patientID, idList);
        }
        HashMap<String, Integer> dnaIDsToCountMap = new HashMap<String, Integer>();
        if (!dnaIDs.isEmpty()) {
            Condition[] dnaIDConditions = new Condition[dnaIDs.size()];
            int i = 0;
            for (String dnaID : dnaIDs) {
                dnaIDConditions[i] = BinaryCondition.equalTo(table.getDBColumn(DNA_ID), dnaID);
                ++i;
            }
            q.addCondition(ComboCondition.or(dnaIDConditions));
            ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
            while (rs.next()) {
                dnaIDsToCountMap.put(rs.getString(1), rs.getInt(2));
            }
        }
        HashMap<String, Integer> patientIDTOCount = new HashMap<String, Integer>();
        for (String patientID : betterPatientToDNAIDMap.keySet()) {
            int count = 0;
            for (String dnaID : (List)betterPatientToDNAIDMap.get(patientID)) {
                if (!dnaIDsToCountMap.containsKey(dnaID)) continue;
                count += ((Integer)dnaIDsToCountMap.get(dnaID)).intValue();
            }
            patientIDTOCount.put(patientID, count);
        }
        return patientIDTOCount;
    }

    @Override
    public void cancelUpload(String sid, int uploadId, String tableName) {
        try {
            AnnotationLogManager.getInstance().removeAnnotationLogEntry(sid, uploadId);
            DBUtils.dropTable(sid, tableName);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Error cancelling upload " + uploadId + " for " + tableName), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTagsToUpload(String sid, int uploadID, String[][] variantTags) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sid);
        try {
            TableSchema variantTagTable = MedSavantDatabase.VariantTagTableSchema;
            conn.setAutoCommit(false);
            for (int i = 0; i < variantTags.length && !Thread.currentThread().isInterrupted(); ++i) {
                InsertQuery query = variantTagTable.insert(MedSavantDatabase.VariantTagColumns.UPLOAD_ID, uploadID, MedSavantDatabase.VariantTagColumns.TAGKEY, variantTags[i][0], MedSavantDatabase.VariantTagColumns.TAGVALUE, variantTags[i][1]);
                conn.createStatement().executeUpdate(query.toString());
            }
            if (Thread.currentThread().isInterrupted()) {
                conn.rollback();
            } else {
                conn.commit();
            }
        }
        finally {
            conn.close();
        }
    }

    public void removeTags(String sessID, int uploadID) throws SQLException, SessionExpiredException {
        ConnectionController.executeUpdate(sessID, MedSavantDatabase.VariantTagTableSchema.delete(MedSavantDatabase.VariantTagColumns.UPLOAD_ID, uploadID).toString());
    }

    @Override
    public List<String> getDistinctTagNames(String sessID) throws SQLException, SessionExpiredException {
        ResultSet rs = ConnectionController.executeQuery(sessID, MedSavantDatabase.VariantTagTableSchema.distinct().select(MedSavantDatabase.VariantTagColumns.TAGKEY).toString());
        ArrayList<String> tagNames = new ArrayList<String>();
        while (rs.next()) {
            tagNames.add(rs.getString(1));
        }
        return tagNames;
    }

    @Override
    public List<String> getValuesForTagName(String sessID, String tagName) throws SQLException, SessionExpiredException {
        ResultSet rs = ConnectionController.executeQuery(sessID, MedSavantDatabase.VariantTagTableSchema.distinct().where(MedSavantDatabase.VariantTagColumns.TAGKEY, tagName).select(MedSavantDatabase.VariantTagColumns.TAGVALUE).toString());
        ArrayList<String> tagValues = new ArrayList<String>();
        while (rs.next()) {
            tagValues.add(rs.getString(1));
        }
        return tagValues;
    }

    @Override
    public List<Integer> getUploadIDsMatchingVariantTags(String sessID, String[][] variantTags) throws SQLException, SessionExpiredException {
        TableSchema table = MedSavantDatabase.VariantTagTableSchema;
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addColumns(table.getDBColumn(MedSavantDatabase.VariantTagColumns.UPLOAD_ID));
        Condition[] orConditions = new Condition[variantTags.length];
        HashSet<String> seenConditions = new HashSet<String>();
        int duplicates = 0;
        for (int i = 0; i < variantTags.length; ++i) {
            String strRepresentation = variantTags[i][0] + ":" + variantTags[i][1];
            if (seenConditions.contains(strRepresentation)) {
                ++duplicates;
                continue;
            }
            orConditions[i] = ComboCondition.and(BinaryCondition.equalTo(table.getDBColumn(MedSavantDatabase.VariantTagColumns.TAGKEY), variantTags[i][0]), BinaryCondition.equalTo(table.getDBColumn(MedSavantDatabase.VariantTagColumns.TAGVALUE), variantTags[i][1]));
            seenConditions.add(strRepresentation);
        }
        q.addCondition(ComboCondition.or(orConditions));
        q.addGroupings(table.getDBColumn(MedSavantDatabase.VariantTagColumns.UPLOAD_ID));
        q.addHaving(BinaryCondition.equalTo(FunctionCall.countAll(), variantTags.length - duplicates));
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (rs.next()) {
            results.add(rs.getInt(1));
        }
        return results;
    }

    @Override
    public SimpleVariantFile[] getUploadedFiles(String sessID, int projID, int refID) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.VariantFileTableSchema fileTable = MedSavantDatabase.VariantFileIBTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(fileTable.getTable());
        query.setIsDistinct(true);
        Column[] columnArray = new Column[3];
        columnArray[0] = fileTable.getDBColumn("upload_id");
        columnArray[1] = fileTable.getDBColumn("file_id");
        columnArray[2] = fileTable.getDBColumn("file_name");
        query.addColumns(columnArray);
        query.addCondition(BinaryCondition.equalTo(fileTable.getDBColumn("project_id"), projID));
        query.addCondition(BinaryCondition.equalTo(fileTable.getDBColumn("reference_id"), refID));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        LOG.info((Object)("Getting variant tables: " + query.toString()));
        ArrayList<SimpleVariantFile> result = new ArrayList<SimpleVariantFile>();
        while (rs.next()) {
            result.add(new SimpleVariantFile(rs.getInt(1), rs.getInt(2), rs.getString(3)));
        }
        return result.toArray(new SimpleVariantFile[0]);
    }

    @Override
    public List<String[]> getTagsForUpload(String sessID, int uplID) throws SQLException, RemoteException, SessionExpiredException {
        ResultSet rs = ConnectionController.executeQuery(sessID, MedSavantDatabase.VariantTagTableSchema.where(MedSavantDatabase.VariantTagColumns.UPLOAD_ID, uplID).select(MedSavantDatabase.VariantTagColumns.TAGKEY, MedSavantDatabase.VariantTagColumns.TAGVALUE).toString());
        ArrayList<String[]> result = new ArrayList<String[]>();
        while (rs.next()) {
            result.add(new String[]{rs.getString(1), rs.getString(2)});
        }
        return result;
    }

    @Override
    public List<VariantComment> getVariantComments(String sid, int projectId, int referenceId, int uploadId, int fileID, int variantID) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.VariantStarredTableSchema table = MedSavantDatabase.VariantStarredTableSchema;
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addColumns(table.getDBColumn("project_id"), table.getDBColumn("reference_id"), table.getDBColumn("upload_id"), table.getDBColumn("file_id"), table.getDBColumn("variant_id"), table.getDBColumn("user"), table.getDBColumn("description"), table.getDBColumn("timestamp"));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("project_id"), projectId));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("reference_id"), referenceId));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("upload_id"), uploadId));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("file_id"), fileID));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("variant_id"), variantID));
        ResultSet rs = ConnectionController.executeQuery(sid, q.toString());
        ArrayList<VariantComment> result = new ArrayList<VariantComment>();
        while (rs.next()) {
            result.add(new VariantComment(rs.getInt("project_id"), rs.getInt("reference_id"), rs.getInt("upload_id"), rs.getInt("file_id"), rs.getInt("variant_id"), rs.getString("user"), rs.getString("description"), rs.getTimestamp("timestamp")));
        }
        return result;
    }

    @Override
    public void addVariantComments(String sid, List<VariantComment> variants) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.VariantStarredTableSchema table = MedSavantDatabase.VariantStarredTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sid);
        c.setAutoCommit(false);
        for (VariantComment variant : variants) {
            InsertQuery q = new InsertQuery(table.getTable());
            List<DbColumn> columnsList = table.getColumns();
            Column[] columnsArray = new Column[columnsList.size()];
            columnsArray = columnsList.toArray(columnsArray);
            q.addColumns(columnsArray, variant.toArray(variant.getProjectId(), variant.getReferenceId()));
            c.createStatement().executeUpdate(q.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    @Override
    public void removeVariantComments(String sessID, List<VariantComment> comments) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantStarredTableSchema table = MedSavantDatabase.VariantStarredTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sessID);
        c.setAutoCommit(false);
        for (VariantComment vc : comments) {
            DeleteQuery q = new DeleteQuery(table.getTable());
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("project_id"), vc.getProjectId()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("reference_id"), vc.getReferenceId()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("upload_id"), vc.getUploadId()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("file_id"), vc.getFileId()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("variant_id"), vc.getVariantId()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("user"), vc.getUser()));
            q.addCondition(BinaryCondition.equalTo(table.getDBColumn("timestamp"), vc.getTimestamp()));
            ConnectionController.executeUpdate(sessID, q.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    private int getTotalNumStarred(String sid, int projectId, int referenceId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantStarredTableSchema table = MedSavantDatabase.VariantStarredTableSchema;
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns(FunctionCall.countAll());
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("project_id"), projectId));
        q.addCondition(BinaryCondition.equalTo(table.getDBColumn("reference_id"), referenceId));
        ResultSet rs = ConnectionController.executeQuery(sid, q.toString());
        rs.next();
        return rs.getInt(1);
    }

    public static synchronized int addEntryToFileTable(String sid, int uploadId, int projectID, int referenceID, File file) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantFileTableSchema table = MedSavantDatabase.VariantFileTableSchema;
        InsertQuery q = new InsertQuery(table.getTable());
        q.addColumn(table.getDBColumn("upload_id"), uploadId);
        q.addColumn(table.getDBColumn("project_id"), projectID);
        q.addColumn(table.getDBColumn("reference_id"), referenceID);
        q.addColumn(table.getDBColumn("file_name"), file.getAbsolutePath());
        ConnectionController.executeUpdate(sid, q.toString());
        String query = "SELECT last_insert_id() AS last_id from " + table.getTableName();
        ResultSet rs = ConnectionController.executeQuery(sid, query);
        if (!rs.first()) {
            throw new SQLException("Couldn't fetch file_id for file " + file.getAbsolutePath() + " on project " + projectID + ", ref " + referenceID);
        }
        int file_id = rs.getInt(1);
        if (file_id < 1) {
            throw new SQLException("Invalid file_id for file " + file.getAbsolutePath() + " on project " + projectID + ", ref " + referenceID);
        }
        return file_id;
    }

    private void removeEntriesFromFileTable(String sessID, Collection<SimpleVariantFile> files) throws SQLException, SessionExpiredException {
        boolean i = false;
        for (SimpleVariantFile svf : files) {
            this.removeEntryFromFileTable(sessID, svf.getFileId());
        }
    }

    private void removeEntryFromFileTable(String sessID, int fileID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantFileTableSchema table = MedSavantDatabase.VariantFileTableSchema;
        DeleteQuery q = new DeleteQuery(table.getTable());
        q.addCondition(ComboCondition.and(BinaryCondition.equalTo(table.getDBColumn("file_id"), fileID)));
        ConnectionController.executeUpdate(sessID, q.toString());
    }

    @Override
    public Map<SimplePatient, Integer> getPatientHeatMap(String sessID, int projID, int refID, Condition[][] conditions, Collection<SimplePatient> patients) throws SQLException, RemoteException, SessionExpiredException {
        ArrayList<String> dnaIds = new ArrayList<String>();
        for (SimplePatient sp : patients) {
            for (String id : sp.getDnaIds()) {
                if (dnaIds.contains(id)) continue;
                dnaIds.add(id);
            }
        }
        Map<String, Integer> dnaIdMap = this.getDNAIDHeatMap(sessID, projID, refID, conditions, dnaIds);
        HashMap<SimplePatient, Integer> result = new HashMap<SimplePatient, Integer>();
        for (SimplePatient p : patients) {
            Integer count = 0;
            for (String dnaId : p.getDnaIds()) {
                Integer i = dnaIdMap.get(dnaId);
                if (i == null) continue;
                count = count + i;
            }
            result.put(p, count);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getDNAIDHeatMap(String sessID, int projID, int refID, Condition[][] conditions, Collection<String> dnaIDs) throws SQLException, RemoteException, SessionExpiredException {
        HashMap<String, Integer> dnaIDMap = new HashMap<String, Integer>();
        if (!dnaIDs.isEmpty()) {
            Object[] variantTableInfo = ProjectManager.getInstance().getVariantTableViewInfo(sessID, projID, refID);
            String tablename = (String)variantTableInfo[0];
            String tablenameSub = (String)variantTableInfo[1];
            float multiplier = ((Float)variantTableInfo[2]).floatValue();
            TableSchema subTable = CustomTables.getInstance().getCustomTableSchema(sessID, tablenameSub);
            TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
            Condition[] c1 = new Condition[conditions.length];
            for (int i = 0; i < conditions.length; ++i) {
                c1[i] = ComboCondition.and(conditions[i]);
            }
            ComboCondition c2 = ComboCondition.or(c1);
            this.getDNAIDHeatMapHelper(sessID, subTable, multiplier, dnaIDs, c2, true, dnaIDMap);
            ArrayList<String> dnaIDs2 = new ArrayList<String>();
            for (String id : dnaIDs) {
                if (dnaIDMap.containsKey(id)) continue;
                dnaIDs2.add(id);
            }
            if (!dnaIDs2.isEmpty()) {
                this.getDNAIDHeatMapHelper(sessID, table, 1.0f, dnaIDs2, c2, false, dnaIDMap);
            }
        }
        return dnaIDMap;
    }

    private boolean isAuthorizedForUserComments(String sessID) throws SecurityException, SessionExpiredException, SQLException, RemoteException {
        return true;
    }

    public void deleteComment(String sessID, int userCommentId) throws SessionExpiredException, SQLException, RemoteException, SecurityException {
        if (!this.isAuthorizedForUserComments(sessID)) {
            throw new SecurityException("This user does not have access to view comments");
        }
        MedSavantDatabase.UserCommentTableSchema lcTable = MedSavantDatabase.UserCommentTableSchema;
        UpdateQuery uq = new UpdateQuery(lcTable.getTable());
        uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_deleted"), true);
        uq.addCondition(BinaryCondition.equalTo(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user_comment_id"), userCommentId));
        ConnectionController.executeUpdate(sessID, uq.toString());
    }

    @Override
    public UserCommentGroup createUserCommentGroup(String sessID, int projectId, int refId, VariantRecord vr) throws RemoteException, SQLException, SessionExpiredException, IllegalArgumentException {
        return this.createUserCommentGroup(sessID, projectId, refId, vr.getChrom(), vr.getStartPosition(), vr.getEndPosition(), vr.getRef(), vr.getAlt());
    }

    @Override
    public UserCommentGroup createUserCommentGroup(String sessID, int projectId, int refId, String chrom, long start_position, long end_position, String ref, String alt) throws RemoteException, SQLException, SessionExpiredException, IllegalArgumentException {
        UserCommentGroup lcg = this.getUserCommentGroup(sessID, projectId, refId, chrom, start_position, end_position, ref, alt, true);
        if (lcg != null) {
            throw new IllegalArgumentException("A comment group already exists at chrom=" + chrom + ", start=" + start_position + " end=" + end_position + " ref=" + ref + " alt=" + alt);
        }
        MedSavantDatabase.UserCommentGroupTableSchema lcgTable = MedSavantDatabase.UserCommentGroupTableSchema;
        InsertQuery iq = new InsertQuery(lcgTable.getTable());
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("project_id"), projectId);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("reference_id"), refId);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("chrom"), chrom);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("start_position"), start_position);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("end_position"), end_position);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("ref"), ref);
        iq.addColumn(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("alt"), alt);
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        PreparedStatement stmt = null;
        ResultSet res = null;
        int groupId = -1;
        try {
            LOG.info((Object)iq.toString());
            stmt = conn.prepareStatement(iq.toString(), 1);
            stmt.execute();
            res = stmt.getGeneratedKeys();
            res.next();
            groupId = res.getInt(1);
        }
        catch (SQLException sqe) {
            LOG.error((Object)"SQL Error ", (Throwable)sqe);
            throw sqe;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (res != null) {
                res.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        if (groupId < 0) {
            throw new SQLException("Unable to create new group - invalid insertion id");
        }
        Date modStamp = null;
        lcg = new UserCommentGroup(groupId, projectId, refId, chrom, start_position, end_position, ref, alt, modStamp, null);
        return lcg;
    }

    public void setUserCommentStatus(String sessID, int userCommentGroupId, UserComment statusChangeComment) throws SessionExpiredException, SQLException, RemoteException, SecurityException, IllegalArgumentException {
        if (!statusChangeComment.statusChanged()) {
            throw new IllegalArgumentException("Can't update the comment's status because it hasn't changed.");
        }
        Integer parentCommentId = statusChangeComment.getOriginalComment().getCommentID();
        if (parentCommentId == null) {
            throw new IllegalArgumentException("Can't update the comment's status because comment could not be located in the database");
        }
        int statusChangeCommentId = this.replyToUserCommentGroup(sessID, userCommentGroupId, statusChangeComment);
        this.updateCommentStatus(sessID, parentCommentId, statusChangeComment.getOriginalComment().isApproved(), statusChangeComment.getOriginalComment().isIncluded(), statusChangeComment.getOriginalComment().isDeleted());
        this.updateCommentStatus(sessID, statusChangeCommentId, statusChangeComment.isApproved(), statusChangeComment.isIncluded(), statusChangeComment.isDeleted());
    }

    private void updateCommentStatus(String sessID, int commentId, boolean isApproved, boolean isIncluded, boolean isDeleted) throws SQLException, SessionExpiredException {
        MedSavantDatabase.UserCommentTableSchema lcTable = MedSavantDatabase.UserCommentTableSchema;
        UpdateQuery uq = new UpdateQuery(lcTable.getTable());
        uq.addCondition(BinaryCondition.equalTo(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user_comment_id"), commentId));
        uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_approved"), isApproved);
        uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_included"), isIncluded);
        uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_deleted"), isDeleted);
        ConnectionController.executeUpdate(sessID, uq.toString());
    }

    @Override
    public int replyToUserCommentGroup(String sessID, int userCommentGroupId, UserComment userComment) throws SessionExpiredException, SQLException, RemoteException, SecurityException {
        if (!this.isAuthorizedForUserComments(sessID)) {
            throw new SecurityException("This user does not have access to view comments");
        }
        String username = SessionManager.getInstance().getUserForSession(sessID);
        String ontologyId = userComment.getOntologyTerm().getID();
        Boolean isApproved = userComment.isApproved();
        Boolean isIncluded = userComment.isIncluded();
        Boolean isDeleted = userComment.isDeleted();
        String commentText = userComment.getCommentText();
        String ontology = userComment.getOntologyTerm().getOntology().name();
        MedSavantDatabase.UserCommentTableSchema lcTable = MedSavantDatabase.UserCommentTableSchema;
        InsertQuery iq = new InsertQuery(lcTable.getTable());
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("fk_user_comment_group_id"), userCommentGroupId);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("ontology_id"), ontologyId);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("ontology"), ontology);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user"), username);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_approved"), isApproved);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_included"), isIncluded);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_deleted"), isDeleted);
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("creation_date"), new FunctionCall(new CustomSql("NOW")).addCustomParams(new Object[0]));
        iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("variant_comment"), commentText);
        if (userComment.getOriginalComment() != null) {
            Integer commentId = userComment.getOriginalComment().getCommentID();
            if (commentId == null) {
                throw new IllegalArgumentException("Cannot post this comment as it refers to a comment with a null identifier");
            }
            if (commentId < 1) {
                throw new IllegalArgumentException("Cannot post this comment as it refers to a comment with a non-positive identifier: " + commentId);
            }
            iq.addColumn(MedSavantDatabase.UserCommentTableSchema.getDBColumn("fk_parent_user_comment_id"), commentId);
        }
        PreparedStatement stmt = null;
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        ResultSet res = null;
        int commentId = -1;
        try {
            stmt = conn.prepareStatement(iq.toString(), 1);
            stmt.execute();
            res = stmt.getGeneratedKeys();
            res.next();
            commentId = res.getInt(1);
            if (userComment.getOriginalComment() != null) {
                UpdateQuery uq = new UpdateQuery(lcTable.getTable());
                uq.addCondition(BinaryCondition.equalTo(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user_comment_id"), userComment.getOriginalComment().getCommentID()));
                uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_approved"), userComment.getOriginalComment().isApproved());
                uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_included"), userComment.getOriginalComment().isIncluded());
                uq.addSetClause(MedSavantDatabase.UserCommentTableSchema.getDBColumn("is_deleted"), userComment.getOriginalComment().isDeleted());
                stmt = conn.prepareStatement(uq.toString());
                stmt.execute();
            }
            int uq = commentId;
            return uq;
        }
        catch (SQLException sqe) {
            LOG.error((Object)"SQL Error", (Throwable)sqe);
            throw sqe;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (res != null) {
                res.close();
            }
        }
    }

    @Override
    public UserCommentGroup getUserCommentGroup(String sessID, int projectId, int refId, VariantRecord vr) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        return this.getUserCommentGroup(sessID, projectId, refId, vr.getChrom(), vr.getStartPosition(), vr.getEndPosition(), vr.getRef(), vr.getAlt());
    }

    @Override
    public UserCommentGroup getUserCommentGroup(String sessID, int projectId, int refId, String chrom, long start_position, long end_position, String ref, String alt) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        return this.getUserCommentGroup(sessID, projectId, refId, chrom, start_position, end_position, ref, alt, false);
    }

    private List<UserComment> getUserCommentsForGroup(String sessID, int groupId, boolean loadOnlyMostRecentComment) throws SQLException, SessionExpiredException, RemoteException {
        SelectQuery sq;
        ResultSet rs = null;
        try {
            MedSavantDatabase.UserCommentGroupTableSchema lcgTable = MedSavantDatabase.UserCommentGroupTableSchema;
            sq = new SelectQuery();
            sq.addFromTable(lcgTable.getTable());
            sq.addAllColumns();
            sq.addCondition(BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("user_comment_group_id"), groupId));
            rs = ConnectionController.executeQuery(sessID, sq.toString());
            if (rs == null || !rs.next()) {
                throw new IllegalArgumentException("There is no comment group with the given identifier " + groupId);
            }
        }
        catch (SQLException sqe) {
            LOG.error((Object)"SQL Error", (Throwable)sqe);
            throw sqe;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        rs = null;
        try {
            MedSavantDatabase.UserCommentTableSchema lcTable = MedSavantDatabase.UserCommentTableSchema;
            sq = new SelectQuery();
            sq.addFromTable(lcTable.getTable());
            sq.addAllColumns();
            sq.addCondition(BinaryCondition.equalTo(MedSavantDatabase.UserCommentTableSchema.getDBColumn("fk_user_comment_group_id"), groupId));
            String querySuffix = "";
            if (loadOnlyMostRecentComment) {
                sq.addCondition(UnaryCondition.isNotNull(MedSavantDatabase.UserCommentTableSchema.getDBColumn("fk_parent_user_comment_id")));
                sq.addOrdering(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user_comment_id"), OrderObject.Dir.DESCENDING);
                querySuffix = " LIMIT 1";
            } else {
                sq.addOrdering(MedSavantDatabase.UserCommentTableSchema.getDBColumn("user_comment_id"), OrderObject.Dir.ASCENDING);
            }
            LOG.info((Object)(sq.toString() + querySuffix));
            rs = ConnectionController.executeQuery(sessID, sq.toString() + querySuffix);
            TreeMap<Integer, UserComment> parentCommentMap = new TreeMap<Integer, UserComment>();
            HashMap<Integer, TreeSet<UserComment>> childCommentMap = new HashMap<Integer, TreeSet<UserComment>>();
            while (rs.next()) {
                UserComment lc;
                int commentId = rs.getInt("user_comment_id");
                int parentCommentId = rs.getInt("fk_parent_user_comment_id");
                String ontologyId = rs.getString("ontology_id");
                String user = rs.getString("user");
                Boolean isApproved = rs.getBoolean("is_approved");
                Boolean isIncluded = rs.getBoolean("is_included");
                Boolean isDeleted = rs.getBoolean("is_deleted");
                java.sql.Date creationDate = rs.getDate("creation_date");
                Timestamp ts = rs.getTimestamp("last_modified");
                Date modDate = new Date(ts.getTime());
                String commentText = rs.getString("variant_comment");
                OntologyTerm ot = OntologyManager.getInstance().getOntologyTerm(sessID, UserComment.ONTOLOGY_TYPE, ontologyId);
                UserComment parentComment = null;
                if (parentCommentId > 0) {
                    parentComment = (UserComment)parentCommentMap.get(parentCommentId);
                    if (parentComment == null) {
                        LOG.error((Object)("Comment with id " + commentId + " refers to a comment with an unknown identifier (" + parentCommentId + ")"));
                        throw new SQLException("Invalid comment detected in database with id " + commentId + " (Refers to non-existant comment with id " + parentCommentId + ")");
                    }
                    lc = new UserComment(commentId, user, isApproved, isIncluded, isDeleted, creationDate, modDate, commentText, ot, parentComment);
                    TreeSet<UserComment> lcSet = (TreeSet<UserComment>)childCommentMap.get(parentCommentId);
                    if (lcSet == null) {
                        lcSet = new TreeSet<UserComment>(new Comparator<UserComment>(){

                            @Override
                            public int compare(UserComment o1, UserComment o2) {
                                return o1.getModificationDate().compareTo(o2.getModificationDate());
                            }
                        });
                    }
                    lcSet.add(lc);
                    childCommentMap.put(parentCommentId, lcSet);
                    continue;
                }
                lc = new UserComment(commentId, user, isApproved, isIncluded, isDeleted, creationDate, modDate, commentText, ot, null);
                parentCommentMap.put(commentId, lc);
            }
            ArrayList<UserComment> comments = new ArrayList<UserComment>();
            for (Map.Entry e : parentCommentMap.entrySet()) {
                Integer parentId = (Integer)e.getKey();
                UserComment parentComment = (UserComment)e.getValue();
                comments.add(parentComment);
                Set childComments = (Set)childCommentMap.get(parentId);
                if (childComments == null) continue;
                comments.addAll(childComments);
            }
            ArrayList<UserComment> arrayList = comments;
            return arrayList;
        }
        catch (SQLException sqe) {
            LOG.error((Object)"SQL Error", (Throwable)sqe);
            throw sqe;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserCommentGroup getUserCommentGroup(String sessID, int projectId, int refId, String chrom, long start_position, long end_position, String ref, String alt, boolean loadOnlyMostRecentComment) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        int groupId;
        block7: {
            if (!this.isAuthorizedForUserComments(sessID)) {
                throw new SecurityException("This user does not have access to view comments");
            }
            MedSavantDatabase.UserCommentGroupTableSchema lcgTable = MedSavantDatabase.UserCommentGroupTableSchema;
            SelectQuery sq = new SelectQuery();
            sq.addFromTable(lcgTable.getTable());
            Condition[] conditionArray = new Condition[7];
            conditionArray[0] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("project_id"), projectId);
            conditionArray[1] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("reference_id"), refId);
            conditionArray[2] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("chrom"), chrom);
            conditionArray[3] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("start_position"), start_position);
            conditionArray[4] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("end_position"), end_position);
            conditionArray[5] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("ref"), ref);
            conditionArray[6] = BinaryCondition.equalTo(MedSavantDatabase.UserCommentGroupTableSchema.getDBColumn("alt"), alt);
            ComboCondition cc = ComboCondition.and(conditionArray);
            sq.addCondition(cc);
            Column[] columnArray = new Column[1];
            columnArray[0] = lcgTable.getDBColumn("user_comment_group_id");
            sq.addColumns(columnArray);
            ResultSet rs = null;
            groupId = 0;
            try {
                rs = ConnectionController.executeQuery(sessID, sq.toString());
                if (rs.next()) {
                    groupId = rs.getInt("user_comment_group_id");
                    break block7;
                }
                UserCommentGroup userCommentGroup = null;
                return userCommentGroup;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        Date modDate = null;
        List<UserComment> comments = this.getUserCommentsForGroup(sessID, groupId, loadOnlyMostRecentComment);
        if (comments.size() > 0) {
            UserComment lastComment = comments.get(comments.size() - 1);
            modDate = lastComment.getModificationDate();
        }
        return new UserCommentGroup(groupId, projectId, refId, chrom, start_position, end_position, ref, alt, modDate, comments);
    }

    private void getDNAIDHeatMapHelper(String sessID, TableSchema table, float multiplier, Collection<String> dnaIDs, Condition c, boolean useThreshold, Map<String, Integer> map) throws SQLException, SessionExpiredException {
        InCondition dnaCondition = new InCondition((Object)table.getDBColumn(DNA_ID), dnaIDs);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addCustomColumns(FunctionCall.countAll());
        q.addColumns(table.getDBColumn(DNA_ID));
        q.addCondition(ComboCondition.and(dnaCondition, c));
        q.addGroupings(table.getDBColumn(DNA_ID));
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        while (rs.next()) {
            int value = (int)((float)rs.getInt(1) * multiplier);
            if (useThreshold && value < 1000) continue;
            map.put(rs.getString(2), value);
        }
    }

    private Condition createNucleotideCondition(DbColumn column) {
        return ComboCondition.or(BinaryCondition.equalTo(column, "A"), BinaryCondition.equalTo(column, "C"), BinaryCondition.equalTo(column, "G"), BinaryCondition.equalTo(column, "T"));
    }

    static {
        REMOVE_WORKING_DIR = true;
    }
}

