/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.mail.CryptoUtils;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.SessionManagerAdapter;

public class SessionManager
extends MedSavantServerUnicastRemoteObject
implements SessionManagerAdapter {
    private static final Log LOG = LogFactory.getLog(SessionManager.class);
    private static SessionManager instance;
    int lastSessionId = 0;

    public static synchronized SessionManager getInstance() throws RemoteException {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    private SessionManager() throws RemoteException {
    }

    @Override
    public synchronized String registerNewSession(String user, String password, String dbName) throws RemoteException, SQLException, Exception {
        String sessionID = this.nextSession();
        ConnectionController.registerCredentials(sessionID, user, password, dbName);
        LOG.info((Object)("Registered session for " + user));
        LogManager.getInstance().addServerLog(sessionID, LogManagerAdapter.LogType.INFO, "Registered session for " + user);
        return sessionID;
    }

    @Override
    public void unregisterSession(String sessID) throws RemoteException, SQLException, SessionExpiredException {
        if (ConnectionController.sessionExists(sessID)) {
            LogManager.getInstance().addServerLog(sessID, LogManagerAdapter.LogType.INFO, "Unregistered session for " + SessionManager.getInstance().getUserForSession(sessID));
            ConnectionController.removeSession(sessID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(String sessID) throws RemoteException, SQLException, SessionExpiredException {
        PooledConnection conn = null;
        try {
            conn = ConnectionController.connectPooled(sessID);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String getUserForSession(String sid) {
        return ConnectionController.getUserForSession(sid);
    }

    public String getDatabaseForSession(String sid) {
        return ConnectionController.getDBName(sid);
    }

    public void terminateSessionsForDatabase(String dbname) {
        this.terminateSessionsForDatabase(dbname, null);
    }

    public void terminateAllSessions(String message) {
        for (String dbName : ConnectionController.getDBNames()) {
            this.terminateSessionsForDatabase(dbName, message);
        }
    }

    public void terminateSessionsForDatabase(String dbname, String message) {
        LOG.info((Object)("Terminating sessions for database " + dbname));
        ArrayList<String> sessionIDsToTerminate = new ArrayList<String>();
        for (final String sid : ConnectionController.getSessionIDs()) {
            try {
                if (!SessionManager.getInstance().getDatabaseForSession(sid).equals(dbname)) continue;
                sessionIDsToTerminate.add(sid);
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to get session ID for " + dbname + "."), (Throwable)ex);
            }
        }
        for (final String sid : sessionIDsToTerminate) {
            MedSavantServerEngine.submitShortJob(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.info((Object)("Terminating session " + sid + "..."));
                        SessionManager.getInstance().unregisterSession(sid);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Unable to terminate session for " + sid + "."), (Throwable)ex);
                    }
                }
            });
        }
    }

    public String createBackgroundSessionFromSession(String sessID) {
        String sessionID = this.nextSession();
        LOG.info((Object)("Registered background session " + sessionID + " from " + sessID));
        ConnectionController.registerAdditionalSessionForSession(sessID, sessionID);
        return sessionID;
    }

    private synchronized String nextSession() {
        int newSessionIdNumber = ++this.lastSessionId;
        String sessionId = CryptoUtils.encrypt(newSessionIdNumber + "");
        return sessionId;
    }
}

