/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.admin.SetupMedSavantDatabase;
import org.ut.biolab.medsavant.server.db.util.DBSettings;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.server.db.variants.VariantManagerUtils;
import org.ut.biolab.medsavant.server.serverapi.AnnotationManager;
import org.ut.biolab.medsavant.server.serverapi.CohortManager;
import org.ut.biolab.medsavant.server.serverapi.PatientManager;
import org.ut.biolab.medsavant.server.serverapi.ReferenceManager;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.serverapi.VariantManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.AnnotationDownloadInformation;
import org.ut.biolab.medsavant.shared.model.ProjectDetails;
import org.ut.biolab.medsavant.shared.model.Reference;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.ProjectManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.VersionSettings;

public class ProjectManager
extends MedSavantServerUnicastRemoteObject
implements ProjectManagerAdapter {
    private static final Log LOG = LogFactory.getLog(ProjectManager.class);
    private static ProjectManager instance;

    private ProjectManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized ProjectManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new ProjectManager();
        }
        return instance;
    }

    @Override
    @Deprecated
    public String getVariantTableName(String sessID, int updateID, int projectid, int refid) throws SQLException, SessionExpiredException, RemoteException {
        return DBSettings.getVariantViewName(projectid, refid);
    }

    @Override
    public String[] getProjectNames(String sid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("name"));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result.toArray(new String[0]);
    }

    @Override
    public boolean containsProject(String sid, String projectName) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addAllColumns();
        query.addFromTable(table.getTable());
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("name"), projectName));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        return rs.next();
    }

    @Override
    public int getProjectID(String sid, String projectName) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("project_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("name"), projectName));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferenceForProject(String sessID, int projID, int refID) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            TableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
            SelectQuery query1 = new SelectQuery();
            query1.addFromTable(table.getTable());
            query1.addColumns(table.getDBColumn("variant_tablename"));
            query1.addCondition(ComboCondition.and(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID), BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refID)));
            ResultSet rs = conn.executeQuery(query1.toString());
            while (rs.next()) {
                String tableName = rs.getString(1);
                DBUtils.dropTable(sessID, tableName);
            }
            DeleteQuery query2 = new DeleteQuery(table.getTable());
            query2.addCondition(ComboCondition.and(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID), BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refID)));
            conn.executeUpdate(query2.toString());
            table = MedSavantDatabase.VariantformatTableSchema;
            query2 = new DeleteQuery(table.getTable());
            query2.addCondition(ComboCondition.and(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID), BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refID)));
            conn.executeUpdate(query2.toString());
        }
        finally {
            conn.close();
        }
    }

    @Override
    public String getProjectName(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("name"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID));
        ResultSet rs1 = ConnectionController.executeQuery(sessID, query.toString());
        if (rs1.next()) {
            return rs1.getString(1);
        }
        return null;
    }

    @Override
    public int[] getDefaultAnnotationIDs(String sessID, int projID, int refID) throws RemoteException, SQLException, SessionExpiredException {
        ArrayList<Integer> defaultAnnIds = new ArrayList<Integer>();
        Reference[] refs = ReferenceManager.getInstance().getReferences(sessID);
        String refStr = null;
        for (Reference ref : refs) {
            if (ref.getID() != refID) continue;
            refStr = ref.getName();
            break;
        }
        if (refStr == null) {
            LOG.error((Object)("Reference id " + refID + " is invalid"));
            throw new SQLException("Reference id " + refID + " is invalid");
        }
        try {
            List<AnnotationDownloadInformation> annotations = AnnotationDownloadInformation.getDownloadableAnnotations(VersionSettings.getVersionString(), refStr);
            for (AnnotationDownloadInformation adi : annotations) {
                if (!adi.isDefault()) continue;
                int id = AnnotationManager.getInstance().doInstallAnnotationForProject(sessID, projID, adi);
                if (id == -1) {
                    LOG.error((Object)("Couldn't install annotation " + adi + " for project " + projID));
                }
                defaultAnnIds.add(id);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return ArrayUtils.toPrimitive((Integer[])defaultAnnIds.toArray(new Integer[defaultAnnIds.size()]));
    }

    @Override
    @Deprecated
    public String createVariantTable(String sessID, int projID, int refID, int updID, int[] annIDs, boolean staging) throws RemoteException, SQLException, SessionExpiredException {
        CustomField[] customFields = this.getCustomVariantFields(sessID, projID, refID, 0, true);
        String vt = this.addVariantTableToDatabase(sessID, projID, refID, 0, annIDs, customFields, false);
        String vts = this.addVariantTableToDatabase(sessID, projID, refID, 0, annIDs, customFields, true);
        this.addTableToMap(sessID, projID, refID, 0, false, vt, annIDs, vts);
        try {
            this.publishVariantTable(sessID, projID, refID);
        }
        catch (IOException iex) {
            LOG.error((Object)"Couldn't publish variant table", (Throwable)iex);
            throw new RemoteException("Couldn't publish variant table", iex);
        }
        return vt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVariantTableToDatabase(String sessID, int projID, int refID, int updID, int[] annIDs, CustomField[] customFields, boolean sub) throws RemoteException, SQLException, SessionExpiredException {
        String tableName = DBSettings.getVariantTableName(projID, refID, updID);
        if (sub) {
            tableName = tableName + "_subset";
        }
        TableSchema variantSchema = new TableSchema(MedSavantDatabase.schema, tableName, BasicVariantColumns.REQUIRED_VARIANT_FIELDS);
        for (CustomField f : customFields) {
            variantSchema.addColumn(f);
        }
        String s = "";
        for (DbColumn c : variantSchema.getColumns()) {
            s = s + c.getColumnNameSQL() + " ";
        }
        LOG.info((Object)("Creating variant table " + tableName + " with fields " + s));
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            int j = 0;
            for (int ann : annIDs) {
                annIDs[j++] = ann;
                AnnotationFormat annFmt = AnnotationManager.getInstance().getAnnotationFormat(sessID, ann);
                for (CustomField f : annFmt.getCustomFields()) {
                    variantSchema.addColumn(f);
                }
            }
            String updateString = MedSavantServerEngine.USE_INFINIDB_ENGINE ? variantSchema.getCreateQuery() + " ENGINE=INFINIDB;" : variantSchema.getCreateQuery() + " ENGINE=BRIGHTHOUSE DEFAULT CHARSET=latin1 COLLATE=latin1_bin;";
            conn.executeUpdate(updateString);
        }
        finally {
            conn.close();
        }
        return tableName;
    }

    public void setupTablesForVariantRemoval(String sessID, int projID, int refID, int updId, String newSubsetTableName) throws SQLException, RemoteException, SessionExpiredException {
        Object[] row = ProjectManager.getInstance().getVariantTableMapRecord(sessID, projID, refID, true);
        String tableName = (String)row[4];
        int[] annotationIds = AnnotationManager.getInstance().getAnnotationIDs(sessID, projID, refID);
        this.addTableToMap(sessID, projID, refID, updId, false, tableName, annotationIds, newSubsetTableName);
    }

    @Override
    @Deprecated
    public void addTableToMap(String sessID, int projID, int refID, int updID, boolean published, String tableName, int[] annotationIDs, String subTableName) throws SQLException, RemoteException, SessionExpiredException {
        if (published) {
            LOG.error((Object)"Can't add a published table to the variant table map");
            published = false;
        }
        MedSavantDatabase.VariantTablemapTableSchema variantTableMap = MedSavantDatabase.VarianttablemapTableSchema;
        InsertQuery query = new InsertQuery(variantTableMap.getTable());
        query.addColumn(variantTableMap.getDBColumn("project_id"), projID);
        query.addColumn(variantTableMap.getDBColumn("reference_id"), refID);
        query.addColumn(variantTableMap.getDBColumn("update_id"), updID);
        query.addColumn(variantTableMap.getDBColumn("published"), published);
        query.addColumn(variantTableMap.getDBColumn("variant_tablename"), tableName);
        query.addColumn(variantTableMap.getDBColumn("variant_subset_tablename"), subTableName);
        float subMultiplier = 0.0f;
        query.addColumn(variantTableMap.getDBColumn("subset_multiplier"), Float.valueOf(subMultiplier));
        if (annotationIDs.length > 0) {
            HashSet<Integer> annotationIdSet = new HashSet<Integer>();
            for (int id : annotationIDs) {
                annotationIdSet.add(id);
            }
            if (annotationIdSet.size() < annotationIDs.length) {
                LOG.error((Object)("ERROR: Ignoring duplicate annotation ids in list " + StringUtils.join((Object[])new Serializable[]{annotationIDs, ","})));
            }
            String annIDString = "";
            for (Integer id : annotationIdSet) {
                annIDString = annIDString + id + ",";
            }
            annIDString = annIDString.substring(0, annIDString.length() - 1);
            query.addColumn(variantTableMap.getDBColumn("annotation_ids"), annIDString);
        }
        ConnectionController.executeUpdate(sessID, query.toString());
    }

    private Object[] getVariantTableMapRecord(String sid, int projectid, int refid, boolean published) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectid));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refid));
        if (published) {
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("published"), true));
        }
        query.addOrdering(table.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            Object[] results = new Object[rs.getMetaData().getColumnCount()];
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                results[i - 1] = rs.getObject(i);
            }
            return results;
        }
        return null;
    }

    public String getNameOfVariantTable(String sid, int projectid, int refid, boolean published, boolean sub) throws SQLException, SessionExpiredException {
        Object[] row = this.getVariantTableMapRecord(sid, projectid, refid, published);
        return sub ? (String)row[6] : (String)row[4];
    }

    @Override
    @Deprecated
    public String getVariantTableName(String sid, int projectid, int refid, boolean published) throws SQLException, SessionExpiredException {
        return this.getVariantTableName(sid, projectid, refid, published, false);
    }

    @Override
    @Deprecated
    public String getVariantTableName(String sid, int projectid, int refid, boolean published, boolean sub) throws SQLException, SessionExpiredException {
        return sub ? DBSettings.getVariantViewName(projectid, refid) : DBSettings.getVariantViewName(projectid, refid);
    }

    public Object[] getVariantTableViewInfo(String sid, int projectid, int refid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("variant_subset_tablename"), table.getDBColumn("subset_multiplier"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectid));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refid));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("published"), true));
        query.addOrdering(table.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            rs.getString(1);
            String subsetViewName = rs.wasNull() ? null : DBSettings.getVariantSubsetViewName(projectid, refid);
            return new Object[]{DBSettings.getVariantViewName(projectid, refid), subsetViewName, Float.valueOf(rs.getFloat(2))};
        }
        return null;
    }

    public void addSubsetInfoToMap(String sessID, int projID, int refID, int updID, String subTableName, float multiplier) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addCustomSetClause(table.getDBColumn("variant_subset_tablename"), subTableName);
        query.addCustomSetClause(table.getDBColumn("subset_multiplier"), Float.valueOf(multiplier));
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn("project_id"), projID));
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn("reference_id"), refID));
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn("update_id"), updID));
        ConnectionController.executeUpdate(sessID, query.toString());
    }

    private float getMultiplier(String sid, String table, String subTable) throws SQLException, RemoteException, SessionExpiredException {
        int numerator = VariantManager.getInstance().getNumFilteredVariantsHelper(sid, table, new Condition[0][]);
        int denominator = VariantManager.getInstance().getNumFilteredVariantsHelper(sid, subTable, new Condition[0][]);
        if (denominator == 0) {
            denominator = 1;
        }
        if (numerator > 0) {
            return (float)numerator / (float)denominator;
        }
        return 1.0f;
    }

    @Override
    public int addProject(String sessID, String name, CustomField[] fields) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        InsertQuery query = new InsertQuery(table.getTable());
        query.addColumn(table.getDBColumn("name"), name);
        PooledConnection c = ConnectionController.connectPooled(sessID);
        PreparedStatement stmt = c.prepareStatement(query.toString(), 1);
        stmt.execute();
        ResultSet res = stmt.getGeneratedKeys();
        res.next();
        int projID = res.getInt(1);
        PatientManager.getInstance().createPatientTable(sessID, projID, fields);
        c.close();
        return projID;
    }

    @Override
    public void removeProject(String sid, String projectName) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("project_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("name"), projectName));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            this.removeProject(sid, rs.getInt(1));
        }
    }

    @Override
    public void removeProject(String sid, int projectid) throws SQLException, RemoteException, SessionExpiredException {
        int[] cohIDs;
        PooledConnection c = ConnectionController.connectPooled(sid);
        MedSavantDatabase.ProjectTableSchema projectTable = MedSavantDatabase.ProjectTableSchema;
        MedSavantDatabase.PatientTablemapTableSchema patientMapTable = MedSavantDatabase.PatienttablemapTableSchema;
        MedSavantDatabase.PatientFormatTableSchema patientFormatTable = MedSavantDatabase.PatientformatTableSchema;
        MedSavantDatabase.VariantTablemapTableSchema variantMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        DeleteQuery q1 = new DeleteQuery(projectTable.getTable());
        q1.addCondition(BinaryConditionMS.equalTo(projectTable.getDBColumn("project_id"), projectid));
        c.createStatement().execute(q1.toString());
        SelectQuery q2 = new SelectQuery();
        q2.addFromTable(patientMapTable.getTable());
        q2.addColumns(patientMapTable.getDBColumn("patient_tablename"));
        q2.addCondition(BinaryConditionMS.equalTo(patientMapTable.getDBColumn("project_id"), projectid));
        ResultSet rs1 = ConnectionController.executeQuery(sid, q2.toString());
        rs1.next();
        String patientTableName = rs1.getString("patient_tablename");
        c.createStatement().execute("DROP TABLE IF EXISTS " + patientTableName);
        DeleteQuery q3 = new DeleteQuery(patientFormatTable.getTable());
        q3.addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("project_id"), projectid));
        c.createStatement().execute(q3.toString());
        DeleteQuery q4 = new DeleteQuery(patientMapTable.getTable());
        q4.addCondition(BinaryConditionMS.equalTo(patientMapTable.getDBColumn("project_id"), projectid));
        c.createStatement().execute(q4.toString());
        SelectQuery q5 = new SelectQuery();
        q5.addFromTable(variantMapTable.getTable());
        q5.addColumns(variantMapTable.getDBColumn("variant_tablename"));
        q5.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("project_id"), projectid));
        ResultSet rs2 = ConnectionController.executeQuery(sid, q5.toString());
        while (rs2.next()) {
            String variantTableName = rs2.getString(1);
            c.createStatement().execute("DROP TABLE IF EXISTS " + variantTableName);
        }
        DeleteQuery q6 = new DeleteQuery(variantMapTable.getTable());
        q6.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("project_id"), projectid));
        c.createStatement().execute(q6.toString());
        for (int cohID : cohIDs = CohortManager.getInstance().getCohortIDs(sid, projectid)) {
            CohortManager.getInstance().removeCohort(sid, cohID);
        }
        c.close();
    }

    @Override
    public void setAnnotations(String sessID, int projID, int refID, int updID, String annIDs) throws SQLException, SessionExpiredException {
        String tablename = this.getNameOfVariantTable(sessID, projID, refID, true, false);
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addSetClause(table.getDBColumn("annotation_ids"), annIDs);
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refID));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("update_id"), updID));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("variant_tablename"), tablename));
        ConnectionController.executeUpdate(sessID, query.toString());
    }

    @Override
    public ProjectDetails[] getProjectDetails(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema variantMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(variantMapTable.getTable());
        query.addAllColumns();
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, variantMapTable.getTable(), refTable.getTable(), BinaryConditionMS.equalTo(variantMapTable.getDBColumn("reference_id"), refTable.getDBColumn("reference_id")));
        query.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("project_id"), projID));
        query.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("published"), true));
        query.addOrdering(variantMapTable.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Integer> refs = new ArrayList<Integer>();
        ArrayList<ProjectDetails> result = new ArrayList<ProjectDetails>();
        while (rs.next()) {
            int[] annIDs;
            if (refs.contains(rs.getInt("reference_id"))) continue;
            String annString = rs.getString("annotation_ids");
            if (annString != null) {
                String[] anns = annString.split(",");
                annIDs = new int[anns.length];
                for (int i = 0; i < anns.length; ++i) {
                    annIDs[i] = Integer.parseInt(anns[i]);
                }
            } else {
                annIDs = new int[]{};
            }
            result.add(new ProjectDetails(rs.getInt("project_id"), rs.getInt("reference_id"), rs.getInt("update_id"), rs.getBoolean("published"), null, rs.getString("name"), annIDs));
            refs.add(rs.getInt("reference_id"));
        }
        return result.toArray(new ProjectDetails[0]);
    }

    @Override
    public void renameProject(String sid, int projectId, String newName) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ProjectTableSchema table = MedSavantDatabase.ProjectTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addSetClause(table.getDBColumn("name"), newName);
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        ConnectionController.executeUpdate(sid, query.toString());
    }

    @Override
    public void setCustomVariantFields(String sid, int projectId, int referenceId, int updateId, CustomField[] fields) throws SQLException, SessionExpiredException {
        PooledConnection c = ConnectionController.connectPooled(sid);
        MedSavantDatabase.VariantFormatTableSchema table = MedSavantDatabase.VariantformatTableSchema;
        c.setAutoCommit(false);
        for (int i = 0; i < fields.length; ++i) {
            CustomField f = fields[i];
            InsertQuery insertQuery = new InsertQuery(table.getTable());
            insertQuery.addColumn(table.getDBColumn("project_id"), projectId);
            insertQuery.addColumn(table.getDBColumn("reference_id"), referenceId);
            insertQuery.addColumn(table.getDBColumn("update_id"), updateId);
            insertQuery.addColumn(table.getDBColumn("position"), i);
            insertQuery.addColumn(table.getDBColumn("column_name"), f.getColumnName());
            insertQuery.addColumn(table.getDBColumn("column_type"), f.getTypeString());
            insertQuery.addColumn(table.getDBColumn("filterable"), f.isFilterable() ? "1" : "0");
            insertQuery.addColumn(table.getDBColumn("alias"), f.getAlias());
            insertQuery.addColumn(table.getDBColumn("description"), f.getDescription());
            c.createStatement().execute(insertQuery.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    @Deprecated
    private CustomField[] getCustomVariantFields(String sid, int projectId, int referenceId, int updateId, boolean considerUnpublished) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantFormatTableSchema table = MedSavantDatabase.VariantformatTableSchema;
        MedSavantDatabase.VariantTablemapTableSchema variantTableMap = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        Column[] cols = new Column[table.getColumns().size()];
        int i = 0;
        for (DbColumn c : table.getColumns()) {
            cols[i++] = c;
        }
        query.addColumns(cols);
        if (!considerUnpublished) {
            ComboCondition joinCondition = ComboCondition.and(BinaryCondition.equalTo(table.getDBColumn("project_id"), variantTableMap.getDBColumn("project_id")), BinaryCondition.equalTo(table.getDBColumn("reference_id"), variantTableMap.getDBColumn("reference_id")), BinaryCondition.equalTo(table.getDBColumn("update_id"), variantTableMap.getDBColumn("update_id")));
            query.addJoin(SelectQuery.JoinType.INNER, table.getTable(), variantTableMap.getTable(), joinCondition);
        } else {
            query.addFromTable(table.getTable());
        }
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), referenceId));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("update_id"), updateId));
        if (!considerUnpublished) {
            query.addCondition(BinaryCondition.equalTo(variantTableMap.getDBColumn("published"), 1));
        }
        query.addOrdering(table.getDBColumn("position"), OrderObject.Dir.ASCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<CustomField> result = new ArrayList<CustomField>();
        while (rs.next()) {
            result.add(new CustomField(rs.getString("column_name"), rs.getString("column_type"), rs.getBoolean("filterable"), rs.getString("alias"), rs.getString("description")));
        }
        return result.toArray(new CustomField[0]);
    }

    @Override
    public CustomField[] getCustomVariantFields(String sid, int projectId, int referenceId, int updateId) throws SQLException, SessionExpiredException {
        return this.getCustomVariantFields(sid, projectId, referenceId, updateId, false);
    }

    @Override
    public int getNewestUpdateID(String sid, int projectId, int referenceId, boolean published) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("update_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), referenceId));
        if (published) {
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("published"), true));
        }
        query.addOrdering(table.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        return rs.getInt("update_id");
    }

    public void publishVariantTable(String sid, int projId, int refID) throws IOException, SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sid);
        this.publishVariantTable(sid, conn, projId, refID);
    }

    public void publishVariantTable(String sid, PooledConnection conn, int projId, int refID) throws IOException, SQLException, SessionExpiredException {
        this.publishVariantTable(sid, conn, projId, new int[]{refID});
    }

    public void publishVariantTable(String sid, PooledConnection conn, int projID, int[] refIDs) throws IOException, SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema variantTableMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        MedSavantDatabase.VariantFormatTableSchema variantFormatTable = MedSavantDatabase.VariantformatTableSchema;
        SetupMedSavantDatabase.makeVariantFileIBTable(sid);
        HashSet<String> tablesToDrop = new HashSet<String>();
        for (int refID : refIDs) {
            String fileTableName = SetupMedSavantDatabase.getVariantFileIBTableName();
            String variantTableName = this.getNameOfVariantTable(sid, projID, refID, false, false);
            String subTableName = this.getNameOfVariantTable(sid, projID, refID, false, true);
            String variantViewName = DBSettings.getVariantViewName(projID, refID);
            String variantSubViewName = DBSettings.getVariantSubsetViewName(projID, refID);
            conn.executeUpdate("DROP VIEW IF EXISTS " + variantViewName);
            String viewQuery = "CREATE VIEW " + variantViewName + " AS " + "SELECT " + variantTableName + ".* FROM " + variantTableName + ", " + fileTableName + " WHERE (" + fileTableName + "." + "file_id" + " = " + variantTableName + "." + BasicVariantColumns.FILE_ID.getColumnName() + " AND " + fileTableName + "." + "upload_id" + " = " + variantTableName + "." + BasicVariantColumns.UPLOAD_ID.getColumnName() + " AND " + fileTableName + "." + "project_id" + " = " + projID + " AND " + fileTableName + "." + "reference_id" + " = " + refID + ")";
            LOG.info((Object)viewQuery);
            conn.executeUpdate(viewQuery);
            if (subTableName != null && !subTableName.isEmpty()) {
                conn.executeUpdate("DROP VIEW IF EXISTS " + variantSubViewName);
                viewQuery = "CREATE VIEW " + variantSubViewName + " AS " + "SELECT " + subTableName + ".* FROM " + subTableName + ", " + fileTableName + " WHERE (" + fileTableName + "." + "file_id" + " = " + subTableName + "." + BasicVariantColumns.FILE_ID.getColumnName() + " AND " + fileTableName + "." + "upload_id" + " = " + subTableName + "." + BasicVariantColumns.UPLOAD_ID.getColumnName() + " AND " + fileTableName + "." + "project_id" + " = " + projID + " AND " + fileTableName + "." + "reference_id" + " = " + refID + ")";
                conn.executeUpdate(viewQuery);
                LOG.info((Object)viewQuery);
            }
            SelectQuery sq = new SelectQuery();
            sq.addFromTable(variantTableMapTable.getTable());
            sq.addAllColumns();
            sq.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("project_id"), projID));
            sq.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("reference_id"), refID));
            sq.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("published"), true));
            ResultSet rs = conn.executeQuery(sq.toString());
            while (rs.next()) {
                String tn = rs.getString("variant_tablename");
                String sn = rs.getString("variant_subset_tablename");
                if (!tn.equals(variantTableName)) {
                    tablesToDrop.add(tn);
                }
                if (sn.equals(subTableName)) continue;
                tablesToDrop.add(sn);
            }
            float multiplier = this.getMultiplier(sid, variantViewName, variantSubViewName);
            UpdateQuery query = new UpdateQuery(variantTableMapTable.getTable());
            query.addSetClause(variantTableMapTable.getDBColumn("variant_tablename"), variantTableName);
            query.addSetClause(variantTableMapTable.getDBColumn("variant_subset_tablename"), subTableName);
            query.addSetClause(variantTableMapTable.getDBColumn("subset_multiplier"), Float.valueOf(multiplier));
            query.addSetClause(variantTableMapTable.getDBColumn("published"), true);
            query.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("project_id"), projID));
            query.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("reference_id"), refID));
            conn.executeUpdate(query.toString());
            int u = this.getNewestUpdateID(sid, projID, refID, true);
            DeleteQuery dq = new DeleteQuery(variantFormatTable.getTable());
            dq.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("project_id"), projID));
            dq.addCondition(BinaryConditionMS.equalTo(variantTableMapTable.getDBColumn("reference_id"), refID));
            dq.addCondition(BinaryCondition.notEqualTo(variantTableMapTable.getDBColumn("update_id"), u));
            conn.executeUpdate(dq.toString());
        }
        for (String tableToDrop : tablesToDrop) {
            DBUtils.dropTable(sid, tableToDrop);
        }
        ProjectManager.cleanStaleGenotypeFiles(sid, projID);
    }

    public boolean hasUnpublishedChanges(String sessId, int projId, int refId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projId));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("reference_id"), refId));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("published"), false));
        query.addOrdering(table.getDBColumn("update_id"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sessId, query.toString());
        return rs.first();
    }

    @Override
    public ProjectDetails[] getUnpublishedChanges(String sessID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema variantMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        MedSavantDatabase.ProjectTableSchema projectTable = MedSavantDatabase.ProjectTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(variantMapTable.getTable());
        query.addAliasedColumn(projectTable.getDBColumn("name"), "A");
        query.addAliasedColumn(refTable.getDBColumn("name"), "B");
        query.addAllTableColumns(variantMapTable.getTable());
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, variantMapTable.getTable(), refTable.getTable(), BinaryConditionMS.equalTo(variantMapTable.getDBColumn("reference_id"), refTable.getDBColumn("reference_id")));
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, variantMapTable.getTable(), projectTable.getTable(), BinaryConditionMS.equalTo(variantMapTable.getDBColumn("project_id"), projectTable.getDBColumn("project_id")));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        HashMap map = new HashMap();
        ArrayList<ProjectDetails> unpublished = new ArrayList<ProjectDetails>();
        while (rs.next()) {
            int projID = rs.getInt("project_id");
            int refID = rs.getInt("reference_id");
            int updID = rs.getInt("update_id");
            boolean published = rs.getBoolean("published");
            if (!map.containsKey(projID)) {
                map.put(projID, new HashMap());
            }
            if (((Map)map.get(projID)).containsKey(refID) && ((ProjectDetails)((Map)map.get(projID)).get(refID)).getUpdateID() >= updID) continue;
            ProjectDetails pd = new ProjectDetails(projID, refID, updID, published, rs.getString("A"), rs.getString("B"), null);
            ((Map)map.get(projID)).put(refID, pd);
            if (pd.isPublished()) continue;
            unpublished.add(pd);
        }
        return unpublished.toArray(new ProjectDetails[0]);
    }

    @Override
    public String[] getReferenceNamesForProject(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ReferenceTableSchema refTable = MedSavantDatabase.ReferenceTableSchema;
        MedSavantDatabase.VariantTablemapTableSchema variantMapTable = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(variantMapTable.getTable());
        query.addColumns(refTable.getDBColumn("name"));
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, variantMapTable.getTable(), refTable.getTable(), BinaryConditionMS.equalTo(refTable.getDBColumn("reference_id"), variantMapTable.getDBColumn("reference_id")));
        query.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("project_id"), projID));
        query.addCondition(BinaryConditionMS.equalTo(variantMapTable.getDBColumn("published"), true));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<String> references = new ArrayList<String>();
        while (rs.next()) {
            if (references.contains(rs.getString(1))) continue;
            references.add(rs.getString(1));
        }
        return references.toArray(new String[0]);
    }

    @Override
    public int[] getReferenceIDsForProject(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema table = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("reference_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("published"), true));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Integer> references = new ArrayList<Integer>();
        while (rs.next()) {
            references.add(rs.getInt(1));
        }
        return ArrayUtils.toPrimitive((Integer[])references.toArray(new Integer[0]));
    }

    public synchronized void cancelPublish(String sessID, int projID, int refID) throws SQLException, SessionExpiredException, IOException {
        MedSavantDatabase.VariantTablemapTableSchema mapTable = MedSavantDatabase.VarianttablemapTableSchema;
        String idRestriction = "(reference_id=" + refID + " AND " + "project_id" + "=" + projID + ")";
        String query = "SELECT DISTINCT " + mapTable.getTableName() + "." + "variant_tablename" + "," + mapTable.getTableName() + "." + "variant_subset_tablename" + " FROM " + mapTable.getTableName() + " WHERE " + idRestriction + " AND " + "published" + " = 0 AND " + "variant_tablename" + " NOT IN " + "(SELECT " + "variant_tablename" + " FROM " + mapTable.getTableName() + " WHERE " + idRestriction + " AND " + "published" + " = 1)";
        ResultSet rs = ConnectionController.executeQuery(sessID, query);
        ArrayList<Integer> droppedUpdateIDs = new ArrayList<Integer>();
        while (rs.next()) {
            String tableToDrop = rs.getString("variant_tablename");
            VariantManagerUtils.dropTableIfExists(sessID, tableToDrop);
            tableToDrop = rs.getString("variant_subset_tablename");
            VariantManagerUtils.dropTableIfExists(sessID, tableToDrop);
            droppedUpdateIDs.add(rs.getInt("update_id"));
        }
        DeleteQuery dq1 = new DeleteQuery(mapTable.getTable());
        dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("project_id"), projID));
        dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("reference_id"), refID));
        dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("published"), 0));
        ConnectionController.executeUpdate(sessID, dq1.toString());
        LOG.info((Object)("Deleting unpublished tables from the variant table map: " + dq1.toString()));
        MedSavantDatabase.VariantFormatTableSchema formatTable = MedSavantDatabase.VariantformatTableSchema;
        Iterator i$ = droppedUpdateIDs.iterator();
        while (i$.hasNext()) {
            int uid = (Integer)i$.next();
            dq1 = new DeleteQuery(formatTable.getTable());
            dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("project_id"), projID));
            dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("reference_id"), refID));
            dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("update_id"), uid));
            LOG.info((Object)("Deleting unpublished entries from variant format table: " + dq1.toString()));
            ConnectionController.executeUpdate(sessID, dq1.toString());
        }
        this.restorePublishedFileTable(sessID);
        ProjectManager.cleanStaleGenotypeFiles(sessID, projID);
    }

    public void restorePublishedFileTable(String sessID) throws SQLException, SessionExpiredException, IOException {
        MedSavantDatabase.VariantFileTableSchema fileTable = MedSavantDatabase.VariantFileTableSchema;
        VariantManagerUtils.dropTableIfExists(sessID, fileTable.getTableName());
        SetupMedSavantDatabase.makeVariantFileTable(sessID, false);
        String query = "INSERT INTO " + fileTable.getTableName() + " SELECT * FROM " + SetupMedSavantDatabase.getVariantFileIBTableName();
        ConnectionController.executeUpdate(sessID, query);
    }

    private static synchronized void cleanStaleGenotypeFiles(String sessID, int projID) throws SQLException, SessionExpiredException, RemoteException {
        File[] listOfFiles;
        String database = SessionManager.getInstance().getDatabaseForSession(sessID);
        MedSavantDatabase.VariantFileTableSchema fileTable = MedSavantDatabase.VariantFileTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(fileTable.getTable());
        Column[] columnArray = new Column[1];
        columnArray[0] = fileTable.getDBColumn("file_name");
        query.addColumns(columnArray);
        query.addCondition(BinaryConditionMS.equalTo(fileTable.getDBColumn("project_id"), projID));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        HashSet<String> fileNames = new HashSet<String>();
        while (rs.next()) {
            fileNames.add(rs.getString(1));
        }
        File genotypeDir = DirectorySettings.getGenoTypeDirectory(database, projID);
        for (File f : listOfFiles = genotypeDir.listFiles()) {
            if (fileNames.contains(f.getAbsolutePath())) continue;
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeTables(String sessID, int projID, int refID, int updateMax, int updateMin) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantTablemapTableSchema mapTable = MedSavantDatabase.VarianttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(mapTable.getTable());
        query.addColumns(mapTable.getDBColumn("update_id"), mapTable.getDBColumn("variant_tablename"));
        query.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("project_id"), projID));
        query.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("reference_id"), refID));
        query.addCondition(ComboCondition.and(BinaryCondition.lessThan(mapTable.getDBColumn("update_id"), updateMax, true), BinaryCondition.greaterThan(mapTable.getDBColumn("update_id"), updateMin, true)));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            while (rs.next()) {
                int updateId = rs.getInt(1);
                String tableName = rs.getString(2);
                VariantManagerUtils.dropTableIfExists(sessID, tableName);
                DeleteQuery dq1 = new DeleteQuery(mapTable.getTable());
                dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("project_id"), projID));
                dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("reference_id"), refID));
                dq1.addCondition(BinaryConditionMS.equalTo(mapTable.getDBColumn("update_id"), updateId));
                conn.executeUpdate(dq1.toString());
                MedSavantDatabase.VariantFormatTableSchema formatTable = MedSavantDatabase.VariantformatTableSchema;
                DeleteQuery dq2 = new DeleteQuery(formatTable.getTable());
                dq2.addCondition(BinaryConditionMS.equalTo(formatTable.getDBColumn("project_id"), projID));
                dq2.addCondition(BinaryConditionMS.equalTo(formatTable.getDBColumn("reference_id"), refID));
                dq2.addCondition(BinaryConditionMS.equalTo(formatTable.getDBColumn("update_id"), updateId));
            }
        }
        finally {
            conn.close();
        }
    }
}

