/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import java.rmi.RemoteException;
import java.sql.SQLException;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.serverapi.ProjectManager;
import org.ut.biolab.medsavant.shared.model.Notification;
import org.ut.biolab.medsavant.shared.model.ProjectDetails;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.NotificationManagerAdapter;

public class NotificationManager
extends MedSavantServerUnicastRemoteObject
implements NotificationManagerAdapter {
    private static NotificationManager instance;

    private NotificationManager() throws RemoteException {
    }

    public static synchronized NotificationManager getInstance() throws RemoteException {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    @Override
    public Notification[] getNotifications(String sessID, String user) throws SQLException, RemoteException, SessionExpiredException {
        ProjectDetails[] unpublished = ProjectManager.getInstance().getUnpublishedChanges(sessID);
        Notification[] result = new Notification[unpublished.length];
        for (int i = 0; i < unpublished.length; ++i) {
            ProjectDetails pd = unpublished[i];
            result[i] = new Notification(Notification.Type.PUBLISH, "The variant table for project " + pd.getProjectName() + " and reference " + pd.getReferenceName() + " has not yet been published. ", pd);
        }
        return result;
    }
}

