/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.Block;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GeneSet;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.GeneSetManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class GeneSetManager
extends MedSavantServerUnicastRemoteObject
implements GeneSetManagerAdapter,
MedSavantDatabase.GeneSetColumns {
    private static final Log LOG = LogFactory.getLog(GeneSetManager.class);
    private static GeneSetManager instance;

    public static synchronized GeneSetManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new GeneSetManager();
        }
        return instance;
    }

    private GeneSetManager() throws RemoteException, SessionExpiredException {
    }

    @Override
    public GeneSet[] getGeneSets(String sessID) throws SQLException, SessionExpiredException {
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.distinct().groupBy(GENOME).select(GENOME, TYPE, "COUNT(DISTINCT name)");
        LOG.info((Object)("getGeneSets:" + query));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<GeneSet> result = new ArrayList<GeneSet>();
        while (rs.next()) {
            result.add(new GeneSet(rs.getString(1), rs.getString(2), rs.getInt(3)));
        }
        return result.toArray(new GeneSet[0]);
    }

    @Override
    public GeneSet getGeneSet(String sessID, String refName) throws SQLException, SessionExpiredException {
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.distinct().where(GENOME, refName).select(TYPE, "COUNT(DISTINCT name)");
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        if (rs.next()) {
            return new GeneSet(refName, rs.getString(1), rs.getInt(2));
        }
        return null;
    }

    public static void main(String[] argv) {
        TableSchema table = MedSavantDatabase.GeneSetTableSchema;
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.where(GENOME, "hg19", TYPE, "RefSeq").groupBy(CHROM).groupBy(NAME).select(NAME, CHROM, "MIN(start)", "MAX(end)", "MIN(codingStart)", "MAX(codingEnd)");
        BinaryCondition dumbChrsCondition1 = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.CHROM), "%\\_%");
        query.addCondition(dumbChrsCondition1);
        BinaryCondition dumbChrsCondition2 = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.CHROM), "%\\-%");
        query.addCondition(dumbChrsCondition2);
    }

    @Override
    public Gene[] getGenes(String sessID, GeneSet geneSet) throws SQLException, SessionExpiredException {
        TableSchema table = MedSavantDatabase.GeneSetTableSchema;
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.where(GENOME, geneSet.getReference(), TYPE, geneSet.getType()).groupBy(CHROM).groupBy(NAME).select(NAME, CHROM, "MIN(start)", "MAX(end)", "MIN(codingStart)", "MAX(codingEnd)");
        BinaryCondition dumbChrsCondition = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.CHROM), "%\\_%");
        query.addCondition(dumbChrsCondition);
        BinaryCondition dumbNameCondition = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.NAME), "%-%");
        query.addCondition(dumbNameCondition);
        return this.getGenes(sessID, table, geneSet, query);
    }

    @Override
    public Gene[] getGenesInRegion(String sessID, GeneSet geneSet, String chrom, int start_position, int end_position) throws SQLException, SessionExpiredException {
        TableSchema table = MedSavantDatabase.GeneSetTableSchema;
        ComboCondition restrictToRegion = ComboCondition.and(BinaryCondition.equalTo(table.getDBColumn(MedSavantDatabase.GeneSetColumns.CHROM), chrom), ComboCondition.or(ComboCondition.and(BinaryCondition.lessThan(table.getDBColumn(MedSavantDatabase.GeneSetColumns.START), start_position, true), BinaryCondition.greaterThan(table.getDBColumn(MedSavantDatabase.GeneSetColumns.END), start_position, true)), ComboCondition.and(BinaryCondition.lessThan(table.getDBColumn(MedSavantDatabase.GeneSetColumns.START), end_position, true), BinaryCondition.greaterThan(table.getDBColumn(MedSavantDatabase.GeneSetColumns.END), end_position, true))), BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.NAME), "%-%"));
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.where(GENOME, geneSet.getReference(), TYPE, geneSet.getType()).groupBy(CHROM).groupBy(NAME).select(NAME, CHROM, "MIN(start)", "MAX(end)", "MIN(codingStart)", "MAX(codingEnd)");
        query.addCondition(restrictToRegion);
        return this.getGenes(sessID, table, geneSet, query);
    }

    private Gene[] getGenes(String sessID, TableSchema table, GeneSet geneSet, SelectQuery query) throws SQLException, SessionExpiredException {
        BinaryCondition dumbChrsCondition = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.CHROM), "%\\_%");
        query.addCondition(dumbChrsCondition);
        BinaryCondition dumbNameCondition = BinaryConditionMS.notlike(table.getDBColumn(MedSavantDatabase.GeneSetColumns.NAME), "%-%");
        query.addCondition(dumbNameCondition);
        LOG.info((Object)query);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        Gene[] result = new Gene[geneSet.getSize()];
        int i = 0;
        while (rs.next()) {
            Gene g = new Gene(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), null);
            result[i++] = g;
        }
        if (i != result.length) {
            LOG.info((Object)("There were " + result.length + " genes, but only " + i + " were loaded."));
        }
        result = Arrays.copyOf(result, i);
        return result;
    }

    @Override
    public Gene[] getTranscripts(String sessID, GeneSet geneSet) throws SQLException, SessionExpiredException {
        SelectQuery query = MedSavantDatabase.GeneSetTableSchema.where(GENOME, geneSet.getReference(), TYPE, geneSet.getType()).select(NAME, CHROM, START, END, CODING_START, CODING_END, TRANSCRIPT);
        LOG.debug((Object)query);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        Gene[] result = new Gene[geneSet.getSize()];
        int i = 0;
        while (rs.next()) {
            result[i++] = new Gene(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getString(7));
        }
        return result;
    }

    @Override
    public Block[] getBlocks(String sessID, Gene gene) throws SQLException, RemoteException, SessionExpiredException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

