/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.ontology;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.model.OntologyTerm;
import org.ut.biolab.medsavant.shared.model.OntologyType;
import org.ut.biolab.medsavant.shared.util.RemoteFileCache;

public class OBOParser {
    private static final Log LOG = LogFactory.getLog(OBOParser.class);
    private final OntologyType ontology;
    private int lineNum;

    public OBOParser(OntologyType ont) {
        this.ontology = ont;
    }

    Map<String, OntologyTerm> load(URL source) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(RemoteFileCache.getCacheFile(source)));
        HashMap<String, OntologyTerm> terms = new HashMap<String, OntologyTerm>();
        while ((line = reader.readLine()) != null) {
            OntologyTerm t;
            ++this.lineNum;
            if (!line.equals("[Term]") || (t = this.parseNextTerm(reader)) == null) continue;
            if (t.getID() == null || t.getName() == null) {
                LOG.info((Object)String.format("Defective ontology term at line %d: %s/%s", this.lineNum, t.getID(), t.getName()));
                break;
            }
            if (t.getID().startsWith("results")) {
                LOG.info((Object)String.format("Loading \"%s\" at line %d.", line, this.lineNum));
            }
            terms.put(t.getID(), t);
        }
        return terms;
    }

    private OntologyTerm parseNextTerm(BufferedReader reader) throws IOException {
        String line;
        String id = null;
        String name = null;
        String description = null;
        ArrayList<String> altIDs = new ArrayList<String>();
        ArrayList<String> parentIDs = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int colonPos;
            if (line.startsWith("[")) {
                reader.reset();
                break;
            }
            ++this.lineNum;
            if (line.length() > 0 && line.charAt(0) != '!' && (colonPos = line.indexOf(":")) > 0) {
                String key = line.substring(0, colonPos);
                String value = line.substring(colonPos + 1);
                int commentPos = OBOParser.indexOf(value, '!');
                if (commentPos > 0) {
                    value = value.substring(0, commentPos);
                }
                value = value.trim();
                if (key.equals("id")) {
                    id = value;
                } else if (key.equals("alt_id")) {
                    altIDs.add(value);
                } else if (key.equals("name")) {
                    name = value;
                } else if (key.equals("def")) {
                    int quotePos = OBOParser.indexOf(value, '\"');
                    if (quotePos >= 0 && (quotePos = OBOParser.indexOf(value = value.substring(quotePos + 1), '\"')) >= 0) {
                        value = value.substring(0, quotePos);
                        description = value.replace("\\", "");
                    }
                } else if (key.equals("is_a")) {
                    parentIDs.add(value);
                } else if (key.equals("is_obsolete") && value.equals("true")) {
                    return null;
                }
            }
            reader.mark(10);
        }
        return new OntologyTerm(this.ontology, id, name, description, altIDs.toArray(new String[0]), parentIDs.toArray(new String[0]));
    }

    private static int indexOf(String s, char c) {
        int pos = s.indexOf(c);
        while (pos > 0 && s.charAt(pos - 1) == '\\') {
            pos = s.indexOf(c, pos + 1);
        }
        return pos;
    }
}

